/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.ActivitiesActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.MilestoneActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.PeopleActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.ProjectInfoActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.Requests;
import com.b2lmobitech.fieldcloudplus.task.activities.TaskListActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.TaskManagementActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddProjectActivity;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectActivity
extends AppCompatActivity {
    String projectid;
    Preference preference;
    MenuItem editProject;
    MenuItem deleteProject;
    TextView projectName;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492983);
        this.projectid = this.getIntent().getStringExtra("id");
        if (this.projectid == null) {
            this.projectid = Preference.getInstance((Context)this).getProjectId();
        }
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Project");
        this.projectName = (TextView)this.findViewById(2131297201);
        this.projectName.setText((CharSequence)Database.getInstance((Context)this).getProjectName(this.projectid));
        final MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        this.findViewById(2131297008).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent(ProjectActivity.this.getApplicationContext(), MilestoneActivity.class);
                intent.putExtra("id", ProjectActivity.this.projectid);
                ProjectActivity.this.startActivity(intent);
            }
        });
        this.findViewById(2131297467).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent(ProjectActivity.this.getApplicationContext(), TaskListActivity.class);
                intent.putExtra("id", ProjectActivity.this.projectid);
                ProjectActivity.this.startActivity(intent);
            }
        });
        this.findViewById(2131297199).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent(ProjectActivity.this.getApplicationContext(), ProjectInfoActivity.class);
                intent.putExtra("id", ProjectActivity.this.projectid);
                ProjectActivity.this.startActivity(intent);
            }
        });
        this.findViewById(2131297260).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (myRequestQueue.isNoNetwork()) {
                    return;
                }
                Intent intent = new Intent(ProjectActivity.this.getApplicationContext(), Requests.class);
                intent.putExtra("id", ProjectActivity.this.projectid);
                ProjectActivity.this.startActivity(intent);
            }
        });
        this.preference = Preference.getInstance((Context)this);
        if (this.preference.isAdmin() || Database.getInstance((Context)this).isResponsibleForThisProject(this.projectid, this.preference.getEmailId())) {
            this.findViewById(2131297469).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (myRequestQueue.isNoNetwork()) {
                        return;
                    }
                    Intent intent = new Intent(ProjectActivity.this.getApplicationContext(), TaskManagementActivity.class);
                    intent.putExtra("id", ProjectActivity.this.projectid);
                    ProjectActivity.this.startActivity(intent);
                }
            });
            this.findViewById(2131297149).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (myRequestQueue.isNoNetwork()) {
                        return;
                    }
                    Intent intent = new Intent(ProjectActivity.this.getApplicationContext(), PeopleActivity.class);
                    intent.putExtra("id", ProjectActivity.this.projectid);
                    ProjectActivity.this.startActivity(intent);
                }
            });
            this.findViewById(2131296344).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (myRequestQueue.isNoNetwork()) {
                        return;
                    }
                    Intent intent = new Intent(ProjectActivity.this.getApplicationContext(), ActivitiesActivity.class);
                    intent.putExtra("id", ProjectActivity.this.projectid);
                    ProjectActivity.this.startActivity(intent);
                }
            });
        } else {
            this.findViewById(2131297469).setVisibility(8);
            this.findViewById(2131297149).setVisibility(8);
            this.findViewById(2131296344).setVisibility(4);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558446, menu2);
        this.editProject = menu2.findItem(2131296707);
        this.deleteProject = menu2.findItem(2131296649);
        this.editProject.setVisible(false);
        this.deleteProject.setVisible(false);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
            case 2131296707: {
                if (MyRequestQueue.getInstance((Activity)this).isNoNetwork()) break;
                Intent intent = new Intent((Context)this, AddProjectActivity.class);
                intent.putExtra("id", this.projectid);
                this.startActivity(intent);
                break;
            }
            case 2131296649: {
                this.showAlert();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onResume() {
        super.onResume();
        this.getProjectsDetails();
    }

    private void getProjectsDetails() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("id", this.projectid);
        params.put("list", Database.getInstance((Context)this).getProjectsList().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_projects.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    ProjectActivity.this.getProjects(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getProjects(JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray = jsonObject.getJSONArray("projects");
        try {
            Database.getInstance((Context)this).insertProjects(jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.projectName.setText((CharSequence)Database.getInstance((Context)this).getProjectName(this.projectid));
        if (Preference.getInstance((Context)this).isResponsible(this.projectid)) {
            this.editProject.setVisible(true);
            this.deleteProject.setVisible(true);
        } else {
            this.editProject.setVisible(false);
            this.deleteProject.setVisible(false);
        }
    }

    private void deleteProject() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("mail", preference.getEmailId());
        params.put("type", preference.getCompnayType());
        params.put("id", this.projectid);
        if (preference.isAdmin()) {
            params.put("role", preference.getDesignation());
        } else {
            params.put("role", "project");
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/delete_project.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)ProjectActivity.this.getApplicationContext(), (CharSequence)"Project deleted", (int)0).show();
                        Database.getInstance(ProjectActivity.this.getApplicationContext()).deleteProject(ProjectActivity.this.projectid);
                        ProjectActivity.this.finish();
                    } else {
                        Toast.makeText((Context)ProjectActivity.this.getApplicationContext(), (CharSequence)"Unable to delete project", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void showAlert() {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)"Project Will be deleted").setPositiveButton((CharSequence)"CONTINUE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                ProjectActivity.this.deleteProject();
            }
        }).setNegativeButton((CharSequence)"CLOSE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        }).show();
    }
}

