/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.Context;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectInfoActivity
extends AppCompatActivity {
    TextView projectName;
    TextView projectDescription;
    LinearLayout projectDetails;
    String id;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492984);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Project Details");
        this.projectDetails = (LinearLayout)this.findViewById(2131297198);
        this.projectDescription = (TextView)this.findViewById(2131297197);
        this.projectName = (TextView)this.findViewById(2131297201);
        this.id = this.getIntent().getStringExtra("id");
        try {
            this.getProjectDetais();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void getProjectDetais() throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONObject jsonObject = database.getProjectDetails(this.id);
        this.projectDetails.removeAllViews();
        this.projectName.setText((CharSequence)jsonObject.getString(ProjectTable.PROJECTNAME));
        if (jsonObject.getString(ProjectTable.DESCRIPTION).isEmpty()) {
            this.projectDescription.setText(2131820685);
        } else {
            this.projectDescription.setText((CharSequence)jsonObject.getString(ProjectTable.DESCRIPTION));
        }
        this.addView("Start", jsonObject.getString(ProjectTable.STARTDATE));
        this.addView("End", jsonObject.getString(ProjectTable.ENDDATE));
        this.addView("Responsible", database.getEmployeeName(jsonObject.getString(ProjectTable.RESPONSIBLEPERSON)));
        this.addView("Created On", jsonObject.getString(ProjectTable.CREATEDDATETIME));
        this.addView("Created By", database.getEmployeeName(jsonObject.getString(ProjectTable.CREATEDBY)));
    }

    private void addView(String key, String pair) {
        View view = this.getLayoutInflater().inflate(2131493227, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        TextView pairText = (TextView)view.findViewById(2131297136);
        keyText.setText((CharSequence)key);
        pairText.setText((CharSequence)pair);
        this.projectDetails.addView(view);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

