/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.listener.LocationUpdateListener;
import com.b2lmobitech.fieldcloudplus.task.others.LocationUpdate;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.google.android.material.snackbar.Snackbar;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class RejectForm
extends AppCompatActivity {
    TextView projectName;
    TextView taskName;
    TextView milestoneName;
    TextView requestType;
    EditText requesetReason;
    String requestFor;
    String url = "";
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    String assignId;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492993);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.requestFor = this.getIntent().getStringExtra("request");
        this.assignId = this.getIntent().getStringExtra("id");
        if (this.requestFor.equalsIgnoreCase("reject")) {
            this.url = "http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/task_reject.php";
            this.getSupportActionBar().setTitle((CharSequence)"Reject Task");
        } else {
            this.url = "http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/task_stop.php";
            this.getSupportActionBar().setTitle((CharSequence)"Stop Task");
        }
        this.findViewById(2131297681).setVisibility(8);
        this.getWidgets();
        try {
            this.setValues();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void getWidgets() {
        this.projectName = (TextView)this.findViewById(2131297202);
        this.taskName = (TextView)this.findViewById(2131297476);
        this.milestoneName = (TextView)this.findViewById(2131297015);
        this.requestType = (TextView)this.findViewById(2131297268);
        this.requesetReason = (EditText)this.findViewById(2131297267);
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296592);
    }

    private void setValues() throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONObject jsonObject = database.getAssignDetails(this.assignId);
        this.projectName.setText((CharSequence)database.getProjectName(jsonObject.getString("t_project_id")));
        this.taskName.setText((CharSequence)jsonObject.getString("task_name"));
        this.milestoneName.setText((CharSequence)database.getMilestoneName(jsonObject.getString("t_milestone_id")));
        this.requestType.setText((CharSequence)this.requestFor);
    }

    private void checkLocation() {
        LocationUpdate locationUpdate = LocationUpdate.getInstance((Context)this);
        locationUpdate.connectLocation(new LocationUpdateListener(){

            @Override
            public void onLocationReceived(String latitude, String longtitude) {
                RejectForm.this.stopOrRejectTask(latitude, longtitude);
            }
        });
    }

    public void stopOrRejectTask(String latitude, String longtitude) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("assign_id", this.assignId);
        params.put("datetime", DateUtils.getCurrentDateTime());
        params.put("reason", this.requesetReason.getText().toString());
        params.put("latitude", latitude);
        params.put("longtitude", longtitude);
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        myRequestQueue.addToQueue(this.url, params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json = new JSONObject(response);
                    int success = json.getInt("s");
                    if (success == 1) {
                        RejectForm.this.finish();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                if (MyRequestQueue.getInstance((Activity)this).isNoNetwork()) break;
                this.checkBeforeUpdate();
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void checkBeforeUpdate() {
        if (MyRequestQueue.getInstance((Activity)this).isNoInternet()) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"No Internet Connection", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    RejectForm.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
            return;
        }
        String requestReason = this.requesetReason.getText().toString();
        if (requestReason.isEmpty()) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"Provide reason", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    RejectForm.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
            return;
        }
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)("Task will be " + this.requestFor + "ed")).setPositiveButton((CharSequence)this.requestFor, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                RejectForm.this.checkLocation();
            }
        }).setNegativeButton((CharSequence)"cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        }).show();
    }
}

