/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.old.TaskDetails;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.google.android.material.snackbar.Snackbar;
import java.text.MessageFormat;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class RequestDetails
extends AppCompatActivity {
    private MenuItem delete;
    private CoordinatorLayout coordinatorLayout;
    private Snackbar snackbar;
    private TextView mainInfoText;
    private TextView taskName;
    private TextView requestDaysText;
    private RelativeLayout showInfoLayout;
    private LinearLayout requestDetails;
    private String requestId;
    boolean fromNotification = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492992);
        this.getSupportActionBar().setTitle((CharSequence)"Request Details");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        try {
            this.fromNotification = this.getIntent().getBooleanExtra("fromNotification", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.requestId = this.getIntent().getStringExtra("id");
        this.getWidgets();
        this.setListeners();
    }

    protected void onResume() {
        super.onResume();
        if (Utility.isNetworkAvailable((Context)this)) {
            this.getRequests();
        }
    }

    private void getWidgets() {
        this.mainInfoText = (TextView)this.findViewById(2131296992);
        this.taskName = (TextView)this.findViewById(2131297470);
        this.requestDaysText = (TextView)this.findViewById(2131297261);
        this.showInfoLayout = (RelativeLayout)this.findViewById(2131297342);
        this.requestDetails = (LinearLayout)this.findViewById(2131297262);
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296592);
    }

    private void setListeners() {
        this.taskName.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent((Context)RequestDetails.this, TaskDetails.class);
                RequestDetails.this.startActivity(intent);
            }
        });
        this.showInfoLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (RequestDetails.this.requestDetails.getVisibility() == 0) {
                    RequestDetails.this.requestDetails.setVisibility(8);
                } else {
                    RequestDetails.this.requestDetails.setVisibility(0);
                }
            }
        });
    }

    private void getRequests() {
        if (MyRequestQueue.getInstance((Activity)this).isNoNetwork()) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", this.requestId);
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_requestdetails.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        RequestDetails.this.getRequests(jsonObject);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getRequests(JSONObject json) throws Exception {
        Database database = Database.getInstance((Context)this);
        Preference preference = Preference.getInstance((Context)this);
        JSONObject jsonObject = json.getJSONObject("data");
        this.taskName.setText((CharSequence)jsonObject.getString("task_name"));
        JSONArray employeeArray = json.getJSONArray("employees");
        database.insertEmplyoees(employeeArray);
        String rdays = jsonObject.getString("increasedays");
        if (rdays.equalsIgnoreCase("1")) {
            this.requestDaysText.setText((CharSequence)MessageFormat.format("{0} Day", rdays));
        } else {
            this.requestDaysText.setText((CharSequence)String.format("%s Days", rdays));
        }
        String status = jsonObject.getString("r_status");
        this.mainInfoText.setText((CharSequence)status);
        this.requestDetails.removeAllViews();
        this.addView("Requested On", jsonObject.getString("r_datetime"));
        this.addView("Requested By", database.getEmployeeName(jsonObject.getString("employee_id")));
        if (this.fromNotification) {
            Preference.getInstance((Context)this).putProjectId(jsonObject.getString("project_id"));
        }
        this.addView("Reason", jsonObject.getString("reason"));
        this.addView("Task List", jsonObject.getString("listtask_name"));
        this.addView("Milestone", jsonObject.getString("milestone_name"));
        this.addView("Project", jsonObject.getString("project_name"));
        if (status.equalsIgnoreCase("accepted")) {
            this.addView("Accepted On", jsonObject.getString("updatetime"));
            this.addView("Accepted By", database.getEmployeeName(jsonObject.getString("response_by")));
            this.addView("Response", jsonObject.getString("response"));
        } else if (status.equalsIgnoreCase("rejected")) {
            this.addView("Rejected On", jsonObject.getString("updatetime"));
            this.addView("Rejected By", database.getEmployeeName(jsonObject.getString("response_by")));
            this.addView("Response", jsonObject.getString("response"));
        }
        if (jsonObject.getString("employee_id").equalsIgnoreCase(preference.getEmailId()) && status.equalsIgnoreCase("pending")) {
            this.delete.setVisible(true);
        } else {
            this.delete.setVisible(false);
        }
    }

    private void deleteRequest() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", this.requestId);
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/delete_request.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)RequestDetails.this.getApplicationContext(), (CharSequence)"Request Deleted Successfully", (int)0).show();
                        RequestDetails.this.finish();
                    } else {
                        Toast.makeText((Context)RequestDetails.this.getApplicationContext(), (CharSequence)"Unable to Delete Request", (int)0).show();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558422, menu2);
        this.delete = menu2.findItem(2131296649);
        this.delete.setVisible(false);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296649: {
                if (MyRequestQueue.getInstance((Activity)this).isNoNetwork()) break;
                this.showDeleteDialog();
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void showDeleteDialog() {
        if (!Utility.isNetworkAvailable((Context)this)) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"No Internet Connection", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    RequestDetails.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
            return;
        }
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)"Request Will be deleted").setPositiveButton((CharSequence)"Delete", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                RequestDetails.this.deleteRequest();
            }
        }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        }).show();
    }

    private void addView(String key, String pair) {
        View view = this.getLayoutInflater().inflate(2131493227, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        TextView pairText = (TextView)view.findViewById(2131297136);
        keyText.setText((CharSequence)key);
        pairText.setText((CharSequence)pair);
        this.requestDetails.addView(view);
    }
}

