/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.RequestDetails;
import com.b2lmobitech.fieldcloudplus.task.activities.RequestsHitstoryActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.RquestUpdateActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.RequestListAdapter;
import com.b2lmobitech.fieldcloudplus.task.listener.OnTaskActionSelected;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.google.android.material.snackbar.Snackbar;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Requests
extends AppCompatActivity
implements OnTaskActionSelected {
    RecyclerView recyclerView;
    String projectId;
    SwipeRefreshLayout swipeRefreshLayout;
    Snackbar snackbar;
    Snackbar nosnackbar;
    CoordinatorLayout coordinatorLayout;
    JSONArray jsonArray;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492995);
        this.getSupportActionBar().setTitle((CharSequence)"Pending Requests");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.projectId = this.getIntent().getStringExtra("id");
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296592);
        this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(2131297443);
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                Requests.this.getRequests();
            }
        });
        this.swipeRefreshLayout.setColorSchemeResources(new int[]{17170459, 17170452, 17170456, 0x1060016});
    }

    protected void onResume() {
        super.onResume();
        if (this.projectId == null) {
            this.projectId = Preference.getInstance((Context)this).getProjectId();
        }
        this.getRequests();
    }

    private void getRequests() {
        if (this.swipeRefreshLayout.isRefreshing()) {
            this.swipeRefreshLayout.setRefreshing(false);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        Preference preference = Preference.getInstance((Context)this);
        params.put("project_id", this.projectId);
        params.put("mail", preference.getEmailId());
        if (preference.isAdmin()) {
            params.put("role", preference.getDesignation());
        } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
            params.put("role", "project");
        } else {
            params.put("role", "employee");
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_requests.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    Requests.this.getRequests(jsonObject.getJSONArray("requests"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getRequests(JSONArray jsonArray) throws JSONException {
        this.jsonArray = jsonArray;
        if (this.snackbar != null) {
            this.snackbar.dismiss();
        }
        if (jsonArray.length() == 0) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"No Pending Requests", (int)-2).setAction((CharSequence)"Show History", new View.OnClickListener(){

                public void onClick(View view) {
                    Requests.this.snackbar.dismiss();
                    Intent intent = new Intent(Requests.this.getApplicationContext(), RequestsHitstoryActivity.class);
                    intent.putExtra("id", Requests.this.projectId);
                    Requests.this.startActivity(intent);
                    Requests.this.finish();
                }
            });
            this.snackbar.show();
        }
        RequestListAdapter requestListAdapter = new RequestListAdapter((Context)this, jsonArray, Preference.getInstance((Context)this).isResponsible(this.projectId));
        this.recyclerView.setAdapter((RecyclerView.Adapter)requestListAdapter);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558421, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296827: {
                Intent intent = new Intent(this.getApplicationContext(), RequestsHitstoryActivity.class);
                intent.putExtra("id", this.projectId);
                this.startActivity(intent);
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void taskSelected(int position, String action) {
        if (action.equalsIgnoreCase("details")) {
            Intent intent = new Intent(this.getApplicationContext(), RequestDetails.class);
            intent.putExtra("title", "Reject Request");
            try {
                intent.putExtra("id", this.jsonArray.getJSONObject(position).getString("id"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.startActivity(intent);
        } else if (action.equalsIgnoreCase("accepted") || action.equalsIgnoreCase("rejected")) {
            Intent intent = new Intent(this.getApplicationContext(), RquestUpdateActivity.class);
            intent.putExtra("status", action);
            if (action.equalsIgnoreCase("accepted")) {
                intent.putExtra("title", "Accept Request");
            } else {
                intent.putExtra("title", "Reject Request");
            }
            try {
                intent.putExtra("json", this.jsonArray.getJSONObject(position).toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.startActivity(intent);
        }
    }

    private void updateRequest(String status, JSONObject jsonObject) throws ParseException, JSONException {
        Preference preference = Preference.getInstance((Context)this);
        Date date = DateUtils.fromDate(jsonObject.getString("t_end_date"));
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, jsonObject.getInt("increasedays"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("enddate", df.format(c.getTime()));
        params.put("status", status);
        params.put("tid", jsonObject.getString("task_id"));
        params.put("id", jsonObject.getString("id"));
        params.put("mail", preference.getEmailId());
        params.put("type", preference.getCompnayType());
        if (preference.isAdmin()) {
            params.put("role", preference.getDesignation());
        } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
            params.put("role", "project");
        } else {
            params.put("role", "employee");
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/request_update.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)Requests.this.getApplicationContext(), (CharSequence)"Request Updated Successfully", (int)0).show();
                        Requests.this.getRequests();
                    } else {
                        Toast.makeText((Context)Requests.this.getApplicationContext(), (CharSequence)"Unable to update Request", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

