/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.RequestDetails;
import com.b2lmobitech.fieldcloudplus.task.adapters.RequestHisotyAdapter;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.google.android.material.snackbar.Snackbar;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RequestsHitstoryActivity
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    String projectId;
    SwipeRefreshLayout swipeRefreshLayout;
    Snackbar snackbar;
    Snackbar nosnackbar;
    CoordinatorLayout coordinatorLayout;
    JSONArray jsonArray;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492994);
        this.getSupportActionBar().setTitle((CharSequence)"Requests History");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.projectId = this.getIntent().getStringExtra("id");
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296593);
        this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(2131297443);
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                RequestsHitstoryActivity.this.getRequests();
            }
        });
        this.swipeRefreshLayout.setColorSchemeResources(new int[]{17170459, 17170452, 17170456, 0x1060016});
    }

    protected void onResume() {
        super.onResume();
        this.getRequests();
    }

    private void getRequests() {
        if (this.swipeRefreshLayout.isRefreshing()) {
            this.swipeRefreshLayout.setRefreshing(false);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        Preference preference = Preference.getInstance((Context)this);
        params.put("project_id", this.projectId);
        params.put("mail", preference.getEmailId());
        if (preference.isAdmin()) {
            params.put("role", preference.getDesignation());
        } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
            params.put("role", "project");
        } else {
            params.put("role", "employee");
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_requesthistory.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    RequestsHitstoryActivity.this.getRequests(jsonObject.getJSONArray("requests"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getRequests(JSONArray jsonArray) throws JSONException {
        this.jsonArray = jsonArray;
        if (jsonArray.length() == 0) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"No Requests Found", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    RequestsHitstoryActivity.this.snackbar.dismiss();
                    RequestsHitstoryActivity.this.finish();
                }
            });
            this.snackbar.show();
        }
        RequestHisotyAdapter requestHisotyAdapter = new RequestHisotyAdapter((Context)this, jsonArray, Preference.getInstance((Context)this).isResponsible(this.projectId));
        this.recyclerView.setAdapter((RecyclerView.Adapter)requestHisotyAdapter);
    }

    @Override
    public void itemClicked(int position) {
        Intent intent = new Intent(this.getApplicationContext(), RequestDetails.class);
        try {
            intent.putExtra("id", this.jsonArray.getJSONObject(position).getString("id"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.startActivity(intent);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

