/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.content.Context;
import android.os.Bundle;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.adapters.SearchResultAdapter;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;
import java.util.ArrayList;
import java.util.Date;

public class SearchResult
extends AppCompatActivity {
    ArrayList<TaskEncap> taskLsit = new ArrayList();
    ArrayList<TaskEncap> searchList = new ArrayList();
    ArrayList<TaskEncap> adapterList = new ArrayList();
    String fromDate;
    String toDate;
    RecyclerView recyclerView;
    Date selected1;
    Date selected2;
    SearchResultAdapter searchResultAdapter;
    TextView resultText;
    String type;
    String title;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493002);
        if (this.getIntent().getExtras() != null) {
            this.taskLsit = this.getIntent().getParcelableArrayListExtra("full_list");
            this.searchList = this.getIntent().getParcelableArrayListExtra("search_list");
            this.fromDate = this.getIntent().getStringExtra("fromDate");
            this.toDate = this.getIntent().getStringExtra("toDate");
            this.type = this.getIntent().getStringExtra("title");
        }
        this.resultText = (TextView)this.findViewById(2131297275);
        if (this.toDate.isEmpty()) {
            this.resultText.setText((CharSequence)this.fromDate);
        } else {
            this.resultText.setText((CharSequence)(this.fromDate + " to " + this.toDate));
        }
        if (this.type.equalsIgnoreCase("Active")) {
            this.title = "Active Tasks";
        } else if (this.type.equalsIgnoreCase("Completed")) {
            this.title = "Completed Tasks";
        } else if (this.type.equalsIgnoreCase("Deadline")) {
            this.title = "Deadlines";
        }
        this.getSupportActionBar().setTitle((CharSequence)this.title);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        for (TaskEncap taskEncap : this.searchList) {
            int dayend = 0;
            try {
                dayend = Utility.daysbetween(Utility.getDateTime(this.fromDate), taskEncap.getD_enddatte());
                if (taskEncap.getI_progress() == 100 && taskEncap.getStatus().equalsIgnoreCase("completed")) {
                    taskEncap.setCategory(TaskEnum.COMPLETED);
                } else if (taskEncap.getAssign_status().trim().equalsIgnoreCase("yetToAccept")) {
                    taskEncap.setCategory(TaskEnum.NEW);
                } else if (dayend != 0 && taskEncap.getD_enddatte().before(Utility.getDateTime(this.fromDate))) {
                    taskEncap.setCategory(TaskEnum.LATE);
                } else if (taskEncap.getD_startdate().after(Utility.getDateTime(this.fromDate)) && taskEncap.getAssign_status().equalsIgnoreCase("accepted")) {
                    taskEncap.setCategory(TaskEnum.UPCOMING);
                } else {
                    taskEncap.setCategory(TaskEnum.ACTIVE);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.adapterList.add(taskEncap);
        }
        this.recyclerView = (RecyclerView)this.findViewById(2131297313);
        this.searchResultAdapter = new SearchResultAdapter((Context)this, this.searchList);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.setHasFixedSize(true);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.searchResultAdapter);
    }
}

