/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.view.MenuItem;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.ReduceProgressActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.TaskAssignActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.TaskReAssignActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.AllTasksAdapter;
import com.b2lmobitech.fieldcloudplus.task.adapters.TasksManagementAdapter;
import com.b2lmobitech.fieldcloudplus.task.listener.OnTaskActionSelected;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskByStatusActivity
extends AppCompatActivity
implements OnTaskActionSelected {
    String projectId;
    String status;
    String employee;
    RecyclerView recyclerView;
    JSONArray jsonArray;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493034);
        this.projectId = this.getIntent().getStringExtra("id");
        this.status = this.getIntent().getStringExtra("status");
        this.employee = this.getIntent().getStringExtra("employee");
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)this.getIntent().getStringExtra("title"));
    }

    protected void onResume() {
        super.onResume();
        this.getTasks();
    }

    private void getTasks() {
        this.jsonArray = Database.getInstance((Context)this).getTasksByStatus(this.projectId, this.status, this.employee);
        JSONArray list = new JSONArray();
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("id", this.projectId);
        params.put("status", this.status);
        if (this.employee != null) {
            try {
                for (int i = 0; i < this.jsonArray.length(); ++i) {
                    if (!this.jsonArray.getJSONObject(i).getString("employee_id").equals(this.employee)) continue;
                    list.put((Object)this.jsonArray.getJSONObject(i).getString("task_id"));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            params.put("employee", this.employee);
        } else {
            try {
                for (int i = 0; i < this.jsonArray.length(); ++i) {
                    list.put((Object)this.jsonArray.getJSONObject(i).getString("task_id"));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        params.put("list", list.toString());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_taskbystatus.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    TaskByStatusActivity.this.getTasks(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTasks(final JSONObject jsonObject) throws JSONException {
        final MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        final Database database = Database.getInstance((Context)this);
        myRequestQueue.showProgressBar();
        Handler handler = new Handler();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                try {
                    database.insertEmplyoees(jsonObject.getJSONArray("employees"));
                    database.insertTasks(jsonObject.getJSONArray("tasks"));
                    database.insertAssigns(jsonObject.getJSONArray("assigns"));
                    TaskByStatusActivity.this.setAdapter();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                myRequestQueue.hideProgressBar();
            }
        };
        handler.postAtFrontOfQueue(runnable2);
    }

    private void setAdapter() {
        this.jsonArray = Database.getInstance((Context)this).getTasksByStatus(this.projectId, this.status, this.employee);
        Parcelable recyclerViewState = this.recyclerView.getLayoutManager().onSaveInstanceState();
        if (this.status.equalsIgnoreCase("underprogress") || this.status.equalsIgnoreCase("late")) {
            AllTasksAdapter allTasksAdapter = new AllTasksAdapter((Context)this, this.jsonArray, "active", true);
            this.recyclerView.setAdapter((RecyclerView.Adapter)allTasksAdapter);
        } else {
            TasksManagementAdapter tasksManagementAdapter = new TasksManagementAdapter((Context)this, this.jsonArray, this.status);
            this.recyclerView.setAdapter((RecyclerView.Adapter)tasksManagementAdapter);
        }
        if (this.jsonArray.length() == 0) {
            this.findViewById(2131297099).setVisibility(0);
        }
        try {
            this.recyclerView.getLayoutManager().onRestoreInstanceState(recyclerViewState);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void taskSelected(int position, String action) {
        if (MyRequestQueue.getInstance((Activity)this).isNoNetwork()) {
            return;
        }
        try {
            final JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            if (action.equalsIgnoreCase("assign")) {
                Intent intent = new Intent(this.getApplicationContext(), TaskAssignActivity.class);
                intent.putExtra("id", jsonObject.getString("task_id"));
                this.startActivity(intent);
            } else if (action.equalsIgnoreCase("unassign")) {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                builder.setPositiveButton((CharSequence)"CONFIRM", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                        try {
                            TaskByStatusActivity.this.unassignTask(jsonObject.getString("assign_id"), jsonObject.getString("a_task_id"));
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                });
                builder.setNegativeButton((CharSequence)"CLOSE", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int id2) {
                    }
                });
                builder.setMessage((CharSequence)"Are you sure want to unassign task");
                AlertDialog dialog = builder.create();
                dialog.show();
            } else if (action.equalsIgnoreCase("reassign")) {
                Intent intent = new Intent(this.getApplicationContext(), TaskReAssignActivity.class);
                intent.putExtra("id", jsonObject.getString("task_id"));
                intent.putExtra("aid", jsonObject.getString("assign_id"));
                intent.putExtra("eid", jsonObject.getString("employee_id"));
                this.startActivity(intent);
            } else if (action.equalsIgnoreCase("complete")) {
                this.completeTask(jsonObject.getString("assign_id"), jsonObject.getString("a_task_id"));
            } else if (action.equalsIgnoreCase("modify")) {
                Intent intent = new Intent(this.getApplicationContext(), ReduceProgressActivity.class);
                intent.putExtra("id", jsonObject.getString("task_id"));
                intent.putExtra("name", jsonObject.getString("task_name"));
                this.startActivity(intent);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void unassignTask(String assignId, String taskId) {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("assignId", (Object)assignId);
            jsonObject.put("taskId", (Object)taskId);
            jsonObject.put("cname", (Object)preference.getCompanyName());
            jsonObject.put("mail", (Object)preference.getEmailId());
            jsonObject.put("type", (Object)preference.getCompnayType());
            jsonObject.put("role", (Object)preference.getDesignation());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/task_unassign.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)TaskByStatusActivity.this.getApplicationContext(), (CharSequence)"Task Unassigned Successfully", (int)0).show();
                        TaskByStatusActivity.this.getTasks();
                    } else {
                        Toast.makeText((Context)TaskByStatusActivity.this.getApplicationContext(), (CharSequence)"Unable to Unassign Task ", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void completeTask(String assignId, String taskId) {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("assignId", (Object)assignId);
            jsonObject.put("taskId", (Object)taskId);
            jsonObject.put("cname", (Object)preference.getCompanyName());
            jsonObject.put("mail", (Object)preference.getEmailId());
            jsonObject.put("type", (Object)preference.getCompnayType());
            if (preference.isAdmin()) {
                jsonObject.put("role", (Object)preference.getDesignation());
            } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
                jsonObject.put("role", (Object)"project");
            } else {
                jsonObject.put("role", (Object)"employee");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/task_complete.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)TaskByStatusActivity.this.getApplicationContext(), (CharSequence)"Task Completed Successfully", (int)0).show();
                        TaskByStatusActivity.this.getTasks();
                    } else {
                        Toast.makeText((Context)TaskByStatusActivity.this.getApplicationContext(), (CharSequence)"Unable to Complete Task ", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

