/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.ExtendForm;
import com.b2lmobitech.fieldcloudplus.task.activities.ProgressForm;
import com.b2lmobitech.fieldcloudplus.task.activities.ProgressHistroy;
import com.b2lmobitech.fieldcloudplus.task.activities.RejectForm;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddTaskActivity;
import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskInfoActivity
extends AppCompatActivity {
    LinearLayout taskDetails;
    TextView mainInfoText;
    TextView taskName;
    TextView descriptionText;
    TextView completedText;
    TextView completedPercentage;
    MenuItem stop;
    MenuItem update;
    MenuItem request;
    MenuItem start;
    MenuItem history;
    MenuItem reminder;
    MenuItem accept;
    MenuItem reject;
    MenuItem assign;
    MenuItem unassign;
    MenuItem edit;
    MenuItem delete;
    RelativeLayout showInfoLayout;
    RelativeLayout percentageLayout;
    SeekBar perccentageSeekbar;
    JSONObject jsonObject;
    String taskid;
    String assignid;
    boolean requestPlaced = true;
    boolean fromNotification = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493029);
        this.taskid = this.getIntent().getStringExtra("id");
        try {
            this.fromNotification = this.getIntent().getBooleanExtra("fromNotification", false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.taskDetails = (LinearLayout)this.findViewById(2131297466);
        this.mainInfoText = (TextView)this.findViewById(2131296992);
        this.taskName = (TextView)this.findViewById(2131297470);
        this.descriptionText = (TextView)this.findViewById(2131296657);
        this.showInfoLayout = (RelativeLayout)this.findViewById(2131297342);
        this.perccentageSeekbar = (SeekBar)this.findViewById(2131297151);
        this.completedPercentage = (TextView)this.findViewById(2131296551);
        this.completedText = (TextView)this.findViewById(2131296552);
        this.percentageLayout = (RelativeLayout)this.findViewById(2131297154);
        this.getSupportActionBar().setTitle((CharSequence)"Task Details");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.showInfoLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TaskInfoActivity.this.taskDetails.getVisibility() == 0) {
                    TaskInfoActivity.this.taskDetails.setVisibility(8);
                } else {
                    TaskInfoActivity.this.taskDetails.setVisibility(0);
                }
            }
        });
        this.perccentageSeekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                TaskInfoActivity.this.completedPercentage.setText((CharSequence)(i + "%"));
                try {
                    if (i > TaskInfoActivity.this.jsonObject.getInt("t_progress")) {
                        TaskInfoActivity.this.update.setVisible(true);
                    } else {
                        TaskInfoActivity.this.update.setVisible(false);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.getTasksDetais();
    }

    private void addTaskDetails() throws Exception {
        Database database = Database.getInstance((Context)this);
        Preference preference = Preference.getInstance((Context)this);
        boolean isResponsible = false;
        boolean isAssignedToMe = false;
        this.jsonObject = database.getTaskDetails(this.taskid);
        this.taskDetails.removeAllViews();
        this.taskName.setText((CharSequence)this.jsonObject.getString("task_name"));
        this.descriptionText.setText((CharSequence)this.jsonObject.getString("t_description"));
        this.addView("Start", this.jsonObject.getString("t_start_date"));
        this.addView("End", this.jsonObject.getString("t_end_date"));
        this.addView("Priority", this.jsonObject.getString("t_priority"));
        this.addView("Task List", database.getTaskListName(this.jsonObject.getString("listtask_id")));
        this.addView("Project", database.getProjectName(this.jsonObject.getString("t_project_id")));
        if (this.fromNotification) {
            preference.putProjectId(this.jsonObject.getString("t_project_id"));
            preference.putTaskListId(this.jsonObject.getString("listtask_id"));
        }
        if (!this.jsonObject.getString("t_status").equalsIgnoreCase("unassigned")) {
            this.assignid = this.jsonObject.getString("assign_id");
            if (this.jsonObject.getString("employee_id").equalsIgnoreCase(Preference.getInstance(this.getApplicationContext()).getEmailId())) {
                this.addView("Assigned To", this.getString(2131820713));
                isAssignedToMe = true;
            } else {
                this.addView("Assigned To", Database.getInstance((Context)this).getEmployeeName(this.jsonObject.getString("employee_id")));
                isAssignedToMe = false;
            }
        }
        String projectResponsible = database.getProjectResponsible(this.jsonObject.getString("t_project_id"));
        String role = preference.getDesignation();
        String emailid = preference.getEmailId();
        this.addView("Created On", this.jsonObject.getString("t_datetime"));
        this.addView("Created By", database.getEmployeeName(this.jsonObject.getString("t_created_by_mailid")));
        this.perccentageSeekbar.setProgress(this.jsonObject.getInt("t_progress"));
        this.completedPercentage.setText((CharSequence)String.format("%s%%", this.jsonObject.getString("t_progress")));
        isResponsible = projectResponsible.equalsIgnoreCase(emailid) || role.equalsIgnoreCase("admin");
        if (this.jsonObject.getString("t_status").equalsIgnoreCase("unassigned")) {
            if (DateUtils.fromDate(this.jsonObject.getString("t_end_date")).before(DateUtils.currentDate())) {
                this.mainInfoText.setText((CharSequence)String.format("Unassigned, %s", DateUtils.getLateDateString(this.jsonObject.getString("t_end_date"))));
            } else if (DateUtils.fromDate(this.jsonObject.getString("t_start_date")).after(DateUtils.currentDate())) {
                this.mainInfoText.setText((CharSequence)String.format("Unassigned, %s", DateUtils.getUpcomingDateString(this.jsonObject.getString("t_start_date"))));
            } else {
                this.mainInfoText.setText((CharSequence)String.format("Unassigned, %s", DateUtils.getDueDateString(this.jsonObject.getString("t_end_date"))));
            }
            this.manageActionBar(isResponsible, isAssignedToMe, "unassigned");
        } else if (this.jsonObject.getString("a_status").equalsIgnoreCase("yettoaccept")) {
            if (DateUtils.fromDate(this.jsonObject.getString("t_end_date")).before(DateUtils.currentDate())) {
                this.mainInfoText.setText((CharSequence)String.format("New Task, %s", DateUtils.getLateDateString(this.jsonObject.getString("t_end_date"))));
            } else if (DateUtils.fromDate(this.jsonObject.getString("t_start_date")).after(DateUtils.currentDate())) {
                this.mainInfoText.setText((CharSequence)String.format("New Task, %s", DateUtils.getUpcomingDateString(this.jsonObject.getString("t_start_date"))));
            } else {
                this.mainInfoText.setText((CharSequence)String.format("New Task, %s", DateUtils.getDueDateString(this.jsonObject.getString("t_end_date"))));
            }
            this.manageActionBar(isResponsible, isAssignedToMe, "yettoaccept");
        } else if (this.jsonObject.getString("a_status").equalsIgnoreCase("accepted")) {
            if (DateUtils.fromDate(this.jsonObject.getString("t_end_date")).before(DateUtils.currentDate())) {
                this.mainInfoText.setText((CharSequence)("Accepted," + DateUtils.getLateDateString(this.jsonObject.getString("t_end_date"))));
            } else if (DateUtils.fromDate(this.jsonObject.getString("t_start_date")).after(DateUtils.currentDate())) {
                this.mainInfoText.setText((CharSequence)("Accepted," + DateUtils.getUpcomingDateString(this.jsonObject.getString("t_start_date"))));
            } else {
                this.mainInfoText.setText((CharSequence)("Accepted," + DateUtils.getDueDateString(this.jsonObject.getString("t_end_date"))));
            }
            this.manageActionBar(isResponsible, isAssignedToMe, "accepted");
        } else if (this.jsonObject.getString("a_status").equalsIgnoreCase("completed")) {
            this.addView("Completed On", this.jsonObject.getString("completed_datetime"));
            this.mainInfoText.setText((CharSequence)DateUtils.getCompletedDateString(this.jsonObject.getString("completed_datetime")));
            this.manageActionBar(isResponsible, isAssignedToMe, "completed");
        } else if (this.jsonObject.getString("a_status").equalsIgnoreCase("underprogress")) {
            this.mainInfoText.setText((CharSequence)DateUtils.getDueDateString(this.jsonObject.getString("t_end_date")));
            if (this.jsonObject.getInt("t_progress") == 90) {
                this.manageActionBar(isResponsible, isAssignedToMe, "completeRequest");
            } else {
                this.manageActionBar(isResponsible, isAssignedToMe, "underprogress");
            }
        } else if (this.jsonObject.getString("a_status").equalsIgnoreCase("declined")) {
            this.mainInfoText.setText((CharSequence)DateUtils.getDueDateString(this.jsonObject.getString("t_end_date")));
            if (DateUtils.fromDate(this.jsonObject.getString("t_end_date")).before(DateUtils.currentDate())) {
                this.mainInfoText.setText((CharSequence)("Declined," + DateUtils.getLateDateString(this.jsonObject.getString("t_end_date"))));
            } else if (DateUtils.fromDate(this.jsonObject.getString("t_start_date")).after(DateUtils.currentDate())) {
                this.mainInfoText.setText((CharSequence)("Declined," + DateUtils.getUpcomingDateString(this.jsonObject.getString("t_start_date"))));
            } else {
                this.mainInfoText.setText((CharSequence)("Declined," + DateUtils.getDueDateString(this.jsonObject.getString("t_end_date"))));
            }
            this.manageActionBar(isResponsible, isAssignedToMe, "declined");
        } else if (this.jsonObject.getString("t_status").equalsIgnoreCase("stalled")) {
            this.mainInfoText.setText((CharSequence)"Stalled");
            this.manageActionBar(isResponsible, isAssignedToMe, "stalled");
            this.addView("Stalled On", this.jsonObject.getString("stalled_datetime"));
            this.addView("Stalled By", database.getEmployeeName(this.jsonObject.getString("stalled_by")));
        } else if (this.jsonObject.getString("t_status").equalsIgnoreCase("stopped")) {
            this.mainInfoText.setText((CharSequence)"Stopped");
            this.manageActionBar(isResponsible, isAssignedToMe, "stopped");
            this.addView("Stopped On", this.jsonObject.getString("stoppeddatetime"));
        }
    }

    private void addView(String key, String pair) {
        View view = this.getLayoutInflater().inflate(2131493227, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        TextView pairText = (TextView)view.findViewById(2131297136);
        keyText.setText((CharSequence)key);
        pairText.setText((CharSequence)pair);
        this.taskDetails.addView(view);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558413, menu2);
        this.update = menu2.findItem(2131297696);
        this.start = menu2.findItem(2131297406);
        this.stop = menu2.findItem(2131297423);
        this.request = menu2.findItem(2131297259);
        this.history = menu2.findItem(2131296827);
        this.reminder = menu2.findItem(2131297254);
        this.accept = menu2.findItem(2131296282);
        this.reject = menu2.findItem(2131297249);
        this.assign = menu2.findItem(2131296399);
        this.unassign = menu2.findItem(2131297683);
        this.delete = menu2.findItem(2131296649);
        this.edit = menu2.findItem(2131296707);
        this.hideAll();
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        switch (item.getItemId()) {
            case 2131297696: {
                if (myRequestQueue.isNoNetwork()) break;
                Intent intent = new Intent((Context)this, ProgressForm.class);
                intent.putExtra("taskid", this.taskid);
                intent.putExtra("progress", this.perccentageSeekbar.getProgress());
                this.startActivity(intent);
                break;
            }
            case 2131297406: {
                if (myRequestQueue.isNoNetwork()) break;
                this.startTask();
                break;
            }
            case 2131296282: {
                if (myRequestQueue.isNoNetwork()) break;
                this.acceptTask();
                break;
            }
            case 2131297423: {
                if (myRequestQueue.isNoNetwork()) break;
                Intent intent = new Intent((Context)this, RejectForm.class);
                intent.putExtra("request", "stop");
                try {
                    intent.putExtra("id", this.jsonObject.getString("assign_id"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.startActivity(intent);
                this.finish();
                break;
            }
            case 2131296707: {
                if (myRequestQueue.isNoNetwork()) break;
                Intent intent = new Intent((Context)this, AddTaskActivity.class);
                intent.putExtra("taskId", this.taskid);
                try {
                    intent.putExtra("id", this.jsonObject.getString("t_project_id"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.startActivity(intent);
                break;
            }
            case 2131297249: {
                if (myRequestQueue.isNoNetwork()) break;
                Intent intent = new Intent((Context)this, RejectForm.class);
                intent.putExtra("request", "reject");
                try {
                    intent.putExtra("id", this.jsonObject.getString("assign_id"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.startActivity(intent);
                this.finish();
                break;
            }
            case 2131297254: {
                break;
            }
            case 2131297259: {
                if (myRequestQueue.isNoNetwork()) break;
                Intent intent = new Intent((Context)this, ExtendForm.class);
                try {
                    intent.putExtra("assignId", this.jsonObject.getString("assign_id"));
                    intent.putExtra("taskId", this.jsonObject.getString("task_id"));
                    intent.putExtra("end", this.jsonObject.getString("t_end_date"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.startActivity(intent);
                break;
            }
            case 2131296827: {
                if (myRequestQueue.isNoNetwork()) break;
                Intent intent = new Intent((Context)this, ProgressHistroy.class);
                try {
                    intent.putExtra("id", this.jsonObject.getString("task_id"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                this.startActivity(intent);
                break;
            }
            case 2131296649: {
                this.showAlert();
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void checkforMenuCreated() {
        final Handler handler = new Handler();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                Log.d((String)"Runnable", (String)"Handler is working");
                if (TaskInfoActivity.this.update != null) {
                    handler.removeCallbacks((Runnable)this);
                    try {
                        TaskInfoActivity.this.addTaskDetails();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    handler.postDelayed((Runnable)this, 100L);
                }
            }
        };
        handler.removeCallbacks(runnable2);
        handler.postDelayed(runnable2, 100L);
    }

    public void acceptTask() {
        LocationManager locationManager = (LocationManager)this.getSystemService("location");
        boolean isGPSEnabled = locationManager.isProviderEnabled("gps");
        boolean isNetworkEnabled = locationManager.isProviderEnabled("network");
        if (!isGPSEnabled && !isNetworkEnabled) {
            AlertDialog.Builder alertdialog = new AlertDialog.Builder((Context)this);
            alertdialog.setTitle((CharSequence)"Access Location");
            alertdialog.setIcon(2131230915);
            alertdialog.setMessage((CharSequence)"No network provider is enabled for location access!!");
            alertdialog.setPositiveButton((CharSequence)"Turn On", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    TaskInfoActivity.this.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS"));
                }
            });
            alertdialog.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
            alertdialog.show();
            return;
        }
        LatLang latLang = Utility.getLocation(this.getApplicationContext());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("assign_id", this.assignid);
        params.put("datetime", DateUtils.getCurrentDateTime());
        params.put("latitude", latLang.getLatitude());
        params.put("longtitude", latLang.getLongitude());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/task_accept.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        TaskInfoActivity.this.getTasksDetais();
                    }
                    Toast.makeText((Context)TaskInfoActivity.this.getApplicationContext(), (CharSequence)jsonObject.getString("m"), (int)0).show();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTasksDetais() {
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        Database database = Database.getInstance((Context)this);
        if (myRequestQueue.isNoInternet()) {
            this.checkforMenuCreated();
        } else {
            this.findViewById(2131296993).setVisibility(8);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("taskid", this.taskid);
            try {
                JSONObject jsonObject = database.getTaskDetails(this.taskid);
                params.put("tdt", database.getTasklistColumn(jsonObject.getString("listtask_id"), TasklistTable.UPDATEDATETIME));
                params.put("mdt", database.getMilestoneColumn(jsonObject.getString("t_milestone_id"), MilestoneTable.UPDATEDATETIME));
                params.put("pdt", database.getProjectColumn(jsonObject.getString("t_project_id"), ProjectTable.UPDATEDATETIME));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            myRequestQueue.addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_task_details.php", params, new MyRequestFinishedListener(){

                @Override
                public void requestResult(String response) {
                    TaskInfoActivity.this.findViewById(2131296993).setVisibility(0);
                    try {
                        JSONObject jsonObject = new JSONObject(response);
                        TaskInfoActivity.this.getTaskDetails(new JSONObject(response));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void getTaskDetails(JSONObject jsonObject) throws JSONException {
        JSONArray employeeArray = jsonObject.getJSONArray("employees");
        JSONArray taskArray = jsonObject.getJSONArray("tasks");
        JSONArray assignArray = jsonObject.getJSONArray("assigns");
        JSONArray progressArray = jsonObject.getJSONArray("progress");
        JSONArray milestoneArray = jsonObject.getJSONArray("milestones");
        JSONArray tasklistArray = jsonObject.getJSONArray("tasklists");
        JSONArray projectArray = jsonObject.getJSONArray("projects");
        Database database = Database.getInstance((Context)this);
        try {
            database.insertEmplyoees(employeeArray);
            database.insertTasks(taskArray);
            database.insertAssigns(assignArray);
            database.insertProgress(progressArray);
            database.insertMilestones(milestoneArray);
            database.insertTaskLists(tasklistArray);
            database.insertProjects(projectArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (jsonObject.getBoolean("requested")) {
            this.findViewById(2131297266).setVisibility(0);
            this.requestPlaced = true;
        } else {
            this.requestPlaced = false;
            this.findViewById(2131297266).setVisibility(8);
        }
        this.checkforMenuCreated();
    }

    private void startTask() {
        LocationManager locationManager = (LocationManager)this.getSystemService("location");
        boolean isGPSEnabled = locationManager.isProviderEnabled("gps");
        boolean isNetworkEnabled = locationManager.isProviderEnabled("network");
        if (!isGPSEnabled && !isNetworkEnabled) {
            AlertDialog.Builder alertdialog = new AlertDialog.Builder((Context)this);
            alertdialog.setTitle((CharSequence)"Access Location");
            alertdialog.setIcon(2131230915);
            alertdialog.setMessage((CharSequence)"No network provider is enabled for location access!!");
            alertdialog.setPositiveButton((CharSequence)"Turn On", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    TaskInfoActivity.this.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS"));
                }
            });
            alertdialog.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
            alertdialog.show();
            return;
        }
        LatLang latLang = Utility.getLocation((Context)this);
        String datetime = Utility.getCurrentDateTime();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("assign_id", this.assignid);
        params.put("task_id", this.taskid);
        params.put("datetime", datetime);
        params.put("latitude", latLang.getLatitude());
        params.put("longtitude", latLang.getLongitude());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/task_start.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        TaskInfoActivity.this.getTasksDetais();
                    }
                    Toast.makeText((Context)TaskInfoActivity.this.getApplicationContext(), (CharSequence)jsonObject.getString("m"), (int)0).show();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void hideAll() {
        this.start.setVisible(false);
        this.stop.setVisible(false);
        this.request.setVisible(false);
        this.history.setVisible(false);
        this.accept.setVisible(false);
        this.reject.setVisible(false);
        this.update.setVisible(false);
        this.reminder.setVisible(false);
        this.assign.setVisible(false);
        this.unassign.setVisible(false);
        this.delete.setVisible(false);
        this.edit.setVisible(false);
        this.percentageLayout.setVisibility(8);
    }

    private void manageActionBar(boolean isResponisble, boolean isAssignedToMe, String status) {
        this.hideAll();
        if (isResponisble) {
            this.edit.setVisible(true);
            this.delete.setVisible(true);
        }
        if (status.equalsIgnoreCase("unassigned") && isResponisble) {
            this.assign.setVisible(false);
        } else if (status.equalsIgnoreCase("yettoaccept")) {
            if (isAssignedToMe || isResponisble) {
                this.accept.setVisible(true);
                this.reject.setVisible(true);
            }
            this.percentageLayout.setVisibility(8);
        } else if (status.equalsIgnoreCase("accepted")) {
            this.percentageLayout.setVisibility(8);
            if (isAssignedToMe || isResponisble) {
                this.start.setVisible(true);
            }
        } else if (status.equalsIgnoreCase("completed") || status.equalsIgnoreCase("stalled") || status.equalsIgnoreCase("stopped")) {
            this.history.setVisible(true);
            this.percentageLayout.setVisibility(8);
            this.edit.setVisible(false);
        } else if (status.equalsIgnoreCase("declined")) {
            this.history.setVisible(false);
            this.percentageLayout.setVisibility(8);
            this.edit.setVisible(true);
        } else if (status.equalsIgnoreCase("completeRequest")) {
            if (isAssignedToMe || isResponisble) {
                this.history.setVisible(true);
                this.percentageLayout.setVisibility(0);
                this.edit.setVisible(false);
                this.perccentageSeekbar.setVisibility(8);
            }
        } else if (status.equalsIgnoreCase("underprogress")) {
            this.history.setVisible(true);
            if (isAssignedToMe && !this.requestPlaced) {
                this.request.setVisible(true);
            }
            this.percentageLayout.setVisibility(0);
            if (isResponisble || isAssignedToMe) {
                this.stop.setVisible(true);
                this.perccentageSeekbar.setVisibility(0);
            } else {
                this.perccentageSeekbar.setVisibility(8);
            }
        }
    }

    private void deleteTask() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            this.jsonObject.put("name", (Object)this.taskName.getText().toString());
            this.jsonObject.put("cname", (Object)preference.getCompanyName());
            this.jsonObject.put("mail", (Object)preference.getEmailId());
            this.jsonObject.put("type", (Object)preference.getCompnayType());
            this.jsonObject.put("taskId", (Object)this.taskid);
            if (preference.isAdmin()) {
                this.jsonObject.put("role", (Object)preference.getDesignation());
            } else {
                this.jsonObject.put("role", (Object)"project");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", this.jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/delete_task.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json = new JSONObject(response);
                    if (json.getInt("s") == 1) {
                        Database.getInstance(TaskInfoActivity.this.getApplicationContext()).deleteTask(TaskInfoActivity.this.taskid);
                        Toast.makeText((Context)TaskInfoActivity.this.getApplicationContext(), (CharSequence)"Task Deleted", (int)0).show();
                        TaskInfoActivity.this.finish();
                    } else {
                        Toast.makeText((Context)TaskInfoActivity.this.getApplicationContext(), (CharSequence)"Unable to Delete Task ", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void showAlert() {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)"Tasklist Will be deleted").setPositiveButton((CharSequence)"CONTINUE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                TaskInfoActivity.this.deleteTask();
            }
        }).setNegativeButton((CharSequence)"CLOSE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        }).show();
    }
}

