/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.AllTasksActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddTaskListActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.ListAdapter;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskListActivity
extends AppCompatActivity
implements OnItemClickListener {
    String projectid;
    RecyclerView recyclerView;
    MenuItem newTasklist;
    boolean menuCreated = false;
    JSONArray jsonArray;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493031);
        this.projectid = this.getIntent().getStringExtra("id");
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.getSupportActionBar().setTitle((CharSequence)"Task Lists");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    protected void onResume() {
        super.onResume();
        if (this.projectid == null) {
            this.projectid = Preference.getInstance((Context)this).getProjectId();
        }
        if (MyRequestQueue.getInstance((Activity)this).isNoInternet()) {
            this.getTasklistsOffline();
        } else {
            this.getTasklists();
        }
    }

    private void getTasklists() {
        Preference preference = Preference.getInstance((Context)this);
        Database database = Database.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("id", this.projectid);
        if (preference.getEmailId().equalsIgnoreCase(database.getProjectResponsible(this.projectid))) {
            params.put("responsible", "yes");
        } else {
            params.put("responsible", "no");
        }
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("list", database.getTaskListLists(this.projectid).toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_tasklists.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    TaskListActivity.this.getTasklists(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTasklists(JSONObject jsonObject) throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONArray jsonArray = jsonObject.getJSONArray("list");
        database.deleteTasklists(this.projectid);
        try {
            database.insertTaskLists(jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getTasklistsOffline();
    }

    private void getTasklistsOffline() {
        this.jsonArray = Database.getInstance((Context)this).getTaskLists(this.projectid);
        if (this.jsonArray.length() == 0) {
            this.findViewById(2131296960).setVisibility(0);
            if (Preference.getInstance((Context)this).isResponsible(this.projectid)) {
                this.findViewById(2131296355).setVisibility(0);
            }
            this.findViewById(2131296355).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TaskListActivity.this.addNew();
                }
            });
        } else {
            this.findViewById(2131296960).setVisibility(8);
            this.findViewById(2131296355).setVisibility(8);
        }
        ListAdapter taskListAdapter = new ListAdapter((Context)this, this.jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)taskListAdapter);
        this.checkforMenuCreated();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558430, menu2);
        this.newTasklist = menu2.findItem(2131297086);
        this.newTasklist.setVisible(false);
        this.menuCreated = true;
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131297086: {
                this.addNew();
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void addNew() {
        Intent intent = new Intent((Context)this, AddTaskListActivity.class);
        intent.putExtra("id", this.projectid);
        this.startActivity(intent);
    }

    private void checkforMenuCreated() {
        final Handler handler = new Handler();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                Log.d((String)"Runnable", (String)"Handler is working");
                if (TaskListActivity.this.menuCreated) {
                    handler.removeCallbacks((Runnable)this);
                    try {
                        TaskListActivity.this.manageActionBarIcons();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    handler.postDelayed((Runnable)this, 100L);
                }
            }
        };
        handler.removeCallbacks(runnable2);
        handler.postDelayed(runnable2, 100L);
    }

    private void manageActionBarIcons() {
        Preference preference = Preference.getInstance((Context)this);
        if (preference.isResponsible(this.projectid)) {
            this.newTasklist.setVisible(true);
        }
    }

    @Override
    public void itemClicked(int position) {
        Intent intent = new Intent(this.getApplicationContext(), AllTasksActivity.class);
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            intent.putExtra("id", jsonObject.getString(TasklistTable.TASKLISTID));
            intent.putExtra("projectId", this.projectid);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.startActivity(intent);
    }
}

