/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.widget.NestedScrollView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.TaskByStatusActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddTaskActivity;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskManagementActivity
extends AppCompatActivity {
    String projectId;
    TextView unassignedCountText;
    TextView assignedCountText;
    TextView activeCountText;
    TextView completedCountText;
    TextView stalledCountText;
    TextView stoppedCountText;
    TextView lateCountText;
    NestedScrollView nestedScrollView;
    String employee;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493036);
        this.projectId = this.getIntent().getStringExtra("id");
        this.employee = this.getIntent().getStringExtra("employee");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Task Management");
        try {
            this.unassignedCountText = (TextView)this.findViewById(2131297685);
            this.assignedCountText = (TextView)this.findViewById(2131296403);
            this.activeCountText = (TextView)this.findViewById(2131296341);
            this.completedCountText = (TextView)this.findViewById(2131296550);
            this.stalledCountText = (TextView)this.findViewById(2131297404);
            this.stoppedCountText = (TextView)this.findViewById(2131297425);
            this.nestedScrollView = (NestedScrollView)this.findViewById(2131297077);
            this.lateCountText = (TextView)this.findViewById(2131296919);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        final Intent intent = new Intent(this.getApplicationContext(), TaskByStatusActivity.class);
        intent.putExtra("id", this.projectId);
        intent.putExtra("employee", this.employee);
        this.findViewById(2131296402).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (myRequestQueue.isNoNetwork()) {
                    return;
                }
                intent.putExtra("status", "assigned");
                intent.putExtra("title", "Assigned Tasks");
                TaskManagementActivity.this.startActivity(intent);
            }
        });
        this.findViewById(2131296340).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (myRequestQueue.isNoNetwork()) {
                    return;
                }
                intent.putExtra("status", "underprogress");
                intent.putExtra("title", "Underprogress Tasks");
                TaskManagementActivity.this.startActivity(intent);
            }
        });
        this.findViewById(2131296549).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (myRequestQueue.isNoNetwork()) {
                    return;
                }
                intent.putExtra("status", "completed");
                intent.putExtra("title", "Completed Tasks");
                TaskManagementActivity.this.startActivity(intent);
            }
        });
        this.findViewById(2131296918).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (myRequestQueue.isNoNetwork()) {
                    return;
                }
                intent.putExtra("status", "late");
                intent.putExtra("title", "Late Tasks");
                TaskManagementActivity.this.startActivity(intent);
            }
        });
        this.findViewById(2131296549).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (myRequestQueue.isNoNetwork()) {
                    return;
                }
                intent.putExtra("status", "completed");
                intent.putExtra("title", "Completed Tasks");
                TaskManagementActivity.this.startActivity(intent);
            }
        });
        this.findViewById(2131297403).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (myRequestQueue.isNoNetwork()) {
                    return;
                }
                intent.putExtra("status", "stalled");
                intent.putExtra("title", "Stalled Tasks");
                TaskManagementActivity.this.startActivity(intent);
            }
        });
        this.findViewById(2131297424).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (myRequestQueue.isNoNetwork()) {
                    return;
                }
                intent.putExtra("status", "stopped");
                intent.putExtra("title", "Stopped Tasks");
                TaskManagementActivity.this.startActivity(intent);
            }
        });
        if (this.employee == null) {
            this.findViewById(2131297084).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (myRequestQueue.isNoNetwork()) {
                        return;
                    }
                    Intent intent = new Intent(TaskManagementActivity.this.getApplicationContext(), AddTaskActivity.class);
                    intent.putExtra("id", TaskManagementActivity.this.projectId);
                    TaskManagementActivity.this.startActivity(intent);
                }
            });
            this.findViewById(2131297684).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (myRequestQueue.isNoNetwork()) {
                        return;
                    }
                    intent.putExtra("status", "unassigned");
                    intent.putExtra("title", "Unassigned Tasks");
                    TaskManagementActivity.this.startActivity(intent);
                }
            });
        } else {
            this.findViewById(2131297084).setVisibility(8);
            this.findViewById(2131297684).setVisibility(8);
        }
    }

    protected void onResume() {
        super.onResume();
        this.getCounts();
    }

    private void getCounts() {
        HashMap<String, String> params = new HashMap<String, String>();
        Preference preference = Preference.getInstance((Context)this);
        params.put("id", this.projectId);
        if (this.employee != null) {
            params.put("employee", this.employee);
        }
        params.put("mail", preference.getEmailId());
        if (preference.isAdmin()) {
            params.put("role", preference.getDesignation());
        } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
            params.put("role", "project");
        } else {
            params.put("role", "employee");
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_taskcountsbyproject.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        TaskManagementActivity.this.getCounts(jsonObject.getJSONArray("counts"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getCounts(JSONArray jsonArray) throws JSONException {
        JSONObject jsonObject = jsonArray.getJSONObject(0);
        if (!jsonObject.getString("active").equalsIgnoreCase("null")) {
            this.activeCountText.setText((CharSequence)jsonObject.getString("active"));
            this.unassignedCountText.setText((CharSequence)jsonObject.getString("unassigned"));
            this.stoppedCountText.setText((CharSequence)jsonObject.getString("stopped"));
            this.stalledCountText.setText((CharSequence)jsonObject.getString("stalled"));
            this.completedCountText.setText((CharSequence)jsonObject.getString("completed"));
            this.assignedCountText.setText((CharSequence)jsonObject.getString("assigned"));
            this.lateCountText.setText((CharSequence)jsonObject.getString("late"));
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

