/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.EditText;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.CategoryTable;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class AddCategoryActivity
extends AppCompatActivity {
    EditText catName;
    EditText catDescription;
    String id;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492898);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.catName = (EditText)this.findViewById(2131296498);
        this.catDescription = (EditText)this.findViewById(2131296496);
        if (this.getIntent().getStringExtra("id") != null) {
            this.id = this.getIntent().getStringExtra("id");
            this.getSupportActionBar().setTitle((CharSequence)"Edit Cateogry");
            try {
                this.setValues();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            this.getSupportActionBar().setTitle((CharSequence)"New Category");
        }
    }

    private void setValues() throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONObject jsonObject = database.getCategoryDetails(this.id);
        this.catName.setText((CharSequence)jsonObject.getString(CategoryTable.CATNAME));
        this.catDescription.setText((CharSequence)jsonObject.getString(CategoryTable.CATDESCRIPTION));
    }

    private void checkCategoryName(final boolean goNext) {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("name", this.catName.getText().toString().trim());
        if (this.id != null) {
            params.put("id", this.id);
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/check_categoryname.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (!jsonObject.getBoolean("exists")) {
                        if (goNext) {
                            if (AddCategoryActivity.this.id == null) {
                                AddCategoryActivity.this.addCategory();
                            } else {
                                AddCategoryActivity.this.updateCategory();
                            }
                        }
                    } else {
                        Validations.getInstance((Activity)AddCategoryActivity.this).showAlert("Category Name Already Exists");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addCategory() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("cname", (Object)preference.getCompanyName());
            jsonObject.put("mail", (Object)preference.getEmailId());
            jsonObject.put("type", (Object)preference.getCompnayType());
            if (preference.isAdmin()) {
                jsonObject.put("role", (Object)"admin");
            } else {
                jsonObject.put("role", (Object)"project");
            }
            jsonObject.put("des", (Object)this.catDescription.getText().toString());
            jsonObject.put("name", (Object)this.catName.getText().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/add_category.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)AddCategoryActivity.this.getApplicationContext(), (CharSequence)"Category Created Successfully", (int)0).show();
                        AddCategoryActivity.this.finish();
                    } else {
                        Toast.makeText((Context)AddCategoryActivity.this.getApplicationContext(), (CharSequence)"Unable to Create Category", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void updateCategory() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("cname", (Object)preference.getCompanyName());
            jsonObject.put("mail", (Object)preference.getEmailId());
            jsonObject.put("type", (Object)preference.getCompnayType());
            if (preference.isAdmin()) {
                jsonObject.put("role", (Object)"admin");
            } else {
                jsonObject.put("role", (Object)"project");
            }
            jsonObject.put("des", (Object)this.catDescription.getText().toString());
            jsonObject.put("name", (Object)this.catName.getText().toString());
            jsonObject.put("id", (Object)this.id);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/update_category.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)AddCategoryActivity.this.getApplicationContext(), (CharSequence)"Category Updated Successfully", (int)0).show();
                        AddCategoryActivity.this.finish();
                    } else {
                        Toast.makeText((Context)AddCategoryActivity.this.getApplicationContext(), (CharSequence)"Unable to Update Category", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private boolean isValid() {
        Validations validations = Validations.getInstance((Activity)this);
        if (this.catName.getText().toString().isEmpty()) {
            validations.showAlert("Enter Name");
            return false;
        }
        if (this.catDescription.getText().toString().isEmpty()) {
            validations.showAlert("Fill Description");
            return false;
        }
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                if (!this.isValid()) break;
                this.checkCategoryName(true);
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

