/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ClientTable;
import com.google.android.material.textfield.TextInputLayout;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class AddClientActivity
extends AppCompatActivity {
    TextInputLayout companyName;
    TextInputLayout mobileNumber;
    TextInputLayout phoneNumber;
    TextInputLayout emailid;
    TextInputLayout address;
    TextInputLayout webAddress;
    TextInputLayout rname;
    TextInputLayout rmobile;
    TextInputLayout rmail;
    String id;
    private String NDA = "no data available";
    LinearLayout responseLayout;
    TextView moreDetails;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492899);
        this.getWidgets();
        if (this.getIntent().getStringExtra("id") != null) {
            this.getSupportActionBar().setTitle((CharSequence)"Edit Client");
            this.id = this.getIntent().getStringExtra("id");
            try {
                this.setValues();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            this.getSupportActionBar().setTitle((CharSequence)"New Client");
        }
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    private void setValues() throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONObject jsonObject = database.getClientDetails(this.id);
        this.companyName.getEditText().setText((CharSequence)jsonObject.getString(ClientTable.COMPANYNAME));
        this.address.getEditText().setText((CharSequence)jsonObject.getString(ClientTable.ADDRESS));
        this.mobileNumber.getEditText().setText((CharSequence)jsonObject.getString(ClientTable.CMOBILE));
        this.phoneNumber.getEditText().setText((CharSequence)jsonObject.getString(ClientTable.CPHONE));
        this.emailid.getEditText().setText((CharSequence)jsonObject.getString(ClientTable.CEMAIL));
        this.webAddress.getEditText().setText((CharSequence)jsonObject.getString(ClientTable.WEBADDRESS));
        if (!jsonObject.getString(ClientTable.RESPONSIBLEPERSON).isEmpty() && !jsonObject.getString(ClientTable.RESPONSIBLEPERSON).equalsIgnoreCase(this.NDA)) {
            this.rname.getEditText().setText((CharSequence)jsonObject.getString(ClientTable.RESPONSIBLEPERSON));
        }
        if (!jsonObject.getString(ClientTable.RESPONSIBLEMAIL).isEmpty() && !jsonObject.getString(ClientTable.RESPONSIBLEMAIL).equalsIgnoreCase(this.NDA)) {
            this.rmail.getEditText().setText((CharSequence)jsonObject.getString(ClientTable.RESPONSIBLEMAIL));
        }
        if (!jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE).isEmpty() && !jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE).equalsIgnoreCase(this.NDA)) {
            this.rmobile.getEditText().setText((CharSequence)jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE));
        }
        this.responseLayout.setVisibility(0);
        this.moreDetails.setVisibility(8);
    }

    private void getWidgets() {
        this.companyName = (TextInputLayout)this.findViewById(2131296544);
        this.mobileNumber = (TextInputLayout)this.findViewById(2131297018);
        this.phoneNumber = (TextInputLayout)this.findViewById(2131297160);
        this.emailid = (TextInputLayout)this.findViewById(2131296724);
        this.address = (TextInputLayout)this.findViewById(2131296364);
        this.webAddress = (TextInputLayout)this.findViewById(2131297718);
        this.rname = (TextInputLayout)this.findViewById(2131297286);
        this.rmobile = (TextInputLayout)this.findViewById(2131297285);
        this.rmail = (TextInputLayout)this.findViewById(2131297284);
        this.responseLayout = (LinearLayout)this.findViewById(2131297271);
        this.moreDetails = (TextView)this.findViewById(2131297033);
        this.companyName.getEditText().setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    AddClientActivity.this.checkCompanyName(false);
                }
            }
        });
        this.moreDetails.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddClientActivity.this.responseLayout.setVisibility(0);
                AddClientActivity.this.moreDetails.setVisibility(8);
            }
        });
    }

    private boolean isValid() {
        Validations validations = Validations.getInstance((Activity)this);
        if (this.companyName.getEditText().getText().toString().isEmpty()) {
            validations.showAlert("Enter Company Name");
            return false;
        }
        if (this.mobileNumber.getEditText().getText().toString().isEmpty()) {
            validations.showAlert("Enter Valid Mobile Number");
            return false;
        }
        if (this.phoneNumber.getEditText().getText().toString().isEmpty()) {
            validations.showAlert("Enter Valid phone Number");
            return false;
        }
        if (this.emailid.getEditText().getText().toString().isEmpty()) {
            validations.showAlert("Enter Valid Email");
            return false;
        }
        if (this.address.getEditText().getText().toString().isEmpty()) {
            validations.showAlert("Enter Valid Address");
            return false;
        }
        if (this.webAddress.getEditText().getText().toString().isEmpty()) {
            validations.showAlert("Enter Valid Web Address");
            return false;
        }
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                this.closeKeyboard();
                if (!this.isValid()) break;
                this.checkCompanyName(true);
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void checkCompanyName(final boolean goNext) {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("name", this.companyName.getEditText().getText().toString().trim());
        if (this.id != null) {
            params.put("id", this.id);
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/check_clientname.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (!jsonObject.getBoolean("exists")) {
                        if (goNext) {
                            if (AddClientActivity.this.id != null) {
                                AddClientActivity.this.updateClient();
                            } else {
                                AddClientActivity.this.addClient();
                            }
                        }
                    } else {
                        Validations.getInstance((Activity)AddClientActivity.this).showAlert("Client Company Name Already Exists");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addClient() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("mail", preference.getEmailId());
        params.put("type", preference.getCompnayType());
        if (preference.isAdmin()) {
            params.put("role", "admin");
        } else {
            params.put("role", "project");
        }
        params.put("name", this.companyName.getEditText().getText().toString().trim());
        params.put("mobile", this.mobileNumber.getEditText().getText().toString().trim());
        params.put("phone", this.phoneNumber.getEditText().getText().toString().trim());
        params.put("email", this.emailid.getEditText().getText().toString().trim());
        params.put("address", this.address.getEditText().getText().toString().trim());
        params.put("web", this.webAddress.getEditText().getText().toString().trim());
        params.put("rnmae", this.rname.getEditText().getText().toString().trim());
        params.put("rmobile", this.rmobile.getEditText().getText().toString().trim());
        params.put("rmail", this.rmail.getEditText().getText().toString().trim());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/add_client.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)AddClientActivity.this.getApplicationContext(), (CharSequence)"Client Added Successfully", (int)0).show();
                        AddClientActivity.this.finish();
                    } else {
                        Toast.makeText((Context)AddClientActivity.this.getApplicationContext(), (CharSequence)"Unable to Add Client", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void updateClient() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("mail", preference.getEmailId());
        params.put("type", preference.getCompnayType());
        if (preference.isAdmin()) {
            params.put("role", "admin");
        } else {
            params.put("role", "project");
        }
        params.put("name", this.companyName.getEditText().getText().toString().trim());
        params.put("mobile", this.mobileNumber.getEditText().getText().toString().trim());
        params.put("phone", this.phoneNumber.getEditText().getText().toString().trim());
        params.put("email", this.emailid.getEditText().getText().toString().trim());
        params.put("address", this.address.getEditText().getText().toString().trim());
        params.put("web", this.webAddress.getEditText().getText().toString().trim());
        params.put("rnmae", this.rname.getEditText().getText().toString().trim());
        params.put("rmobile", this.rmobile.getEditText().getText().toString().trim());
        params.put("rmail", this.rmail.getEditText().getText().toString().trim());
        if (this.id != null) {
            params.put("id", this.id);
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/update_client.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)AddClientActivity.this.getApplicationContext(), (CharSequence)"Clinet Details Updated Successfully", (int)0).show();
                        AddClientActivity.this.finish();
                    } else {
                        Toast.makeText((Context)AddClientActivity.this.getApplicationContext(), (CharSequence)"Unable to Update", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void closeKeyboard() {
        InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
        inputManager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 2);
    }
}

