/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectEmployeeActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectTagActivity;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;
import com.google.android.material.snackbar.Snackbar;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AddMilestoneActivity
extends AppCompatActivity {
    EditText milestoneName;
    EditText milestoneDescription;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    private final int TAG_REQUEST_CODE = 22;
    private final int RESPONSIBLE_REQUEST_CODE = 24;
    TextView selectedTag;
    TextView startDate;
    TextView endDate;
    TextView responsiblePerson;
    Calendar calendarStart = Calendar.getInstance();
    Calendar calendarEnd = Calendar.getInstance();
    JSONObject jsonObject = new JSONObject();
    String projectId;
    String milestoneId;
    private boolean projectEdited = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492901);
        this.getWidgets();
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.projectId = this.getIntent().getStringExtra("id");
        if (this.getIntent().getStringExtra("milestone") != null) {
            this.getSupportActionBar().setTitle((CharSequence)"Edit Milestone");
            this.milestoneId = this.getIntent().getStringExtra("milestone");
            try {
                this.setValues();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.getSupportActionBar().setTitle((CharSequence)"New Milestone");
            try {
                this.jsonObject.put("tag", (Object)"");
                this.jsonObject.put("responsible", (Object)"");
                this.jsonObject.put("end", (Object)"");
                this.jsonObject.put("start", (Object)"");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void setValues() throws Exception {
        Database database = Database.getInstance((Context)this);
        JSONObject json = database.getMilestoneDetails(this.milestoneId);
        this.startDate.setText((CharSequence)json.getString(MilestoneTable.STARTDATE));
        this.endDate.setText((CharSequence)json.getString(MilestoneTable.ENDDATE));
        this.selectedTag.setText((CharSequence)database.getTagName(json.getString(MilestoneTable.TAG)));
        this.responsiblePerson.setText((CharSequence)database.getEmployeeName(json.getString(MilestoneTable.RESPONSIBLEPERSON)));
        this.milestoneName.setText((CharSequence)json.getString(MilestoneTable.NAME));
        this.milestoneDescription.setText((CharSequence)json.getString(MilestoneTable.DESCRIPTION));
        try {
            this.jsonObject.put("tag", (Object)json.getString(MilestoneTable.TAG));
            this.jsonObject.put("responsible", (Object)json.getString(MilestoneTable.RESPONSIBLEPERSON));
            this.jsonObject.put("end", (Object)json.getString(MilestoneTable.ENDDATE));
            this.jsonObject.put("start", (Object)json.getString(MilestoneTable.STARTDATE));
            this.jsonObject.put("des", (Object)json.getString(MilestoneTable.DESCRIPTION));
            this.jsonObject.put("name", (Object)json.getString(MilestoneTable.NAME));
            this.calendarStart.setTime(DateUtils.fromDate(this.jsonObject.getString("start")));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void getWidgets() {
        this.milestoneName = (EditText)this.findViewById(2131297012);
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296593);
        this.selectedTag = (TextView)this.findViewById(2131297326);
        this.startDate = (TextView)this.findViewById(2131297407);
        this.endDate = (TextView)this.findViewById(2131296731);
        this.responsiblePerson = (TextView)this.findViewById(2131297273);
        this.milestoneDescription = (EditText)this.findViewById(2131297009);
        this.milestoneName.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus && !AddMilestoneActivity.this.milestoneName.getText().toString().isEmpty()) {
                    AddMilestoneActivity.this.checkMilestoneName(false);
                }
            }
        });
        this.findViewById(2131297449).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddMilestoneActivity.this.startActivityForResult(new Intent(AddMilestoneActivity.this.getApplicationContext(), SelectTagActivity.class), 22);
            }
        });
        this.findViewById(2131297272).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddMilestoneActivity.this.startActivityForResult(new Intent(AddMilestoneActivity.this.getApplicationContext(), SelectEmployeeActivity.class), 24);
            }
        });
        this.findViewById(2131297408).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddMilestoneActivity.this.selectStartDate();
            }
        });
        this.findViewById(2131296732).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddMilestoneActivity.this.selectEndDate();
            }
        });
    }

    private void selectStartDate() {
        DatePickerDialog.OnDateSetListener fromDate = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                AddMilestoneActivity.this.calendarStart.set(1, year);
                AddMilestoneActivity.this.calendarStart.set(2, monthOfYear);
                AddMilestoneActivity.this.calendarStart.set(5, dayOfMonth);
                String myFormat = "yyyy-MM-dd";
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                AddMilestoneActivity.this.startDate.setText((CharSequence)sdf.format(AddMilestoneActivity.this.calendarStart.getTime()));
                try {
                    AddMilestoneActivity.this.jsonObject.put("start", (Object)new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(AddMilestoneActivity.this.calendarStart.getTime()));
                    if (AddMilestoneActivity.this.calendarEnd.getTimeInMillis() < AddMilestoneActivity.this.calendarStart.getTimeInMillis()) {
                        AddMilestoneActivity.this.endDate.setText((CharSequence)"");
                        AddMilestoneActivity.this.jsonObject.put("end", (Object)"");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        };
        DatePickerDialog datePicker = new DatePickerDialog((Context)this, fromDate, this.calendarStart.get(1), this.calendarStart.get(2), this.calendarStart.get(5));
        datePicker.setTitle((CharSequence)"Start Date");
        try {
            JSONObject projectJSON = Database.getInstance((Context)this).getProjectDetails(this.projectId);
            datePicker.getDatePicker().setMinDate(DateUtils.fromDate(projectJSON.getString(ProjectTable.STARTDATE)).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        datePicker.show();
    }

    private void selectEndDate() {
        DatePickerDialog.OnDateSetListener toDate = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                AddMilestoneActivity.this.calendarEnd.set(1, year);
                AddMilestoneActivity.this.calendarEnd.set(2, monthOfYear);
                AddMilestoneActivity.this.calendarEnd.set(5, dayOfMonth);
                String myFormat = "yyyy-MM-dd";
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                AddMilestoneActivity.this.endDate.setText((CharSequence)sdf.format(AddMilestoneActivity.this.calendarEnd.getTime()));
                try {
                    AddMilestoneActivity.this.jsonObject.put("end", (Object)new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(AddMilestoneActivity.this.calendarEnd.getTime()));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.startDate.getText().toString().isEmpty()) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Select from Date", (int)0).show();
            return;
        }
        DatePickerDialog datePicker = new DatePickerDialog((Context)this, toDate, this.calendarEnd.get(1), this.calendarEnd.get(2), this.calendarEnd.get(5));
        datePicker.getDatePicker().setMinDate(this.calendarStart.getTimeInMillis());
        datePicker.setTitle((CharSequence)"End Date");
        datePicker.show();
    }

    private void checkMilestoneName(final boolean goNext) {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.milestoneName.getText().toString().trim());
        params.put("id", this.projectId);
        if (this.milestoneId != null) {
            params.put("milestone", this.milestoneId);
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/check_milestonename.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (!jsonObject.getBoolean("exists")) {
                        if (goNext) {
                            if (AddMilestoneActivity.this.milestoneId == null) {
                                AddMilestoneActivity.this.addMilestone();
                            } else {
                                AddMilestoneActivity.this.updateMilestone();
                            }
                        }
                    } else {
                        Validations.getInstance((Activity)AddMilestoneActivity.this).showAlert("Milestone Name Already Exists");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addMilestone() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            this.jsonObject.put("des", (Object)this.milestoneDescription.getText().toString());
            this.jsonObject.put("name", (Object)this.milestoneName.getText().toString());
            this.jsonObject.put("cname", (Object)preference.getCompanyName());
            this.jsonObject.put("mail", (Object)preference.getEmailId());
            this.jsonObject.put("type", (Object)preference.getCompnayType());
            if (preference.isAdmin()) {
                this.jsonObject.put("role", (Object)preference.getDesignation());
            } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
                this.jsonObject.put("role", (Object)"project");
            } else {
                this.jsonObject.put("role", (Object)"employee");
            }
            this.jsonObject.put("id", (Object)this.projectId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", this.jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/add_milestone.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        Toast.makeText((Context)AddMilestoneActivity.this.getApplicationContext(), (CharSequence)"Milstone Added Successfully", (int)0).show();
                        AddMilestoneActivity.this.checkProjectUpdated();
                    } else {
                        Toast.makeText((Context)AddMilestoneActivity.this.getApplicationContext(), (CharSequence)"Unable to Add Milestone ", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void updateMilestone() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            this.jsonObject.put("des", (Object)this.milestoneDescription.getText().toString());
            this.jsonObject.put("name", (Object)this.milestoneName.getText().toString());
            this.jsonObject.put("cname", (Object)preference.getCompanyName());
            this.jsonObject.put("mail", (Object)preference.getEmailId());
            this.jsonObject.put("type", (Object)preference.getCompnayType());
            if (preference.isAdmin()) {
                this.jsonObject.put("role", (Object)preference.getDesignation());
            } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
                this.jsonObject.put("role", (Object)"project");
            } else {
                this.jsonObject.put("role", (Object)"employee");
            }
            this.jsonObject.put("id", (Object)this.projectId);
            this.jsonObject.put("milestoneid", (Object)this.milestoneId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", this.jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/update_milestone.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)AddMilestoneActivity.this.getApplicationContext(), (CharSequence)"Milstone Updated Successfully", (int)0).show();
                        AddMilestoneActivity.this.checkProjectUpdated();
                    } else {
                        Toast.makeText((Context)AddMilestoneActivity.this.getApplicationContext(), (CharSequence)jsonObject.getString("m"), (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private boolean isValid() {
        Validations validations = Validations.getInstance((Activity)this);
        if (this.milestoneName.getText().toString().isEmpty()) {
            validations.showAlert("Enter Task Name");
            return false;
        }
        if (this.milestoneDescription.getText().toString().isEmpty()) {
            validations.showAlert("Fill Description");
            return false;
        }
        try {
            if (this.jsonObject.getString("responsible").isEmpty()) {
                validations.showAlert("Select Resposible Person");
                return false;
            }
            if (this.jsonObject.getString("start").isEmpty()) {
                validations.showAlert("Select Start Date");
                return false;
            }
            if (this.jsonObject.getString("end").isEmpty()) {
                validations.showAlert("Select End Date");
                return false;
            }
            JSONObject projectJSON = Database.getInstance((Context)this).getProjectDetails(this.projectId);
            int difference = DateUtils.fromDate(this.jsonObject.getString("end")).compareTo(DateUtils.fromDate(projectJSON.getString(ProjectTable.ENDDATE)));
            if (difference > 0) {
                this.projectEdited = true;
                this.showAlert(projectJSON.getString(ProjectTable.ENDDATE));
                return false;
            }
            this.projectEdited = false;
            return true;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                if (!this.isValid()) break;
                this.checkMilestoneName(true);
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 22: {
                    this.selectedTag.setText((CharSequence)data.getStringExtra("name"));
                    try {
                        this.jsonObject.put("tag", (Object)data.getStringExtra("id"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 24: {
                    this.responsiblePerson.setText((CharSequence)data.getStringExtra("name"));
                    try {
                        this.jsonObject.put("responsible", (Object)data.getStringExtra("id"));
                        break;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void showAlert(String deadline) {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)("Selected end date is after the project deadline(" + deadline + "). Project deadline will be extended respectively.")).setPositiveButton((CharSequence)"CONTINUE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                AddMilestoneActivity.this.checkMilestoneName(true);
            }
        }).setNegativeButton((CharSequence)"CLOSE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        }).show();
    }

    private void getProjectsDetails() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("id", this.projectId);
        params.put("list", Database.getInstance((Context)this).getProjectsList().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_projects.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    AddMilestoneActivity.this.getProjects(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getProjects(JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray = jsonObject.getJSONArray("projects");
        try {
            Database.getInstance((Context)this).insertProjects(jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.finish();
    }

    private void checkProjectUpdated() {
        if (this.projectEdited) {
            this.getProjectsDetails();
        } else {
            this.finish();
        }
    }
}

