/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SwitchCompat;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectCategoryActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectCompanyActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectEmployeeActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectTagActivity;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;
import com.google.android.material.snackbar.Snackbar;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class AddProjectActivity
extends AppCompatActivity {
    EditText projectName;
    EditText projectDescription;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    private final int TAG_REQUEST_CODE = 22;
    private final int CAT_REQUEST_CODE = 21;
    private final int COMPNAY_REQUEST_CODE = 23;
    private final int RESPONSIBLE_REQUEST_CODE = 24;
    TextView selectedTag;
    TextView selectedCategoty;
    TextView startDate;
    TextView endDate;
    TextView otherCompany;
    TextView responsiblePerson;
    Calendar calendarStart = Calendar.getInstance();
    Calendar calendarEnd = Calendar.getInstance();
    SwitchCompat isIntenalProject;
    JSONObject jsonObject = new JSONObject();
    JSONObject defaultJSON = new JSONObject();
    String projectId;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492903);
        this.getWidgets();
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        if (this.getIntent().getStringExtra("id") == null) {
            this.getSupportActionBar().setTitle((CharSequence)"New Project");
            try {
                this.jsonObject.put("tag", (Object)"");
                this.jsonObject.put("cat", (Object)"");
                this.jsonObject.put("responsible", (Object)"");
                this.jsonObject.put("companyid", (Object)"");
                this.jsonObject.put("end", (Object)"");
                this.jsonObject.put("start", (Object)"");
                this.jsonObject.put("client", (Object)"1");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            this.projectId = this.getIntent().getStringExtra("id");
            this.getSupportActionBar().setTitle((CharSequence)"Edit Project");
            try {
                this.setValues();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void setValues() throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONObject jsonObject = Database.getInstance((Context)this).getProjectDetails(this.projectId);
        this.projectName.setText((CharSequence)jsonObject.getString(ProjectTable.PROJECTNAME));
        this.projectDescription.setText((CharSequence)jsonObject.getString(ProjectTable.DESCRIPTION));
        if (database.getTagName(jsonObject.getString(ProjectTable.TAGID)).isEmpty()) {
            this.selectedTag.setText((CharSequence)"Tap to Select");
        } else {
            this.selectedTag.setText((CharSequence)database.getTagName(jsonObject.getString(ProjectTable.TAGID)));
        }
        if (database.getCategoryName(jsonObject.getString(ProjectTable.CATID)).isEmpty()) {
            this.selectedCategoty.setText((CharSequence)"Tap to Select");
        } else {
            this.selectedCategoty.setText((CharSequence)database.getCategoryName(jsonObject.getString(ProjectTable.CATID)));
        }
        if (jsonObject.getString(ProjectTable.CLIENT).equalsIgnoreCase("0")) {
            this.isIntenalProject.setChecked(true);
            this.otherCompany.setVisibility(8);
            this.otherCompany.setText((CharSequence)"Tap to Select");
            this.jsonObject.put("client", (Object)"0");
            this.jsonObject.put("companyid", (Object)"Ours");
        } else {
            this.jsonObject.put("client", (Object)"1");
            this.jsonObject.put("companyid", (Object)jsonObject.getString(ProjectTable.CLIENTCOMPANYID));
            this.isIntenalProject.setChecked(false);
            this.otherCompany.setText((CharSequence)database.getClientName(jsonObject.getString(ProjectTable.CLIENTCOMPANYID)));
        }
        this.responsiblePerson.setText((CharSequence)database.getEmployeeName(jsonObject.getString(ProjectTable.RESPONSIBLEPERSON)));
        this.startDate.setText((CharSequence)jsonObject.getString(ProjectTable.STARTDATE));
        this.endDate.setText((CharSequence)jsonObject.getString(ProjectTable.ENDDATE));
        this.jsonObject.put("tag", (Object)jsonObject.getString(ProjectTable.TAGID));
        this.jsonObject.put("cat", (Object)jsonObject.getString(ProjectTable.CATID));
        this.jsonObject.put("responsible", (Object)jsonObject.getString(ProjectTable.RESPONSIBLEPERSON));
        this.jsonObject.put("end", (Object)jsonObject.getString(ProjectTable.STARTDATE));
        this.jsonObject.put("start", (Object)jsonObject.getString(ProjectTable.ENDDATE));
        this.jsonObject.put("des", (Object)jsonObject.getString(ProjectTable.DESCRIPTION));
        this.jsonObject.put("name", (Object)jsonObject.getString(ProjectTable.PROJECTNAME));
        this.defaultJSON = jsonObject;
    }

    private void getWidgets() {
        this.projectName = (EditText)this.findViewById(2131297201);
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296593);
        this.selectedTag = (TextView)this.findViewById(2131297326);
        this.selectedCategoty = (TextView)this.findViewById(2131297323);
        this.startDate = (TextView)this.findViewById(2131297407);
        this.endDate = (TextView)this.findViewById(2131296731);
        this.otherCompany = (TextView)this.findViewById(2131297129);
        this.responsiblePerson = (TextView)this.findViewById(2131297273);
        this.projectDescription = (EditText)this.findViewById(2131297197);
        this.isIntenalProject = (SwitchCompat)this.findViewById(2131296900);
        this.projectName.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus && !AddProjectActivity.this.projectName.getText().toString().isEmpty()) {
                    AddProjectActivity.this.checkProjectName(false);
                }
            }
        });
        this.isIntenalProject.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    AddProjectActivity.this.findViewById(2131297130).setVisibility(8);
                    AddProjectActivity.this.findViewById(2131296681).setVisibility(8);
                    try {
                        AddProjectActivity.this.jsonObject.put("client", (Object)"0");
                        AddProjectActivity.this.jsonObject.put("companyid", (Object)"Ours");
                        AddProjectActivity.this.otherCompany.setText((CharSequence)"Tap to Select");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } else {
                    AddProjectActivity.this.findViewById(2131297130).setVisibility(0);
                    AddProjectActivity.this.findViewById(2131296681).setVisibility(0);
                    try {
                        AddProjectActivity.this.jsonObject.put("client", (Object)"1");
                        AddProjectActivity.this.jsonObject.put("companyid", (Object)"Ours");
                        AddProjectActivity.this.otherCompany.setText((CharSequence)"");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.findViewById(2131297449).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddProjectActivity.this.startActivityForResult(new Intent(AddProjectActivity.this.getApplicationContext(), SelectTagActivity.class), 22);
            }
        });
        this.findViewById(2131296500).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddProjectActivity.this.startActivityForResult(new Intent(AddProjectActivity.this.getApplicationContext(), SelectCategoryActivity.class), 21);
            }
        });
        this.findViewById(2131297130).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddProjectActivity.this.startActivityForResult(new Intent(AddProjectActivity.this.getApplicationContext(), SelectCompanyActivity.class), 23);
            }
        });
        this.findViewById(2131297272).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddProjectActivity.this.startActivityForResult(new Intent(AddProjectActivity.this.getApplicationContext(), SelectEmployeeActivity.class), 24);
            }
        });
        this.findViewById(2131297408).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddProjectActivity.this.selectStartDate();
            }
        });
        this.findViewById(2131296732).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddProjectActivity.this.selectEndDate();
            }
        });
    }

    private void checkProjectName(final boolean goNext) {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("pname", this.projectName.getText().toString().trim());
        if (this.projectId != null) {
            params.put("id", this.projectId);
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/check_projectname.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (!jsonObject.getBoolean("exists")) {
                        if (goNext) {
                            if (AddProjectActivity.this.projectId == null) {
                                AddProjectActivity.this.addProject();
                            } else {
                                AddProjectActivity.this.updateProject();
                            }
                        }
                    } else {
                        Validations.getInstance((Activity)AddProjectActivity.this).showAlert("Project Name Already Exists");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 22: {
                    this.selectedTag.setText((CharSequence)data.getStringExtra("name"));
                    try {
                        this.jsonObject.put("tag", (Object)data.getStringExtra("id"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 21: {
                    this.selectedCategoty.setText((CharSequence)data.getStringExtra("name"));
                    try {
                        this.jsonObject.put("cat", (Object)data.getStringExtra("id"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 23: {
                    this.otherCompany.setText((CharSequence)data.getStringExtra("name"));
                    try {
                        this.jsonObject.put("companyid", (Object)data.getStringExtra("id"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 24: {
                    this.responsiblePerson.setText((CharSequence)data.getStringExtra("name"));
                    try {
                        this.jsonObject.put("responsible", (Object)data.getStringExtra("id"));
                        break;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void selectStartDate() {
        DatePickerDialog.OnDateSetListener fromDate = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                AddProjectActivity.this.calendarStart.set(1, year);
                AddProjectActivity.this.calendarStart.set(2, monthOfYear);
                AddProjectActivity.this.calendarStart.set(5, dayOfMonth);
                String myFormat = "dd/MM/yyyy";
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                AddProjectActivity.this.startDate.setText((CharSequence)sdf.format(AddProjectActivity.this.calendarStart.getTime()));
                try {
                    AddProjectActivity.this.jsonObject.put("start", (Object)new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(AddProjectActivity.this.calendarStart.getTime()));
                    if (AddProjectActivity.this.calendarEnd.getTimeInMillis() < AddProjectActivity.this.calendarStart.getTimeInMillis()) {
                        AddProjectActivity.this.endDate.setText((CharSequence)"");
                        AddProjectActivity.this.jsonObject.put("end", (Object)"");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        };
        DatePickerDialog datePicker = new DatePickerDialog((Context)this, fromDate, this.calendarStart.get(1), this.calendarStart.get(2), this.calendarStart.get(5));
        datePicker.setTitle((CharSequence)"Start Date");
        datePicker.show();
    }

    private void selectEndDate() {
        DatePickerDialog.OnDateSetListener toDate = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                AddProjectActivity.this.calendarEnd.set(1, year);
                AddProjectActivity.this.calendarEnd.set(2, monthOfYear);
                AddProjectActivity.this.calendarEnd.set(5, dayOfMonth);
                String myFormat = "dd/MM/yyyy";
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                AddProjectActivity.this.endDate.setText((CharSequence)sdf.format(AddProjectActivity.this.calendarEnd.getTime()));
                try {
                    AddProjectActivity.this.jsonObject.put("end", (Object)new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(AddProjectActivity.this.calendarEnd.getTime()));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.startDate.getText().toString().isEmpty()) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Select from Date", (int)0).show();
            return;
        }
        DatePickerDialog datePicker = new DatePickerDialog((Context)this, toDate, this.calendarEnd.get(1), this.calendarEnd.get(2), this.calendarEnd.get(5));
        datePicker.getDatePicker().setMinDate(this.calendarStart.getTimeInMillis());
        datePicker.setTitle((CharSequence)"End Date");
        datePicker.show();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                if (!this.isValid()) break;
                this.checkProjectName(true);
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void addProject() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("mail", preference.getEmailId());
        params.put("type", preference.getCompnayType());
        if (preference.isAdmin()) {
            params.put("role", preference.getDesignation());
        } else {
            params.put("role", "project");
        }
        try {
            this.jsonObject.put("des", (Object)this.projectDescription.getText().toString());
            this.jsonObject.put("name", (Object)this.projectName.getText().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", this.jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/add_project.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        Toast.makeText((Context)AddProjectActivity.this.getApplicationContext(), (CharSequence)"Project Created Successfully", (int)0).show();
                        AddProjectActivity.this.finish();
                    } else {
                        Toast.makeText((Context)AddProjectActivity.this.getApplicationContext(), (CharSequence)"Unable to Create Project", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void updateProject() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("mail", preference.getEmailId());
        params.put("type", preference.getCompnayType());
        if (this.projectId != null) {
            params.put("id", this.projectId);
        }
        if (preference.isAdmin()) {
            params.put("role", preference.getDesignation());
        } else {
            params.put("role", "project");
        }
        try {
            this.jsonObject.put("des", (Object)this.projectDescription.getText().toString());
            this.jsonObject.put("name", (Object)this.projectName.getText().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (this.defaultJSON.toString().equalsIgnoreCase(this.jsonObject.toString())) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Project Updated Successfully", (int)0).show();
            this.finish();
        }
        params.put("data", this.jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/update_project.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)AddProjectActivity.this.getApplicationContext(), (CharSequence)"Project Updated Successfully", (int)0).show();
                        AddProjectActivity.this.finish();
                    } else {
                        Toast.makeText((Context)AddProjectActivity.this.getApplicationContext(), (CharSequence)"Unable to Update Project", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private boolean isValid() {
        Validations validations = Validations.getInstance((Activity)this);
        if (this.projectName.getText().toString().isEmpty()) {
            validations.showAlert("Enter Project Name");
            return false;
        }
        if (this.projectDescription.getText().toString().isEmpty()) {
            validations.showAlert("Fill Description");
            return false;
        }
        try {
            if (this.jsonObject.getString("responsible").isEmpty()) {
                validations.showAlert("Select Resposible Person");
                return false;
            }
            if (this.jsonObject.getString("start").isEmpty()) {
                validations.showAlert("Select Start Date");
                return false;
            }
            if (this.jsonObject.getString("end").isEmpty()) {
                validations.showAlert("Select End Date");
                return false;
            }
            if (this.jsonObject.getString("client").equalsIgnoreCase("1") && this.jsonObject.getString("companyid").isEmpty()) {
                validations.showAlert("Select Company");
                return false;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return true;
    }
}

