/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TagTable;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class AddTagActivity
extends AppCompatActivity {
    EditText tagName;
    Spinner weightage;
    String id;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492897);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.id = this.getIntent().getStringExtra("id");
        this.tagName = (EditText)this.findViewById(2131297450);
        this.weightage = (Spinner)this.findViewById(2131297719);
        this.weightage.setMinimumHeight(this.tagName.getHeight());
        if (this.id != null) {
            this.getSupportActionBar().setTitle((CharSequence)"Edit Tag");
            try {
                this.setValues();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            this.getSupportActionBar().setTitle((CharSequence)"New Tag");
        }
    }

    private void setValues() throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONObject jsonObject = database.getTagDetails(this.id);
        this.tagName.setText((CharSequence)jsonObject.getString(TagTable.TAGNAME));
        this.weightage.setSelection(jsonObject.getInt(TagTable.WEIGHTAGE) - 1);
    }

    private void checkTagName(final boolean goNext) {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("name", this.tagName.getText().toString().trim());
        if (this.id != null) {
            params.put("id", this.id);
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/check_tagname.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (!jsonObject.getBoolean("exists")) {
                        if (goNext) {
                            if (AddTagActivity.this.id != null) {
                                AddTagActivity.this.updateTag();
                            } else {
                                AddTagActivity.this.addTag();
                            }
                        }
                    } else {
                        Validations.getInstance((Activity)AddTagActivity.this).showAlert("Tag Name Already Exists");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addTag() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("cname", (Object)preference.getCompanyName());
            jsonObject.put("mail", (Object)preference.getEmailId());
            jsonObject.put("type", (Object)preference.getCompnayType());
            if (preference.isAdmin()) {
                jsonObject.put("role", (Object)"admin");
            } else {
                jsonObject.put("role", (Object)"project");
            }
            jsonObject.put("wieghtage", (Object)this.weightage.getSelectedItem().toString());
            jsonObject.put("name", (Object)this.tagName.getText().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/add_tag.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)AddTagActivity.this.getApplicationContext(), (CharSequence)"Tag Created Successfully", (int)0).show();
                        AddTagActivity.this.finish();
                    } else {
                        Toast.makeText((Context)AddTagActivity.this.getApplicationContext(), (CharSequence)"Unable to Create Tag", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void updateTag() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("cname", (Object)preference.getCompanyName());
            jsonObject.put("mail", (Object)preference.getEmailId());
            jsonObject.put("type", (Object)preference.getCompnayType());
            if (preference.isAdmin()) {
                jsonObject.put("role", (Object)"admin");
            } else {
                jsonObject.put("role", (Object)"project");
            }
            jsonObject.put("wieghtage", (Object)this.weightage.getSelectedItem().toString());
            jsonObject.put("name", (Object)this.tagName.getText().toString());
            jsonObject.put("id", (Object)this.id);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/update_tag.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)AddTagActivity.this.getApplicationContext(), (CharSequence)"Tag Updated Successfully", (int)0).show();
                        AddTagActivity.this.finish();
                    } else {
                        Toast.makeText((Context)AddTagActivity.this.getApplicationContext(), (CharSequence)"Unable to Update Tag", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private boolean isValid() {
        Validations validations = Validations.getInstance((Activity)this);
        if (this.tagName.getText().toString().isEmpty()) {
            validations.showAlert("Enter Name");
            return false;
        }
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                if (!this.isValid()) break;
                this.checkTagName(true);
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

