/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectCategoryActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectEmployeeActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectTagActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectTasklistActivity;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;
import com.google.android.material.snackbar.Snackbar;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AddTaskActivity
extends AppCompatActivity {
    EditText taskName;
    EditText taskDescription;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    private final int TAG_REQUEST_CODE = 22;
    private final int PROJECT_REQUEST_CODE = 21;
    private final int TASKLIST_REQUEST_CODE = 23;
    private final int RESPONSIBLE_REQUEST_CODE = 24;
    TextView selectedTag;
    TextView selectedProject;
    TextView startDate;
    TextView endDate;
    TextView selectedTasklist;
    TextView assignedPerson;
    TextView priority;
    Calendar calendarStart = Calendar.getInstance();
    Calendar calendarEnd = Calendar.getInstance();
    JSONObject jsonObject = new JSONObject();
    String projectId;
    String taskId;
    String employeeId = "";
    String assignId = "";
    private boolean projectEdited = false;
    private boolean milestoneEdited = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492905);
        this.projectId = this.getIntent().getStringExtra("id");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getWidgets();
        if (this.getIntent().getStringExtra("taskId") != null) {
            this.taskId = this.getIntent().getStringExtra("taskId");
            try {
                this.setValues();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.getSupportActionBar().setTitle((CharSequence)"New Task");
            try {
                this.jsonObject.put("project", (Object)"");
                this.jsonObject.put("tag", (Object)"");
                this.jsonObject.put("tasklist", (Object)"");
                this.jsonObject.put("assignedTo", (Object)"");
                this.jsonObject.put("priority", (Object)"");
                this.jsonObject.put("end", (Object)"");
                this.jsonObject.put("start", (Object)"");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.setListeners();
    }

    private void setValues() throws Exception {
        Database database = Database.getInstance((Context)this);
        JSONObject json = database.getTaskDetails(this.taskId);
        this.taskName.setText((CharSequence)json.getString("task_name"));
        this.taskDescription.setText((CharSequence)json.getString("t_description"));
        this.startDate.setText((CharSequence)json.getString("t_start_date"));
        this.endDate.setText((CharSequence)json.getString("t_end_date"));
        this.priority.setText((CharSequence)json.getString("t_priority"));
        try {
            if (!json.getString("employee_id").equalsIgnoreCase("null")) {
                this.assignedPerson.setText((CharSequence)database.getEmployeeName(json.getString("employee_id")));
                this.employeeId = json.getString("employee_id");
                this.assignId = json.getString("assign_id");
                this.jsonObject.put("assignedTo", (Object)json.getString("employee_id"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.jsonObject.put("assignedTo", (Object)"");
        }
        this.selectedTasklist.setText((CharSequence)database.getTaskListName(json.getString("listtask_id")));
        this.selectedProject.setText((CharSequence)database.getProjectName(json.getString("t_project_id")));
        this.selectedTag.setText((CharSequence)database.getTagName(json.getString("t_tag")));
        this.jsonObject.put("project", (Object)json.getString("t_project_id"));
        this.jsonObject.put("tag", (Object)json.getString("t_tag"));
        this.jsonObject.put("tasklist", (Object)json.getString("listtask_id"));
        this.jsonObject.put("priority", (Object)json.getString("t_priority"));
        this.jsonObject.put("end", (Object)json.getString("t_end_date"));
        this.jsonObject.put("start", (Object)json.getString("t_start_date"));
        this.jsonObject.put("name", (Object)json.getString("task_name"));
        this.jsonObject.put("des", (Object)json.getString("t_description"));
        this.calendarStart.setTime(DateUtils.fromDate(this.jsonObject.getString("start")));
    }

    private void getWidgets() {
        this.taskName = (EditText)this.findViewById(2131297470);
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296593);
        this.selectedTag = (TextView)this.findViewById(2131297326);
        this.selectedProject = (TextView)this.findViewById(2131297325);
        this.startDate = (TextView)this.findViewById(2131297407);
        this.endDate = (TextView)this.findViewById(2131296731);
        this.selectedTasklist = (TextView)this.findViewById(2131297327);
        this.assignedPerson = (TextView)this.findViewById(2131296405);
        this.priority = (TextView)this.findViewById(2131297176);
        this.taskDescription = (EditText)this.findViewById(2131297465);
    }

    private void setListeners() {
        this.findViewById(2131297449).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddTaskActivity.this.startActivityForResult(new Intent(AddTaskActivity.this.getApplicationContext(), SelectTagActivity.class), 22);
            }
        });
        if (this.projectId.isEmpty()) {
            this.findViewById(2131297200).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent(AddTaskActivity.this.getApplicationContext(), SelectCategoryActivity.class);
                    intent.putExtra("id", AddTaskActivity.this.projectId);
                    AddTaskActivity.this.startActivityForResult(intent, 21);
                }
            });
        } else {
            try {
                this.jsonObject.put("project", (Object)this.projectId);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.selectedProject.setText((CharSequence)Database.getInstance((Context)this).getProjectName(this.projectId));
        }
        this.findViewById(2131297483).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent(AddTaskActivity.this.getApplicationContext(), SelectTasklistActivity.class);
                intent.putExtra("id", AddTaskActivity.this.projectId);
                intent.putExtra("return", true);
                if (AddTaskActivity.this.taskId == null) {
                    AddTaskActivity.this.startActivityForResult(intent, 23);
                }
            }
        });
        this.findViewById(2131296404).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddTaskActivity.this.startActivityForResult(new Intent(AddTaskActivity.this.getApplicationContext(), SelectEmployeeActivity.class), 24);
            }
        });
        this.findViewById(2131297408).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddTaskActivity.this.selectStartDate();
            }
        });
        this.findViewById(2131296732).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddTaskActivity.this.selectEndDate();
            }
        });
        this.findViewById(2131297178).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddTaskActivity.this.selectPriority();
            }
        });
    }

    private void selectStartDate() {
        DatePickerDialog.OnDateSetListener fromDate = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                AddTaskActivity.this.calendarStart.set(1, year);
                AddTaskActivity.this.calendarStart.set(2, monthOfYear);
                AddTaskActivity.this.calendarStart.set(5, dayOfMonth);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
                AddTaskActivity.this.startDate.setText((CharSequence)sdf.format(AddTaskActivity.this.calendarStart.getTime()));
                try {
                    AddTaskActivity.this.jsonObject.put("start", (Object)sdf.format(AddTaskActivity.this.calendarStart.getTime()));
                    if (AddTaskActivity.this.calendarEnd.getTimeInMillis() < AddTaskActivity.this.calendarStart.getTimeInMillis()) {
                        AddTaskActivity.this.endDate.setText((CharSequence)"");
                        AddTaskActivity.this.jsonObject.put("end", (Object)"");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        };
        DatePickerDialog datePicker = new DatePickerDialog((Context)this, fromDate, this.calendarStart.get(1), this.calendarStart.get(2), this.calendarStart.get(5));
        datePicker.setTitle((CharSequence)"Start Date");
        datePicker.show();
    }

    private void selectEndDate() {
        DatePickerDialog.OnDateSetListener toDate = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                AddTaskActivity.this.calendarEnd.set(1, year);
                AddTaskActivity.this.calendarEnd.set(2, monthOfYear);
                AddTaskActivity.this.calendarEnd.set(5, dayOfMonth);
                String myFormat = "yyyy-MM-dd";
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.getDefault());
                AddTaskActivity.this.endDate.setText((CharSequence)sdf.format(AddTaskActivity.this.calendarEnd.getTime()));
                try {
                    AddTaskActivity.this.jsonObject.put("end", (Object)sdf.format(AddTaskActivity.this.calendarEnd.getTime()));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.startDate.getText().toString().isEmpty()) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Select from Date", (int)0).show();
            return;
        }
        DatePickerDialog datePicker = new DatePickerDialog((Context)this, toDate, this.calendarEnd.get(1), this.calendarEnd.get(2), this.calendarEnd.get(5));
        datePicker.getDatePicker().setMinDate(this.calendarStart.getTimeInMillis());
        datePicker.setTitle((CharSequence)"End Date");
        datePicker.show();
    }

    private void selectPriority() {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)this);
        LayoutInflater inflater = this.getLayoutInflater();
        View dialogView = inflater.inflate(2131493068, null);
        dialogBuilder.setView(dialogView);
        final AlertDialog alertDialog = dialogBuilder.create();
        RadioButton priorityHigh = (RadioButton)dialogView.findViewById(2131297177);
        RadioButton priorityMedium = (RadioButton)dialogView.findViewById(2131297180);
        RadioButton priorityLow = (RadioButton)dialogView.findViewById(2131297179);
        priorityHigh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertDialog.hide();
                AddTaskActivity.this.priority.setText(2131820707);
                try {
                    AddTaskActivity.this.jsonObject.put("priority", (Object)"High");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
        priorityMedium.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertDialog.hide();
                AddTaskActivity.this.priority.setText(2131820709);
                try {
                    AddTaskActivity.this.jsonObject.put("priority", (Object)"Medium");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
        priorityLow.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertDialog.hide();
                AddTaskActivity.this.priority.setText(2131820708);
                try {
                    AddTaskActivity.this.jsonObject.put("priority", (Object)"Low");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
        alertDialog.show();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 22: {
                    this.selectedTag.setText((CharSequence)data.getStringExtra("name"));
                    try {
                        this.jsonObject.put("tag", (Object)data.getStringExtra("id"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 21: {
                    this.selectedProject.setText((CharSequence)data.getStringExtra("name"));
                    try {
                        this.jsonObject.put("project", (Object)data.getStringExtra("id"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 23: {
                    this.selectedTasklist.setText((CharSequence)data.getStringExtra("name"));
                    try {
                        this.jsonObject.put("tasklist", (Object)data.getStringExtra("id"));
                        this.jsonObject.put("milestone", (Object)data.getStringExtra("milestone"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 24: {
                    this.assignedPerson.setText((CharSequence)data.getStringExtra("name"));
                    try {
                        this.jsonObject.put("assignedTo", (Object)data.getStringExtra("id"));
                        break;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                if (!this.isValid()) break;
                this.checkTaskName(true);
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private boolean isValid() {
        Validations validations = Validations.getInstance((Activity)this);
        if (this.taskName.getText().toString().isEmpty()) {
            validations.showAlert("Enter Task Name");
            return false;
        }
        if (this.taskDescription.getText().toString().isEmpty()) {
            validations.showAlert("Fill Description");
            return false;
        }
        try {
            Date enddate;
            if (this.jsonObject.getString("tasklist").isEmpty()) {
                validations.showAlert("Select TaskList");
                return false;
            }
            if (this.jsonObject.getString("priority").isEmpty()) {
                validations.showAlert("Choose Priority");
                return false;
            }
            if (this.jsonObject.getString("start").isEmpty()) {
                validations.showAlert("Provide Start Date");
                return false;
            }
            if (this.jsonObject.getString("end").isEmpty()) {
                validations.showAlert("Provide End Date");
                return false;
            }
            JSONObject projectJSON = Database.getInstance((Context)this).getProjectDetails(this.projectId);
            JSONObject milestonJSON = Database.getInstance((Context)this).getMilestoneDetails(this.jsonObject.getString("milestone"));
            Date projectEnddate = DateUtils.fromDate(projectJSON.getString(ProjectTable.ENDDATE));
            Date milestoneEnddate = DateUtils.fromDate(milestonJSON.getString(MilestoneTable.ENDDATE));
            if (milestoneEnddate.before(enddate = this.calendarEnd.getTime())) {
                this.milestoneEdited = true;
                if (projectEnddate.before(enddate)) {
                    String str = "Selected end date is after the project deadline(" + projectJSON.getString(ProjectTable.ENDDATE) + ") and milestone deadline(" + milestonJSON.getString(MilestoneTable.ENDDATE) + "), Both deadlines will be extended";
                    this.showAlert(str);
                    this.projectEdited = true;
                } else {
                    String str = "Selected end date is after the milestone deadline(" + milestonJSON.getString(MilestoneTable.ENDDATE) + "). Milestone deadline will be extended";
                    this.showAlert(str);
                    this.projectEdited = false;
                }
                return false;
            }
            this.milestoneEdited = false;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return true;
    }

    private void checkTaskName(final boolean goNext) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.taskName.getText().toString().trim());
        try {
            params.put("id", this.jsonObject.getString("tasklist"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (this.taskId != null) {
            params.put("taskId", this.taskId);
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/check_taskname.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (!jsonObject.getBoolean("exists")) {
                        if (goNext) {
                            if (AddTaskActivity.this.taskId == null) {
                                AddTaskActivity.this.addTask();
                            } else {
                                AddTaskActivity.this.updateTask();
                            }
                        }
                    } else {
                        Validations.getInstance((Activity)AddTaskActivity.this).showAlert("Task Name Already Exists");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addTask() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            this.jsonObject.put("name", (Object)this.taskName.getText().toString());
            this.jsonObject.put("des", (Object)this.taskDescription.getText().toString());
            this.jsonObject.put("cname", (Object)preference.getCompanyName());
            this.jsonObject.put("mail", (Object)preference.getEmailId());
            this.jsonObject.put("type", (Object)preference.getCompnayType());
            if (preference.isAdmin()) {
                this.jsonObject.put("role", (Object)preference.getDesignation());
            } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
                this.jsonObject.put("role", (Object)"project");
            } else {
                this.jsonObject.put("role", (Object)"employee");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", this.jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/add_task.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json = new JSONObject(response);
                    if (json.getInt("s") == 1) {
                        if (!AddTaskActivity.this.jsonObject.getString("assignedTo").isEmpty()) {
                            AddTaskActivity.this.assignTask(AddTaskActivity.this.jsonObject.getString("assignedTo"), json.getString("id"), "Task Added Successfully");
                        } else {
                            Toast.makeText((Context)AddTaskActivity.this.getApplicationContext(), (CharSequence)"Task Added Successfully", (int)0).show();
                            AddTaskActivity.this.checkUpdates();
                        }
                    } else {
                        Toast.makeText((Context)AddTaskActivity.this.getApplicationContext(), (CharSequence)"Unable to Add Task ", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void assignTask(String employeeid, String taskId, final String message) {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("taskId", (Object)taskId);
            jsonObject.put("assignedTo", (Object)employeeid);
            jsonObject.put("cname", (Object)preference.getCompanyName());
            jsonObject.put("mail", (Object)preference.getEmailId());
            jsonObject.put("type", (Object)preference.getCompnayType());
            jsonObject.put("role", (Object)preference.getDesignation());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/task_assign.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)AddTaskActivity.this.getApplicationContext(), (CharSequence)message, (int)0).show();
                    }
                    AddTaskActivity.this.finish();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void updateTask() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            this.jsonObject.put("name", (Object)this.taskName.getText().toString());
            this.jsonObject.put("des", (Object)this.taskDescription.getText().toString());
            this.jsonObject.put("cname", (Object)preference.getCompanyName());
            this.jsonObject.put("mail", (Object)preference.getEmailId());
            this.jsonObject.put("type", (Object)preference.getCompnayType());
            this.jsonObject.put("employee", (Object)this.employeeId);
            if (preference.isAdmin()) {
                this.jsonObject.put("role", (Object)preference.getDesignation());
            } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
                this.jsonObject.put("role", (Object)"project");
            } else {
                this.jsonObject.put("role", (Object)"employee");
            }
            if (this.assignId != null) {
                this.jsonObject.put("assignId", (Object)this.assignId);
            }
            this.jsonObject.put("taskId", (Object)this.taskId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", this.jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/update_task.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json = new JSONObject(response);
                    if (json.getInt("s") == 1) {
                        if (!AddTaskActivity.this.jsonObject.getString("assignedTo").isEmpty() && !AddTaskActivity.this.jsonObject.getString("assignedTo").equalsIgnoreCase(AddTaskActivity.this.employeeId)) {
                            AddTaskActivity.this.assignTask(AddTaskActivity.this.jsonObject.getString("assignedTo"), AddTaskActivity.this.taskId, "Task Updated Successfully");
                        } else {
                            Toast.makeText((Context)AddTaskActivity.this.getApplicationContext(), (CharSequence)"Task Updated Successfully", (int)0).show();
                            AddTaskActivity.this.checkUpdates();
                        }
                    } else {
                        Toast.makeText((Context)AddTaskActivity.this.getApplicationContext(), (CharSequence)"Unable to Update Task ", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void showAlert(String str) {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)str).setPositiveButton((CharSequence)"CONTINUE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                AddTaskActivity.this.checkTaskName(true);
            }
        }).setNegativeButton((CharSequence)"CLOSE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        }).show();
    }

    private void checkUpdates() {
        if (this.milestoneEdited) {
            this.getMilestones();
        } else if (this.projectEdited) {
            this.getProjectsDetails();
        } else {
            this.finish();
        }
    }

    private void getProjectsDetails() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("id", this.projectId);
        params.put("list", Database.getInstance((Context)this).getProjectsList().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_projects.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONArray jsonArray = AddTaskActivity.this.jsonObject.getJSONArray("projects");
                    try {
                        Database.getInstance(AddTaskActivity.this.getApplicationContext()).insertProjects(jsonArray);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    AddTaskActivity.this.finish();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getMilestones() {
        Preference preference = Preference.getInstance((Context)this);
        Database database = Database.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("id", this.projectId);
        try {
            params.put("mid", this.jsonObject.getString("milestoneid"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_milestones.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    Database database = Database.getInstance(AddTaskActivity.this.getApplicationContext());
                    JSONArray jsonArray = AddTaskActivity.this.jsonObject.getJSONArray("list");
                    try {
                        database.insertMilestones(jsonArray);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (AddTaskActivity.this.projectEdited) {
                        AddTaskActivity.this.getProjectsDetails();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

