/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectEmployeeActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectMilestoneActivity;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.Validations;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;
import com.google.android.material.snackbar.Snackbar;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class AddTaskListActivity
extends AppCompatActivity {
    EditText tasklistName;
    EditText tasklistDescription;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    private final int MILESTONE_REQUEST_CODE = 22;
    private final int RESPONSIBLE_REQUEST_CODE = 24;
    TextView selectedMilestone;
    TextView responsiblePerson;
    JSONObject jsonObject = new JSONObject();
    String projectId;
    String tasklistId;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492906);
        this.getWidgets();
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.projectId = this.getIntent().getStringExtra("id");
        if (this.getIntent().getStringExtra("tasklistId") != null) {
            this.tasklistId = this.getIntent().getStringExtra("tasklistId");
            try {
                this.setValues();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.getSupportActionBar().setTitle((CharSequence)"New TaskList");
            try {
                this.jsonObject.put("milestone", (Object)"");
                this.jsonObject.put("responsible", (Object)"");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void setValues() throws Exception {
        Database database = Database.getInstance((Context)this);
        JSONObject json = database.getTasklsitDetails(this.tasklistId);
        this.selectedMilestone.setText((CharSequence)database.getMilestoneName(json.getString(TasklistTable.MILESTONEID)));
        this.responsiblePerson.setText((CharSequence)database.getEmployeeName(json.getString(TasklistTable.RESPONSIBLEPERSON)));
        this.tasklistName.setText((CharSequence)json.getString(TasklistTable.NAME));
        this.tasklistDescription.setText((CharSequence)json.getString(TasklistTable.DESCRIPTION));
        try {
            this.jsonObject.put("milestone", (Object)json.getString(TasklistTable.MILESTONEID));
            this.jsonObject.put("responsible", (Object)json.getString(TasklistTable.RESPONSIBLEPERSON));
            this.jsonObject.put("des", (Object)json.getString(TasklistTable.DESCRIPTION));
            this.jsonObject.put("name", (Object)json.getString(TasklistTable.NAME));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void getWidgets() {
        this.tasklistName = (EditText)this.findViewById(2131297484);
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296593);
        this.selectedMilestone = (TextView)this.findViewById(2131297324);
        this.responsiblePerson = (TextView)this.findViewById(2131297273);
        this.tasklistDescription = (EditText)this.findViewById(2131297481);
        this.tasklistName.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus && !AddTaskListActivity.this.tasklistName.getText().toString().isEmpty()) {
                    AddTaskListActivity.this.checkTasklistName(false);
                }
            }
        });
        this.findViewById(2131297016).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent(AddTaskListActivity.this.getApplicationContext(), SelectMilestoneActivity.class);
                intent.putExtra("id", AddTaskListActivity.this.projectId);
                AddTaskListActivity.this.startActivityForResult(intent, 22);
            }
        });
        this.findViewById(2131297272).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AddTaskListActivity.this.startActivityForResult(new Intent(AddTaskListActivity.this.getApplicationContext(), SelectEmployeeActivity.class), 24);
            }
        });
    }

    private void checkTasklistName(final boolean goNext) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.tasklistName.getText().toString().trim());
        params.put("id", this.projectId);
        if (this.tasklistId != null) {
            params.put("listtask", this.tasklistId);
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/check_tasklistname.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (!jsonObject.getBoolean("exists")) {
                        if (goNext) {
                            if (AddTaskListActivity.this.tasklistId == null) {
                                AddTaskListActivity.this.addTasklist();
                            } else {
                                AddTaskListActivity.this.updateTasklist();
                            }
                        }
                    } else {
                        Validations.getInstance((Activity)AddTaskListActivity.this).showAlert("Tasklist Name Already Exists");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void addTasklist() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            this.jsonObject.put("des", (Object)this.tasklistDescription.getText().toString());
            this.jsonObject.put("name", (Object)this.tasklistName.getText().toString());
            this.jsonObject.put("cname", (Object)preference.getCompanyName());
            this.jsonObject.put("mail", (Object)preference.getEmailId());
            this.jsonObject.put("type", (Object)preference.getCompnayType());
            this.jsonObject.put("id", (Object)this.projectId);
            if (preference.isAdmin()) {
                this.jsonObject.put("role", (Object)preference.getDesignation());
            } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
                this.jsonObject.put("role", (Object)"project");
            } else {
                this.jsonObject.put("role", (Object)"employee");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", this.jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/add_tasklist.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        Toast.makeText((Context)AddTaskListActivity.this.getApplicationContext(), (CharSequence)"Tasklist Added Successfully", (int)0).show();
                        AddTaskListActivity.this.finish();
                    } else {
                        Toast.makeText((Context)AddTaskListActivity.this.getApplicationContext(), (CharSequence)"Unable to Add Tasklist ", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void updateTasklist() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            this.jsonObject.put("des", (Object)this.tasklistDescription.getText().toString());
            this.jsonObject.put("name", (Object)this.tasklistName.getText().toString());
            this.jsonObject.put("cname", (Object)preference.getCompanyName());
            this.jsonObject.put("mail", (Object)preference.getEmailId());
            this.jsonObject.put("type", (Object)preference.getCompnayType());
            this.jsonObject.put("id", (Object)this.projectId);
            this.jsonObject.put("tasklist", (Object)this.tasklistId);
            if (preference.isAdmin()) {
                this.jsonObject.put("role", (Object)preference.getDesignation());
            } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
                this.jsonObject.put("role", (Object)"project");
            } else {
                this.jsonObject.put("role", (Object)"employee");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", this.jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/update_tasklist.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)AddTaskListActivity.this.getApplicationContext(), (CharSequence)"Tasklist Updated Successfully", (int)0).show();
                        AddTaskListActivity.this.finish();
                    } else {
                        Toast.makeText((Context)AddTaskListActivity.this.getApplicationContext(), (CharSequence)"Unable to Update Tasklist ", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private boolean isValid() {
        Validations validations = Validations.getInstance((Activity)this);
        if (this.tasklistName.getText().toString().isEmpty()) {
            validations.showAlert("Enter Name");
            return false;
        }
        if (this.tasklistDescription.getText().toString().isEmpty()) {
            validations.showAlert("Fill Description");
            return false;
        }
        try {
            if (this.jsonObject.getString("responsible").isEmpty()) {
                validations.showAlert("Select Resposible Person");
                return false;
            }
            if (this.jsonObject.getString("milestone").isEmpty()) {
                validations.showAlert("Select Milestone");
                return false;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                if (!this.isValid()) break;
                this.checkTasklistName(true);
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            switch (requestCode) {
                case 22: {
                    this.selectedMilestone.setText((CharSequence)data.getStringExtra("name"));
                    try {
                        this.jsonObject.put("milestone", (Object)data.getStringExtra("id"));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 24: {
                    this.responsiblePerson.setText((CharSequence)data.getStringExtra("name"));
                    try {
                        this.jsonObject.put("responsible", (Object)data.getStringExtra("id"));
                        break;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

