/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.EditText;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class ReduceProgressActivity
extends AppCompatActivity {
    EditText reasonText;
    TextView taskName;
    TextView completedPercentage;
    SeekBar perccentageSeekbar;
    String projectId;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492987);
        this.reasonText = (EditText)this.findViewById(2131297237);
        this.taskName = (TextView)this.findViewById(2131297470);
        this.completedPercentage = (TextView)this.findViewById(2131296551);
        this.perccentageSeekbar = (SeekBar)this.findViewById(2131297151);
        this.perccentageSeekbar.setMax(90);
        this.getSupportActionBar().setTitle((CharSequence)"Reduce Progress");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.projectId = this.getIntent().getStringExtra("id");
        this.taskName.setText((CharSequence)this.getIntent().getStringExtra("name"));
        this.perccentageSeekbar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                ReduceProgressActivity.this.completedPercentage.setText((CharSequence)String.format("%d%%", seekBar.getProgress()));
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                if (!this.isValid()) break;
                this.reduceProgress();
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private boolean isValid() {
        if (this.reasonText.getText().toString().isEmpty()) {
            new AlertDialog.Builder((Context)this).setMessage((CharSequence)"Enter Valid Reason").setPositiveButton((CharSequence)"CLOSE", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                }
            }).show();
            return false;
        }
        if (this.perccentageSeekbar.getProgress() == 90) {
            new AlertDialog.Builder((Context)this).setMessage((CharSequence)"Reduce the Progress").setPositiveButton((CharSequence)"CLOSE", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                }
            }).show();
            return false;
        }
        return true;
    }

    private void reduceProgress() {
        Preference preference = Preference.getInstance((Context)this);
        JSONObject jsonObject = new JSONObject();
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            jsonObject.put("reason", (Object)this.reasonText.getText().toString());
            jsonObject.put("progress", (Object)(this.perccentageSeekbar.getProgress() + ""));
            jsonObject.put("cname", (Object)preference.getCompanyName());
            jsonObject.put("mail", (Object)preference.getEmailId());
            jsonObject.put("type", (Object)preference.getCompnayType());
            if (preference.isAdmin()) {
                jsonObject.put("role", (Object)preference.getDesignation());
            } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
                jsonObject.put("role", (Object)"project");
            } else {
                jsonObject.put("role", (Object)"employee");
            }
            jsonObject.put("id", (Object)this.projectId);
            JSONObject employee = Database.getInstance((Context)this).getWorkingPerson(this.projectId);
            jsonObject.put("assignId", (Object)employee.getString("assign_id"));
            jsonObject.put("employee", (Object)employee.getString("employee_id"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/task_reduceprogress.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)ReduceProgressActivity.this.getApplicationContext(), (CharSequence)"Progress Reduced Successfully", (int)0).show();
                        ReduceProgressActivity.this.finish();
                    } else {
                        Toast.makeText((Context)ReduceProgressActivity.this.getApplicationContext(), (CharSequence)"Unable to Reduced Progress ", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

