/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class RquestUpdateActivity
extends AppCompatActivity {
    EditText requestResponse;
    String status;
    JSONObject jsonObject;
    LinearLayout linearLayout;
    TextView alertText;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492999);
        this.requestResponse = (EditText)this.findViewById(2131297265);
        this.status = this.getIntent().getStringExtra("status");
        this.linearLayout = (LinearLayout)this.findViewById(2131296958);
        this.alertText = (TextView)this.findViewById(2131296375);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)this.getIntent().getStringExtra("title"));
        try {
            this.jsonObject = new JSONObject(this.getIntent().getStringExtra("json"));
            this.addViews();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void addViews() throws JSONException {
        this.addView("Project Deadline", this.jsonObject.getString("p_end_date"));
        this.addView("Milestone Deadline", this.jsonObject.getString("m_enddate"));
        this.addView("Current Deadline", this.jsonObject.getString("t_end_date"));
        this.addView("Requested Deadline", this.jsonObject.getString("newd"));
        this.addView("Previous Requests", this.jsonObject.getString("counts"));
        if (this.status.equalsIgnoreCase("accepted")) {
            if (this.jsonObject.getBoolean("afterp") && this.jsonObject.getBoolean("afterm")) {
                this.alertText.setText((CharSequence)("Project and Milestone deadline will be extended to " + this.jsonObject.getString("newd")));
            } else if (this.jsonObject.getBoolean("afterm")) {
                this.alertText.setText((CharSequence)("Milestone deadline will be extended to " + this.jsonObject.getString("newd")));
            } else if (this.jsonObject.getBoolean("afterp")) {
                this.alertText.setText((CharSequence)("Project deadline will be extended to " + this.jsonObject.getString("newd")));
            } else {
                this.alertText.setVisibility(8);
            }
        } else {
            this.alertText.setVisibility(8);
        }
    }

    private void updateRequest() throws ParseException, JSONException {
        if (this.requestResponse.getText().toString().isEmpty()) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Please provide response", (int)0).show();
            return;
        }
        Preference preference = Preference.getInstance((Context)this);
        Date date = DateUtils.fromDate(this.jsonObject.getString("t_end_date"));
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, this.jsonObject.getInt("increasedays"));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("enddate", this.jsonObject.getString("newd"));
        params.put("status", this.status);
        params.put("tid", this.jsonObject.getString("task_id"));
        params.put("id", this.jsonObject.getString("id"));
        params.put("milestone", this.jsonObject.getString("t_milestone_id"));
        params.put("project", this.jsonObject.getString("project_id"));
        params.put("mail", preference.getEmailId());
        params.put("type", preference.getCompnayType());
        params.put("response", this.requestResponse.getText().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/request_update.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)RquestUpdateActivity.this.getApplicationContext(), (CharSequence)"Request Updated Successfully", (int)0).show();
                        RquestUpdateActivity.this.finish();
                    } else {
                        Toast.makeText((Context)RquestUpdateActivity.this.getApplicationContext(), (CharSequence)"Unable to update Request", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                try {
                    this.updateRequest();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void addView(String key, String pair) {
        View view = this.getLayoutInflater().inflate(2131493227, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        TextView pairText = (TextView)view.findViewById(2131297136);
        keyText.setText((CharSequence)key);
        pairText.setText((CharSequence)pair);
        this.linearLayout.addView(view);
    }
}

