/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddClientActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.management.ClientInfoActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.SelectCompanyAdapter;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ClientTable;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SelectCompanyActivity
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    JSONArray jsonArray;
    boolean showInfo;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493008);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.showInfo = this.getIntent().getBooleanExtra("info", false);
        if (this.showInfo) {
            this.getSupportActionBar().setTitle((CharSequence)"Clients");
        } else {
            this.getSupportActionBar().setTitle((CharSequence)"Select Company");
        }
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    protected void onResume() {
        super.onResume();
        this.getCompanies();
    }

    private void getCompanies() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("list", new JSONArray().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_clients.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    SelectCompanyActivity.this.getCompanies(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getCompanies(JSONObject jsonObject) throws JSONException {
        this.jsonArray = jsonObject.getJSONArray("clients");
        try {
            Database.getInstance((Context)this).insertClients(this.jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SelectCompanyAdapter selectCategoryAdapter = new SelectCompanyAdapter((Context)this, this.jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)selectCategoryAdapter);
    }

    @Override
    public void itemClicked(int position) {
        if (this.showInfo) {
            Intent intent = new Intent(this.getApplicationContext(), ClientInfoActivity.class);
            try {
                JSONObject jsonObject = this.jsonArray.getJSONObject(position);
                intent.putExtra("id", jsonObject.getString(ClientTable.COMPANYID));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.startActivity(intent);
        } else {
            Intent intent = new Intent();
            try {
                JSONObject jsonObject = this.jsonArray.getJSONObject(position);
                intent.putExtra("id", jsonObject.getString(ClientTable.COMPANYID));
                intent.putExtra("name", jsonObject.getString(ClientTable.COMPANYNAME));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.setResult(-1, intent);
            this.finish();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558401, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296352: {
                this.startActivity(new Intent(this.getApplicationContext(), AddClientActivity.class));
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

