/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddMilestoneActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.SelectMilestoneAdapter;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SelectMilestoneActivity
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    JSONArray jsonArray;
    String projectid;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493010);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.recyclerView.setNestedScrollingEnabled(true);
        this.projectid = this.getIntent().getStringExtra("id");
        this.getSupportActionBar().setTitle((CharSequence)"Select Milestone");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.findViewById(2131296353).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent(SelectMilestoneActivity.this.getApplicationContext(), AddMilestoneActivity.class);
                intent.putExtra("id", SelectMilestoneActivity.this.projectid);
                SelectMilestoneActivity.this.startActivity(intent);
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.getMilestones();
    }

    private void getMilestones() {
        Preference preference = Preference.getInstance((Context)this);
        Database database = Database.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        String emailid = preference.getEmailId();
        params.put("mail", emailid);
        params.put("id", this.projectid);
        if (emailid.equalsIgnoreCase(database.getProjectResponsible(this.projectid))) {
            params.put("responsible", "yes");
        } else {
            params.put("responsible", "no");
        }
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("list", new JSONArray().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_milestones.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    SelectMilestoneActivity.this.getMilestones(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getMilestones(JSONObject jsonObject) throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONArray jsonArray = jsonObject.getJSONArray("list");
        try {
            database.insertMilestones(jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getMilestonesOffline();
    }

    private void getMilestonesOffline() {
        this.jsonArray = Database.getInstance((Context)this).getMilestones(this.projectid);
        SelectMilestoneAdapter selectMilestoneAdapter = new SelectMilestoneAdapter((Context)this, this.jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)selectMilestoneAdapter);
    }

    @Override
    public void itemClicked(int position) {
        Intent intent = new Intent();
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            intent.putExtra("id", jsonObject.getString(MilestoneTable.MILESTONEID));
            intent.putExtra("name", jsonObject.getString(MilestoneTable.NAME));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.setResult(-1, intent);
        this.finish();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

