/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddTagActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.management.TagInfoActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.SelectTagAdapter;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TagTable;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SelectTagActivity
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    JSONArray jsonArray;
    boolean showInfo;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493012);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.showInfo = this.getIntent().getBooleanExtra("info", false);
        if (this.showInfo) {
            this.getSupportActionBar().setTitle((CharSequence)"Tags");
        } else {
            this.getSupportActionBar().setTitle((CharSequence)"Select Tag");
        }
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    protected void onResume() {
        super.onResume();
        this.getTags();
    }

    private void getTags() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("list", new JSONArray().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_tags.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    SelectTagActivity.this.getTags(new JSONObject(response));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTags(JSONObject jsonObject) throws Exception {
        this.jsonArray = jsonObject.getJSONArray("tags");
        Database.getInstance((Context)this).insertTags(this.jsonArray);
        SelectTagAdapter selectTagAdapter = new SelectTagAdapter((Context)this, this.jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)selectTagAdapter);
    }

    @Override
    public void itemClicked(int position) {
        if (!this.showInfo) {
            Intent intent = new Intent();
            try {
                JSONObject jsonObject = this.jsonArray.getJSONObject(position);
                intent.putExtra("id", jsonObject.getString(TagTable.TAGID));
                intent.putExtra("name", jsonObject.getString(TagTable.TAGNAME));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.setResult(-1, intent);
            this.finish();
        } else {
            Intent intent = new Intent(this.getApplicationContext(), TagInfoActivity.class);
            try {
                JSONObject jsonObject = this.jsonArray.getJSONObject(position);
                intent.putExtra("id", jsonObject.getString(TagTable.TAGID));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.startActivity(intent);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558401, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296352: {
                this.startActivity(new Intent(this.getApplicationContext(), AddTagActivity.class));
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

