/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddTaskListActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.SelectTasklistAdapter;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SelectTasklistActivity
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    JSONArray jsonArray;
    String projectid;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493006);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.projectid = this.getIntent().getStringExtra("id");
        this.getSupportActionBar().setTitle((CharSequence)"Select Tasklist");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.findViewById(2131296354).setVisibility(8);
    }

    protected void onResume() {
        super.onResume();
        this.getTasklists();
    }

    private void getTasklists() {
        Preference preference = Preference.getInstance((Context)this);
        Database database = Database.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        String emailid = preference.getEmailId();
        params.put("mail", emailid);
        params.put("id", this.projectid);
        if (emailid.equalsIgnoreCase(database.getProjectResponsible(this.projectid))) {
            params.put("responsible", "yes");
        } else {
            params.put("responsible", "no");
        }
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("list", new JSONArray().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_tasklists.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    SelectTasklistActivity.this.getTasklists(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTasklists(JSONObject jsonObject) throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONArray jsonArray = jsonObject.getJSONArray("list");
        try {
            database.insertTaskLists(jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getTasklistsOffline();
    }

    private void getTasklistsOffline() {
        this.jsonArray = Database.getInstance((Context)this).getTaskLists(this.projectid);
        SelectTasklistAdapter selectTasklistAdapter = new SelectTasklistAdapter((Context)this, this.jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)selectTasklistAdapter);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558430, menu2);
        return true;
    }

    @Override
    public void itemClicked(int position) {
        Intent intent = new Intent();
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            intent.putExtra("id", jsonObject.getString(TasklistTable.TASKLISTID));
            intent.putExtra("name", jsonObject.getString(TasklistTable.NAME));
            intent.putExtra("milestone", jsonObject.getString(TasklistTable.MILESTONEID));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.setResult(-1, intent);
        this.finish();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
            case 2131297086: {
                Intent intent = new Intent(this.getApplicationContext(), AddTaskListActivity.class);
                intent.putExtra("id", this.projectid);
                this.startActivity(intent);
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

