/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.forms;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.adapters.SelectEmployeeAdapter;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskAssignActivity
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    JSONArray jsonArray;
    String taskId;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493009);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.taskId = this.getIntent().getStringExtra("id");
        this.getSupportActionBar().setTitle((CharSequence)"Assign Task");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getEmployees();
    }

    private void getEmployees() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("list", new JSONArray().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_employees.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    TaskAssignActivity.this.getEmployees(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getEmployees(JSONObject jsonObject) throws JSONException {
        this.jsonArray = jsonObject.getJSONArray("employees");
        SelectEmployeeAdapter selectEmployeeAdapter = new SelectEmployeeAdapter((Context)this, this.jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)selectEmployeeAdapter);
    }

    @Override
    public void itemClicked(final int position) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setPositiveButton((CharSequence)"CONFIRM", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                try {
                    TaskAssignActivity.this.assignTask(TaskAssignActivity.this.jsonArray.getJSONObject(position).getString("emailid"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
        builder.setNegativeButton((CharSequence)"CLOSE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        });
        try {
            builder.setMessage((CharSequence)("Assign Task to " + this.jsonArray.getJSONObject(position).getString("employeename")));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    private void assignTask(String employeeid) {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("taskId", (Object)this.taskId);
            jsonObject.put("assignedTo", (Object)employeeid);
            jsonObject.put("cname", (Object)preference.getCompanyName());
            jsonObject.put("mail", (Object)preference.getEmailId());
            jsonObject.put("type", (Object)preference.getCompnayType());
            jsonObject.put("role", (Object)preference.getDesignation());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/task_assign.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)TaskAssignActivity.this.getApplicationContext(), (CharSequence)"Task Assigned Successfully", (int)0).show();
                        TaskAssignActivity.this.finish();
                    } else {
                        Toast.makeText((Context)TaskAssignActivity.this.getApplicationContext(), (CharSequence)"Unable to Assign Task ", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

