/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.management;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddCategoryActivity;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.CategoryTable;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CategoryInfoActivity
extends AppCompatActivity {
    LinearLayout catDetails;
    String id;
    MenuItem edit;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492923);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Category Details");
        this.catDetails = (LinearLayout)this.findViewById(2131296497);
        this.id = this.getIntent().getStringExtra("id");
    }

    protected void onResume() {
        super.onResume();
        this.getCategory();
    }

    private void getCategory() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("list", new JSONArray().toString());
        params.put("tagid", this.id);
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_categories.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    CategoryInfoActivity.this.getCategory(new JSONObject(response));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getCategory(JSONObject jsonObject) throws Exception {
        JSONArray jsonArray = jsonObject.getJSONArray("categories");
        Database.getInstance((Context)this).insertCategories(jsonArray);
        this.addCategoryDetails();
    }

    private void addCategoryDetails() throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONObject jsonObject = database.getCategoryDetails(this.id);
        this.catDetails.removeAllViews();
        this.addView("Name", jsonObject.getString(CategoryTable.CATNAME));
        this.addView("Description", jsonObject.getString(CategoryTable.CATDESCRIPTION));
        this.addView("Created On", jsonObject.getString(CategoryTable.CREATEDDATETIME));
        if (!database.getEmployeeName(jsonObject.getString(CategoryTable.CREATEDBY)).isEmpty()) {
            this.addView("Created By", database.getEmployeeName(jsonObject.getString(CategoryTable.CREATEDBY)));
        }
    }

    private void addView(String key, String pair) {
        View view = this.getLayoutInflater().inflate(2131493227, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        TextView pairText = (TextView)view.findViewById(2131297136);
        keyText.setText((CharSequence)key);
        pairText.setText((CharSequence)pair);
        this.catDetails.addView(view);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558408, menu2);
        this.edit = menu2.findItem(2131296707);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
            case 2131296707: {
                try {
                    Intent intent = new Intent((Context)this, AddCategoryActivity.class);
                    intent.putExtra("id", this.id);
                    this.startActivity(intent);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

