/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities.management;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddClientActivity;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ClientTable;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClientInfoActivity
extends AppCompatActivity {
    LinearLayout clientDetails;
    String id;
    MenuItem edit;
    private String NDA = "no data available";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492926);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Client Details");
        this.clientDetails = (LinearLayout)this.findViewById(2131296535);
        this.id = this.getIntent().getStringExtra("id");
    }

    protected void onResume() {
        super.onResume();
        this.getClients();
    }

    private void getClients() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("cname", preference.getCompanyName());
        params.put("list", new JSONArray().toString());
        params.put("id", this.id);
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_clients.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    ClientInfoActivity.this.getClients(new JSONObject(response));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getClients(JSONObject jsonObject) throws Exception {
        JSONArray jsonArray = jsonObject.getJSONArray("clients");
        Database.getInstance((Context)this).insertClients(jsonArray);
        this.addClientDetails();
    }

    private void addClientDetails() throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONObject jsonObject = database.getClientDetails(this.id);
        this.clientDetails.removeAllViews();
        this.addView("Compnay Name", jsonObject.getString(ClientTable.COMPANYNAME));
        this.addView("Compnay Address", jsonObject.getString(ClientTable.ADDRESS));
        this.addView("Compnay Mobile", jsonObject.getString(ClientTable.CMOBILE));
        this.addView("Compnay Phone", jsonObject.getString(ClientTable.CPHONE));
        this.addView("Compnay Email", jsonObject.getString(ClientTable.CEMAIL));
        this.addView("Web Address", jsonObject.getString(ClientTable.WEBADDRESS));
        if (!jsonObject.getString(ClientTable.RESPONSIBLEPERSON).isEmpty() && !jsonObject.getString(ClientTable.RESPONSIBLEPERSON).equalsIgnoreCase(this.NDA)) {
            this.addView("Responsible Person", jsonObject.getString(ClientTable.RESPONSIBLEPERSON));
        }
        if (!jsonObject.getString(ClientTable.RESPONSIBLEMAIL).isEmpty() && !jsonObject.getString(ClientTable.RESPONSIBLEMAIL).equalsIgnoreCase(this.NDA)) {
            this.addView("Responsible Person Email", jsonObject.getString(ClientTable.RESPONSIBLEMAIL));
        }
        if (!jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE).isEmpty() && !jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE).equalsIgnoreCase(this.NDA)) {
            this.addView("Responsible Person Mobile", jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE));
        }
        this.addView("Created On", jsonObject.getString(ClientTable.CREATEDDATETIME));
        if (!database.getEmployeeName(jsonObject.getString(ClientTable.CREATEDBY)).isEmpty()) {
            this.addView("Created By", database.getEmployeeName(jsonObject.getString(ClientTable.CREATEDBY)));
        }
    }

    private void addView(String key, String pair) {
        View view = this.getLayoutInflater().inflate(2131493227, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        TextView pairText = (TextView)view.findViewById(2131297136);
        keyText.setText((CharSequence)key);
        pairText.setText((CharSequence)pair);
        this.clientDetails.addView(view);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558408, menu2);
        this.edit = menu2.findItem(2131296707);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
            case 2131296707: {
                try {
                    Intent intent = new Intent((Context)this, AddClientActivity.class);
                    intent.putExtra("id", this.id);
                    this.startActivity(intent);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

