/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ActivitiesAdapter
extends RecyclerView.Adapter<viewHolder> {
    Context context;
    JSONArray jsonArray;
    private Database database;
    OnItemClickListener onItemClickListener;
    private final String NDA = "no data available";
    private final String bullot = "\u2022";

    public ActivitiesAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.database = Database.getInstance(context);
        this.onItemClickListener = (OnItemClickListener)context;
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(holder2.getAdapterPosition());
            holder2.text1.setText((CharSequence)jsonObject.getString("act_description"));
            holder2.text2.setText((CharSequence)this.database.getEmployeeName(jsonObject.getString("created_by")));
            if (jsonObject.getString("created_by").equalsIgnoreCase("no data available")) {
                holder2.text3.setText((CharSequence)String.format("%s", jsonObject.getString("act_datetime")));
            } else {
                holder2.text3.setText((CharSequence)String.format("%s %s %s", this.database.getEmployeeName(jsonObject.getString("created_by")), "\u2022", jsonObject.getString("act_datetime")));
            }
            if (holder2.getAdapterPosition() == 0 || !jsonObject.getString("act_date").equalsIgnoreCase(this.jsonArray.getJSONObject(holder2.getAdapterPosition() - 1).getString("act_date"))) {
                holder2.date.setText((CharSequence)jsonObject.getString("act_date"));
            } else {
                holder2.date.setVisibility(8);
            }
            String status = jsonObject.getString("act_p_status");
            if (status.equalsIgnoreCase("assigned")) {
                holder2.iconImage.setImageResource(2131231056);
            } else if (status.equalsIgnoreCase("unassigned")) {
                holder2.iconImage.setImageResource(2131231057);
            } else if (status.equalsIgnoreCase("add")) {
                holder2.iconImage.setImageResource(2131231022);
            } else if (status.equalsIgnoreCase("edit")) {
                holder2.iconImage.setImageResource(2131231044);
            } else if (status.equalsIgnoreCase("progress")) {
                holder2.iconImage.setImageResource(2131230983);
            } else if (status.equalsIgnoreCase("completed")) {
                holder2.iconImage.setImageResource(2131231043);
            } else if (status.equalsIgnoreCase("stopped")) {
                holder2.iconImage.setImageResource(2131231047);
            } else if (status.equalsIgnoreCase("stalled")) {
                holder2.iconImage.setImageResource(2131230959);
            } else if (status.equalsIgnoreCase("begin")) {
                holder2.iconImage.setImageResource(2131230959);
            } else if (status.equalsIgnoreCase("underprogress")) {
                holder2.iconImage.setImageResource(2131230959);
            } else if (status.equalsIgnoreCase("date")) {
                holder2.iconImage.setImageResource(2131230950);
            } else if (status.equalsIgnoreCase("delete")) {
                holder2.iconImage.setImageResource(2131230965);
            }
            if (!jsonObject.getString("task_id").equalsIgnoreCase("no data available")) {
                holder2.text2.setText((CharSequence)Html.fromHtml((String)("Task: <b>" + jsonObject.getString("task_name") + "</b>")));
            } else if (!jsonObject.getString("tasklist_id").equalsIgnoreCase("no data available")) {
                holder2.text2.setText((CharSequence)Html.fromHtml((String)("Tasklist: <b>" + jsonObject.getString("listtask_name") + "</b>")));
            } else if (!jsonObject.getString("milestone_id").equalsIgnoreCase("no data available")) {
                holder2.text2.setText((CharSequence)Html.fromHtml((String)("Milestone: <b>" + jsonObject.getString("milestone_name") + "</b>")));
            } else if (!jsonObject.getString("project_id").equalsIgnoreCase("no data available")) {
                holder2.text2.setText((CharSequence)Html.fromHtml((String)("Project: <b>" + jsonObject.getString("project_name") + "</b>")));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493207, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView text1;
        TextView text2;
        TextView text3;
        TextView date;
        CardView cardView;
        ImageView iconImage;

        public viewHolder(View itemView) {
            super(itemView);
            this.text1 = (TextView)itemView.findViewById(2131297494);
            this.text2 = (TextView)itemView.findViewById(2131297495);
            this.cardView = (CardView)itemView.findViewById(2131296481);
            this.text3 = (TextView)itemView.findViewById(2131297496);
            this.date = (TextView)itemView.findViewById(2131296630);
            this.iconImage = (ImageView)itemView.findViewById(2131296836);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ActivitiesAdapter.this.onItemClickListener.itemClicked(viewHolder.this.getAdapterPosition());
                }
            });
            this.setIsRecyclable(false);
        }
    }
}

