/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.activities.RejectForm;
import com.b2lmobitech.fieldcloudplus.task.activities.TaskInfoActivity;
import com.b2lmobitech.fieldcloudplus.task.listener.AcceptTaskListener;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AllTasksAdapter
extends RecyclerView.Adapter<viewHolder> {
    Context context;
    JSONArray jsonArray;
    private String currentList;
    private AcceptTaskListener acceptTaskListener;
    private String emailid;
    private boolean isResponsible;

    public AllTasksAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
    }

    public AllTasksAdapter(Context context, JSONArray jsonArray, String currentList, boolean isResponsible) {
        this.context = context;
        if (currentList.equalsIgnoreCase("new")) {
            this.acceptTaskListener = (AcceptTaskListener)context;
        }
        this.jsonArray = jsonArray;
        this.currentList = currentList;
        this.emailid = Preference.getInstance(context).getEmailId();
        this.isResponsible = isResponsible;
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493206, parent, false);
        return new viewHolder(itemView);
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            holder2.taskname.setText((CharSequence)jsonObject.getString("task_name"));
            holder2.progress.setText((CharSequence)jsonObject.getString("t_progress"));
            holder2.circularProgressbar.setProgress(jsonObject.getInt("t_progress"));
            final String taskId = jsonObject.getString("task_id");
            final String assignId = jsonObject.getString("assign_id");
            if (this.currentList.equalsIgnoreCase("today") || this.currentList.equalsIgnoreCase("late") || this.currentList.equalsIgnoreCase("active")) {
                holder2.progresslayout.setVisibility(0);
                holder2.arLayout.setVisibility(8);
                String date = jsonObject.getString("t_end_date");
                if (this.currentList.equalsIgnoreCase("late")) {
                    holder2.remaining_days.setText((CharSequence)DateUtils.getLateDateString(date));
                } else if (this.currentList.equalsIgnoreCase("today") || this.currentList.equalsIgnoreCase("active")) {
                    holder2.remaining_days.setText((CharSequence)DateUtils.getDueDateString(date));
                }
            } else if (this.currentList.equalsIgnoreCase("new")) {
                holder2.progresslayout.setVisibility(8);
                if (jsonObject.getString("employee_id").equalsIgnoreCase(this.emailid) || this.isResponsible) {
                    holder2.arLayout.setVisibility(0);
                    holder2.accept.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            ((AcceptTaskListener)AllTasksAdapter.this.context).acceptTask(assignId);
                        }
                    });
                    holder2.reject.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            Intent intent = new Intent(AllTasksAdapter.this.context, RejectForm.class);
                            intent.putExtra("request", "reject");
                            intent.putExtra("id", assignId);
                            AllTasksAdapter.this.context.startActivity(intent);
                        }
                    });
                } else {
                    holder2.arLayout.setVisibility(8);
                }
                holder2.remaining_days.setText((CharSequence)String.format("%s to %s", jsonObject.getString("t_start_date"), jsonObject.getString("t_end_date")));
            } else if (this.currentList.equalsIgnoreCase("completed") || this.currentList.equalsIgnoreCase("upcoming")) {
                holder2.progresslayout.setVisibility(8);
                holder2.arLayout.setVisibility(8);
                if (this.currentList.equalsIgnoreCase("upcoming")) {
                    holder2.remaining_days.setText((CharSequence)DateUtils.getUpcomingDateString(jsonObject.getString("t_start_date")));
                } else if (this.currentList.equalsIgnoreCase("completed")) {
                    holder2.remaining_days.setText((CharSequence)DateUtils.getCompletedDateString(jsonObject.getString("completed_datetime")));
                }
            }
            holder2.cardView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent(AllTasksAdapter.this.context, TaskInfoActivity.class);
                    intent.putExtra("id", taskId);
                    AllTasksAdapter.this.context.startActivity(intent);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView taskname;
        TextView progress;
        TextView remaining_days;
        ProgressBar circularProgressbar;
        CardView cardView;
        LinearLayout arLayout;
        RelativeLayout progresslayout;
        Button accept;
        Button reject;

        public viewHolder(View itemView) {
            super(itemView);
            this.taskname = (TextView)itemView.findViewById(2131297476);
            this.progress = (TextView)itemView.findViewById(2131297195);
            this.remaining_days = (TextView)itemView.findViewById(2131296700);
            this.cardView = (CardView)itemView.findViewById(2131296481);
            this.circularProgressbar = (ProgressBar)itemView.findViewById(2131296528);
            this.arLayout = (LinearLayout)itemView.findViewById(2131296396);
            this.accept = (Button)itemView.findViewById(2131297471);
            this.reject = (Button)itemView.findViewById(2131297479);
            this.progresslayout = (RelativeLayout)itemView.findViewById(2131297196);
        }
    }
}

