/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.EmployeeTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ListAdapter
extends RecyclerView.Adapter<viewHolder> {
    Context context;
    JSONArray jsonArray;
    private Database database;
    OnItemClickListener onItemClickListener;

    public ListAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.database = Database.getInstance(context);
        this.onItemClickListener = (OnItemClickListener)context;
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            holder2.taskListName.setText((CharSequence)jsonObject.getString(TasklistTable.NAME));
            holder2.responsiblePerson.setText((CharSequence)jsonObject.getString(EmployeeTable.NAME));
            if (holder2.getAdapterPosition() == 0 || !jsonObject.getString(TasklistTable.MILESTONEID).equalsIgnoreCase(this.jsonArray.getJSONObject(position - 1).getString(TasklistTable.MILESTONEID))) {
                holder2.milestoneName.setText((CharSequence)this.database.getMilestoneName(jsonObject.getString(TasklistTable.MILESTONEID)));
            } else {
                holder2.milestoneName.setVisibility(8);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493218, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView taskListName;
        TextView responsiblePerson;
        TextView late;
        TextView milestoneName;
        CardView cardView;

        public viewHolder(View itemView) {
            super(itemView);
            this.taskListName = (TextView)itemView.findViewById(2131297468);
            this.responsiblePerson = (TextView)itemView.findViewById(2131297273);
            this.cardView = (CardView)itemView.findViewById(2131296481);
            this.milestoneName = (TextView)itemView.findViewById(2131297012);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ListAdapter.this.onItemClickListener.itemClicked(viewHolder.this.getAdapterPosition());
                }
            });
        }
    }
}

