/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.activities.MilestoneInfoActivity;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.EmployeeTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import java.text.ParseException;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MilestoneAdapter
extends RecyclerView.Adapter<viewHolder> {
    Context context;
    private JSONArray jsonArray;
    Database database;

    public MilestoneAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.database = Database.getInstance(context);
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            holder2.milestoneName.setText((CharSequence)jsonObject.getString(MilestoneTable.NAME));
            holder2.responsiblePerson.setText((CharSequence)jsonObject.getString(EmployeeTable.NAME));
            holder2.monthName.setText((CharSequence)DateUtils.monthNameFromDate(jsonObject.getString(MilestoneTable.ENDDATE)));
            holder2.date.setText((CharSequence)DateUtils.dateNumberFromDate(jsonObject.getString(MilestoneTable.ENDDATE)));
            int daysbetween = DateUtils.compareToday(jsonObject.getString(MilestoneTable.ENDDATE));
            final String id2 = jsonObject.getString(MilestoneTable.MILESTONEID);
            final String projectId = jsonObject.getString(MilestoneTable.PROJECTID);
            if (daysbetween == 0) {
                holder2.dueDays.setText(2131820751);
            } else if (daysbetween < 0) {
                if ((daysbetween *= -1) == 1) {
                    holder2.dueDays.setText((CharSequence)String.format(this.context.getString(2131820620), daysbetween));
                } else {
                    holder2.dueDays.setText((CharSequence)String.format(this.context.getString(2131820621), daysbetween));
                }
            } else if (daysbetween == 1) {
                holder2.dueDays.setText(2131820752);
            } else {
                holder2.dueDays.setText((CharSequence)String.format(this.context.getString(2131820622), daysbetween));
            }
            if (this.database.isMilestoneCompleted(jsonObject.getString(MilestoneTable.MILESTONEID))) {
                holder2.monthName.setBackgroundColor(this.context.getResources().getColor(2131099804));
            } else {
                holder2.monthName.setBackgroundColor(this.context.getResources().getColor(2131099805));
            }
            holder2.cardView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ArrayList arrayList = new ArrayList();
                    Intent intent = new Intent(MilestoneAdapter.this.context, MilestoneInfoActivity.class);
                    intent.putExtra("id", id2);
                    intent.putExtra("projectId", projectId);
                    MilestoneAdapter.this.context.startActivity(intent);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493211, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView milestoneName;
        TextView responsiblePerson;
        TextView dueDays;
        TextView monthName;
        TextView date;
        CardView cardView;

        public viewHolder(View itemView) {
            super(itemView);
            this.milestoneName = (TextView)itemView.findViewById(2131297012);
            this.responsiblePerson = (TextView)itemView.findViewById(2131297273);
            this.dueDays = (TextView)itemView.findViewById(2131296699);
            this.cardView = (CardView)itemView.findViewById(2131296481);
            this.monthName = (TextView)itemView.findViewById(2131297025);
            this.date = (TextView)itemView.findViewById(2131296630);
        }
    }
}

