/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.bumptech.glide.Glide;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProgressListAdapter
extends RecyclerView.Adapter<viewHolder> {
    Context context;
    private JSONArray jsonArray;
    private Preference preference;
    private Database database;

    public ProgressListAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.preference = Preference.getInstance(context);
        this.database = Database.getInstance(context);
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493213, parent, false);
        return new viewHolder(itemView);
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            holder2.progressLog.setText((CharSequence)String.format("%s%%", jsonObject.getString("progress")));
            holder2.datelog.setText((CharSequence)jsonObject.getString("progress_date"));
            holder2.completedLog.setText((CharSequence)jsonObject.getString("completed_activities").replace("@#", ","));
            if (jsonObject.getString("progress_by_type").equalsIgnoreCase("user")) {
                if (jsonObject.getString("employee_id").equalsIgnoreCase(this.preference.getEmailId())) {
                    holder2.bylog.setText((CharSequence)this.context.getString(2131820713));
                } else {
                    holder2.bylog.setText((CharSequence)this.database.getEmployeeName(jsonObject.getString("employee_id")));
                }
            } else if (jsonObject.getString("progress_by").equalsIgnoreCase(this.preference.getEmailId())) {
                holder2.bylog.setText((CharSequence)this.context.getString(2131820713));
            } else {
                holder2.bylog.setText((CharSequence)this.database.getEmployeeName(jsonObject.getString("progress_by")));
            }
            if (!jsonObject.getString("progressImage").equalsIgnoreCase("no data available")) {
                Glide.with((Context)this.context).load("http://fieldcloud.in/Eversendai/App/Progressimages/" + jsonObject.getString("progressImage")).into(holder2.imageView);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView progressLog;
        TextView completedLog;
        TextView datelog;
        TextView bylog;
        private LinearLayout hiddenLayout;
        private LinearLayout visibleLayout;
        ImageView imageView;
        ImageView indicatiorImage;

        public viewHolder(View itemView) {
            super(itemView);
            this.progressLog = (TextView)itemView.findViewById(2131297156);
            this.completedLog = (TextView)itemView.findViewById(2131296346);
            this.hiddenLayout = (LinearLayout)itemView.findViewById(2131296750);
            this.datelog = (TextView)itemView.findViewById(2131296633);
            this.bylog = (TextView)itemView.findViewById(2131296465);
            this.visibleLayout = (LinearLayout)itemView.findViewById(2131297716);
            this.imageView = (ImageView)itemView.findViewById(2131296843);
            this.indicatiorImage = (ImageView)itemView.findViewById(2131296883);
            this.visibleLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (viewHolder.this.hiddenLayout.getVisibility() == 0) {
                        viewHolder.this.indicatiorImage.setImageDrawable(ProgressListAdapter.this.context.getResources().getDrawable(2131230987));
                        viewHolder.this.hiddenLayout.setVisibility(8);
                    } else {
                        viewHolder.this.indicatiorImage.setImageDrawable(ProgressListAdapter.this.context.getResources().getDrawable(2131230990));
                        viewHolder.this.hiddenLayout.setVisibility(0);
                    }
                }
            });
        }
    }
}

