/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.task.listener.OnTaskActionSelected;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RequestListAdapter
extends RecyclerView.Adapter<viewHolder> {
    Context context;
    JSONArray jsonArray;
    private OnTaskActionSelected onTaskActionSelected;
    private boolean isResponsible;

    public RequestListAdapter(Context context, JSONArray jsonArray, boolean isResponsible) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.onTaskActionSelected = (OnTaskActionSelected)context;
        this.isResponsible = isResponsible;
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493215, parent, false);
        return new viewHolder(itemView);
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(holder2.getAdapterPosition());
            holder2.taskname.setText((CharSequence)jsonObject.getString("task_name"));
            if (jsonObject.getString("increasedays").equalsIgnoreCase("1")) {
                holder2.thirdText.setText((CharSequence)String.format("%s day", jsonObject.getString("increasedays")));
            } else {
                holder2.thirdText.setText((CharSequence)String.format("%s days", jsonObject.getString("increasedays")));
            }
            if (jsonObject.getInt("counts") == 0) {
                holder2.secondText.setText((CharSequence)jsonObject.getString("employeename"));
            } else if (jsonObject.getInt("counts") == 1) {
                holder2.secondText.setText((CharSequence)(jsonObject.getString("employeename") + " \u2022 " + jsonObject.getInt("counts") + " Previous Request"));
            } else {
                holder2.secondText.setText((CharSequence)(jsonObject.getString("employeename") + " \u2022 " + jsonObject.getInt("counts") + " Previous Requests"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView taskname;
        TextView secondText;
        TextView thirdText;
        CardView cardView;
        LinearLayout buttonLayout;
        ImageView button1;
        ImageView button2;

        public viewHolder(View itemView) {
            super(itemView);
            this.taskname = (TextView)itemView.findViewById(2131297476);
            this.secondText = (TextView)itemView.findViewById(2131297316);
            this.thirdText = (TextView)itemView.findViewById(2131297547);
            this.cardView = (CardView)itemView.findViewById(2131296481);
            this.buttonLayout = (LinearLayout)itemView.findViewById(2131296460);
            this.button1 = (ImageView)itemView.findViewById(2131296458);
            this.button2 = (ImageView)itemView.findViewById(2131296459);
            if (RequestListAdapter.this.isResponsible) {
                this.buttonLayout.setVisibility(0);
                this.secondText.setVisibility(0);
            } else {
                this.secondText.setVisibility(8);
                this.buttonLayout.setVisibility(8);
            }
            this.button1.setImageResource(2131230806);
            this.button2.setImageResource(2131230865);
            this.button1.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RequestListAdapter.this.onTaskActionSelected.taskSelected(viewHolder.this.getAdapterPosition(), "accepted");
                }
            });
            this.button2.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RequestListAdapter.this.onTaskActionSelected.taskSelected(viewHolder.this.getAdapterPosition(), "rejected");
                }
            });
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    RequestListAdapter.this.onTaskActionSelected.taskSelected(viewHolder.this.getAdapterPosition(), "details");
                }
            });
        }
    }
}

