/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;
import com.b2lmobitech.fieldcloudplus.task.old.CompletedDetails;
import com.b2lmobitech.fieldcloudplus.task.old.TaskDetails;
import com.b2lmobitech.fieldcloudplus.task.old.TaskNew;
import java.util.ArrayList;

public class SearchResultAdapter
extends RecyclerView.Adapter<viewHolder> {
    Context context;
    ArrayList<TaskEncap> arrayList;

    public SearchResultAdapter(Context context, ArrayList<TaskEncap> arrayList) {
        this.context = context;
        this.arrayList = arrayList;
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493206, parent, false);
        return new viewHolder(itemView);
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        final TaskEncap taskEncap = this.arrayList.get(position);
        holder2.taskname.setText((CharSequence)taskEncap.getTaskname());
        holder2.progress.setText((CharSequence)taskEncap.getProgress());
        holder2.circularProgressbar.setProgress(taskEncap.getI_progress());
        if (taskEncap.getCategory() == TaskEnum.ACTIVE || taskEncap.getCategory() == TaskEnum.LATE || taskEncap.getCategory() == TaskEnum.UPCOMING) {
            holder2.cardView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Intent intent = new Intent(SearchResultAdapter.this.context, TaskDetails.class);
                    intent.putExtra("taskid", taskEncap.getTaskid());
                    SearchResultAdapter.this.context.startActivity(intent);
                }
            });
            holder2.remaining_days.setText((CharSequence)(taskEncap.getStartdate() + " to " + taskEncap.getEnddatte()));
        } else if (taskEncap.getCategory() == TaskEnum.COMPLETED) {
            holder2.relativeLayout.setVisibility(8);
            holder2.remaining_days.setText((CharSequence)("Completed on " + Utility.getDateTime(taskEncap.getD_enddatte())));
            holder2.cardView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Intent intent = new Intent(SearchResultAdapter.this.context, CompletedDetails.class);
                    intent.putExtra("taskid", taskEncap.getTaskid());
                    SearchResultAdapter.this.context.startActivity(intent);
                }
            });
        } else if (taskEncap.getCategory() == TaskEnum.NEW) {
            holder2.relativeLayout.setVisibility(8);
            holder2.remaining_days.setText((CharSequence)"New task");
            holder2.remaining_days.setText((CharSequence)("Starting on " + taskEncap.getStartdate()));
            holder2.cardView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Intent intent = new Intent(SearchResultAdapter.this.context, TaskNew.class);
                    intent.putExtra("taskid", taskEncap.getTaskid());
                    SearchResultAdapter.this.context.startActivity(intent);
                }
            });
        }
    }

    public int getItemCount() {
        return this.arrayList.size();
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView taskname;
        TextView progress;
        TextView remaining_days;
        RelativeLayout relativeLayout;
        CardView cardView;
        ProgressBar circularProgressbar;

        public viewHolder(View itemView) {
            super(itemView);
            this.taskname = (TextView)itemView.findViewById(2131297476);
            this.progress = (TextView)itemView.findViewById(2131297195);
            this.relativeLayout = (RelativeLayout)itemView.findViewById(2131297196);
            this.circularProgressbar = (ProgressBar)itemView.findViewById(2131296528);
        }
    }
}

