/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.adapters;

import android.content.Context;
import android.content.Intent;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.activities.TaskInfoActivity;
import com.b2lmobitech.fieldcloudplus.task.listener.OnTaskActionSelected;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TasksManagementAdapter
extends RecyclerView.Adapter<viewHolder> {
    Context context;
    JSONArray jsonArray;
    private String currentList;
    private Database database;
    private OnTaskActionSelected onTaskActionSelected;
    String bullot = "\u2022";

    public TasksManagementAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
    }

    public TasksManagementAdapter(Context context, JSONArray jsonArray, String currentList) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.database = Database.getInstance(context);
        this.currentList = currentList;
        this.onTaskActionSelected = (OnTaskActionSelected)context;
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493210, parent, false);
        return new viewHolder(itemView);
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            holder2.taskname.setText((CharSequence)jsonObject.getString("task_name"));
            final String taskId = jsonObject.getString("task_id");
            if (this.currentList.equalsIgnoreCase("unassigned")) {
                String date = jsonObject.getString("t_end_date");
                holder2.secondText.setText((CharSequence)String.format("%s to %s", jsonObject.getString("t_start_date"), jsonObject.getString("t_end_date")));
            } else if (this.currentList.equalsIgnoreCase("assigned")) {
                holder2.buttonLayout.setVisibility(0);
                if (jsonObject.getString("a_status").equalsIgnoreCase("accepted")) {
                    holder2.button1.setVisibility(8);
                    holder2.secondText.setText((CharSequence)String.format("%s \u2022 Accepted", this.database.getEmployeeName(jsonObject.getString("employee_id"))));
                } else if (jsonObject.getString("a_status").equalsIgnoreCase("declined")) {
                    holder2.button1.setVisibility(0);
                    holder2.button2.setVisibility(0);
                    holder2.secondText.setText((CharSequence)Html.fromHtml((String)(" <font color='#ff0000'>Declined</font> \u2022 " + this.database.getEmployeeName(jsonObject.getString("employee_id")))));
                } else {
                    holder2.secondText.setText((CharSequence)String.format("%s \u2022 Yet To Accept", this.database.getEmployeeName(jsonObject.getString("employee_id"))));
                }
            } else if (this.currentList.equalsIgnoreCase("completed")) {
                if (jsonObject.getString("t_status").equalsIgnoreCase("underprogress")) {
                    holder2.buttonLayout.setVisibility(0);
                    holder2.secondText.setText((CharSequence)String.format("%s", this.database.getEmployeeName(jsonObject.getString("employee_id"))));
                } else {
                    holder2.buttonLayout.setVisibility(8);
                    holder2.secondText.setText((CharSequence)String.format("%s \u2022 %s", this.database.getEmployeeName(jsonObject.getString("employee_id")), DateUtils.getCompletedDateString(jsonObject.getString("completed_datetime"))));
                }
            } else if (this.currentList.equalsIgnoreCase("stalled")) {
                holder2.secondText.setText((CharSequence)String.format("Stalled On %s", jsonObject.getString("stalled_datetime")));
            } else if (this.currentList.equalsIgnoreCase("stopped")) {
                holder2.secondText.setText((CharSequence)String.format("Stopped On %s", jsonObject.getString("stoppeddatetime")));
            }
            holder2.cardView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent(TasksManagementAdapter.this.context, TaskInfoActivity.class);
                    intent.putExtra("id", taskId);
                    TasksManagementAdapter.this.context.startActivity(intent);
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView taskname;
        TextView secondText;
        CardView cardView;
        LinearLayout buttonLayout;
        ImageView button1;
        ImageView button2;

        public viewHolder(View itemView) {
            super(itemView);
            this.taskname = (TextView)itemView.findViewById(2131297476);
            this.secondText = (TextView)itemView.findViewById(2131297316);
            this.cardView = (CardView)itemView.findViewById(2131296481);
            this.buttonLayout = (LinearLayout)itemView.findViewById(2131296460);
            this.button1 = (ImageView)itemView.findViewById(2131296458);
            this.button2 = (ImageView)itemView.findViewById(2131296459);
            if (TasksManagementAdapter.this.currentList.equalsIgnoreCase("unassigned")) {
                this.button1.setImageResource(2131231056);
                this.button1.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        TasksManagementAdapter.this.onTaskActionSelected.taskSelected(viewHolder.this.getAdapterPosition(), "assign");
                    }
                });
            } else if (TasksManagementAdapter.this.currentList.equalsIgnoreCase("completed")) {
                this.button1.setImageResource(2131231045);
                this.button2.setImageResource(2131231044);
                this.button1.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        TasksManagementAdapter.this.onTaskActionSelected.taskSelected(viewHolder.this.getAdapterPosition(), "complete");
                    }
                });
                this.button2.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        TasksManagementAdapter.this.onTaskActionSelected.taskSelected(viewHolder.this.getAdapterPosition(), "modify");
                    }
                });
            } else if (TasksManagementAdapter.this.currentList.equalsIgnoreCase("assigned")) {
                this.button1.setImageResource(2131231056);
                this.button2.setImageResource(2131231057);
                this.button1.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        TasksManagementAdapter.this.onTaskActionSelected.taskSelected(viewHolder.this.getAdapterPosition(), "reassign");
                    }
                });
                this.button2.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        TasksManagementAdapter.this.onTaskActionSelected.taskSelected(viewHolder.this.getAdapterPosition(), "unassign");
                    }
                });
            }
        }
    }
}

