/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.encap;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskEncap
implements Parcelable,
Comparable<TaskEncap> {
    private String taskid;
    private String taskname;
    private String projctid;
    private String assignid;
    private String projectname;
    private String projectstartdate;
    private String projectenddate;
    private String projectdescription;
    private String milestoneid;
    private String milestonename;
    private String milestoneenddate;
    private String milestonedescription;
    private String listtaskid;
    private String listtaskname;
    private String description;
    private String due_days;
    private String status;
    private String priotity;
    private String sequence;
    private String online_sync;
    private String local_sync;
    private String progress;
    private int i_progress;
    private String startdate;
    private String enddatte;
    private String updateddatetime;
    private String assigneddatetime;
    private String underprogressdatetime;
    private Date d_startdate;
    private Date d_enddatte;
    private Date d_updateddatetime;
    private Date d_assigneddatetime;
    private Date u_datetime;
    private boolean fav;
    private String assign_status;
    private String email_id;
    private TaskEnum category;
    public static final Parcelable.Creator<TaskEncap> CREATOR = new Parcelable.Creator<TaskEncap>(){

        public TaskEncap createFromParcel(Parcel in) {
            return new TaskEncap(in);
        }

        public TaskEncap[] newArray(int size) {
            return new TaskEncap[size];
        }
    };
    public static final Comparator<TaskEncap> AgeComparator = new Comparator<TaskEncap>(){

        @Override
        public int compare(TaskEncap o1, TaskEncap o2) {
            Log.e((String)"sort", (String)o1.getTaskname());
            if (o1.getD_enddatte().before(o2.getD_enddatte())) {
                Log.e((String)"sort", (String)"-1");
                return -1;
            }
            if (o1.getD_enddatte().after(o2.getD_enddatte())) {
                Log.e((String)"sort", (String)"-1");
                return 1;
            }
            Log.e((String)"sort", (String)"-1");
            return 0;
        }
    };

    public TaskEncap(JSONObject jsonObject) throws JSONException, ParseException {
        this.taskid = jsonObject.getString("task_id");
        this.taskname = jsonObject.getString("task_name");
        this.assignid = jsonObject.getString("assignid");
        this.projctid = jsonObject.getString("project_id");
        this.milestoneid = jsonObject.getString("milestone_id");
        this.listtaskid = jsonObject.getString("listtask_id");
        this.assigneddatetime = jsonObject.getString("a_datetime");
        this.description = jsonObject.getString("description");
        this.due_days = jsonObject.getString("task_id");
        this.status = jsonObject.getString("status");
        this.priotity = jsonObject.getString("priority");
        this.startdate = jsonObject.getString("startdate");
        this.enddatte = jsonObject.getString("enddate");
        this.updateddatetime = jsonObject.getString("updatetime");
        this.sequence = jsonObject.getString("sequence");
        this.online_sync = jsonObject.getString("sync");
        this.progress = jsonObject.getString("progress");
        this.i_progress = jsonObject.getInt("progress");
        this.underprogressdatetime = jsonObject.getString("under");
        this.d_startdate = Utility.getDateTime(jsonObject.getString("startdate"));
        this.d_enddatte = Utility.getDateTime(jsonObject.getString("enddate"));
        this.d_updateddatetime = Utility.getDateTime(jsonObject.getString("updatetime"));
        this.d_assigneddatetime = Utility.getDateTime(jsonObject.getString("a_datetime"));
        this.email_id = jsonObject.getString("emailid");
        this.assign_status = jsonObject.getString("assign_status");
        if (this.i_progress == 100) {
            this.category = TaskEnum.COMPLETED;
        } else if (this.assign_status.trim().equalsIgnoreCase("pending")) {
            this.category = TaskEnum.NEW;
        } else if (this.status.equalsIgnoreCase("underprogress") || this.d_startdate.before(new Date())) {
            this.category = this.d_enddatte.before(new Date()) ? TaskEnum.LATE : TaskEnum.ACTIVE;
        } else if (this.status.equalsIgnoreCase("accepted") && this.d_startdate.after(new Date())) {
            this.category = TaskEnum.UPCOMING;
        }
    }

    public TaskEncap() {
    }

    public String getAssign_status() {
        return this.assign_status;
    }

    public void setAssign_status(String assign_status) {
        this.assign_status = assign_status;
    }

    public String getEmail_id() {
        return this.email_id;
    }

    public void setEmail_id(String email_id) {
        this.email_id = email_id;
    }

    public TaskEnum getCategory() {
        return this.category;
    }

    public void setCategory(TaskEnum category) {
        this.category = category;
    }

    public String getProjectstartdate() {
        return this.projectstartdate;
    }

    public void setProjectstartdate(String projectstartdate) {
        this.projectstartdate = projectstartdate;
    }

    public String getUnderprogressdatetime() {
        return this.underprogressdatetime;
    }

    public void setUnderprogressdatetime(String underprogressdatetime) {
        this.underprogressdatetime = underprogressdatetime;
    }

    public String getProjectenddate() {
        return this.projectenddate;
    }

    public void setProjectenddate(String projectenddate) {
        this.projectenddate = projectenddate;
    }

    public String getProjectdescription() {
        return this.projectdescription;
    }

    public void setProjectdescription(String projectdescription) {
        this.projectdescription = projectdescription;
    }

    public String getMilestoneenddate() {
        return this.milestoneenddate;
    }

    public void setMilestoneenddate(String milestoneenddate) {
        this.milestoneenddate = milestoneenddate;
    }

    public String getMilestonedescription() {
        return this.milestonedescription;
    }

    public void setMilestonedescription(String milestonedescription) {
        this.milestonedescription = milestonedescription;
    }

    public String getTaskid() {
        return this.taskid;
    }

    public void setTaskid(String taskid) {
        this.taskid = taskid;
    }

    public String getTaskname() {
        return this.taskname;
    }

    public void setTaskname(String taskname) {
        this.taskname = taskname;
    }

    public String getProjctid() {
        return this.projctid;
    }

    public void setProjctid(String projctid) {
        this.projctid = projctid;
    }

    public String getAssignid() {
        return this.assignid;
    }

    public void setAssignid(String assignid) {
        this.assignid = assignid;
    }

    public String getProjectname() {
        return this.projectname;
    }

    public void setProjectname(String projectname) {
        this.projectname = projectname;
    }

    public String getMilestoneid() {
        return this.milestoneid;
    }

    public void setMilestoneid(String milestoneid) {
        this.milestoneid = milestoneid;
    }

    public String getMilestonename() {
        return this.milestonename;
    }

    public void setMilestonename(String milestonename) {
        this.milestonename = milestonename;
    }

    public String getListtaskid() {
        return this.listtaskid;
    }

    public void setListtaskid(String listtaskid) {
        this.listtaskid = listtaskid;
    }

    public String getListtaskname() {
        return this.listtaskname;
    }

    public void setListtaskname(String listtaskname) {
        this.listtaskname = listtaskname;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDue_days() {
        return this.due_days;
    }

    public void setDue_days(String due_days) {
        this.due_days = due_days;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getPriotity() {
        return this.priotity;
    }

    public void setPriotity(String priotity) {
        this.priotity = priotity;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getOnline_sync() {
        return this.online_sync;
    }

    public void setOnline_sync(String online_sync) {
        this.online_sync = online_sync;
    }

    public String getLocal_sync() {
        return this.local_sync;
    }

    public void setLocal_sync(String local_sync) {
        this.local_sync = local_sync;
    }

    public boolean isFav() {
        return this.fav;
    }

    public void setFav(boolean fav) {
        this.fav = fav;
    }

    public String getProgress() {
        return this.progress;
    }

    public void setProgress(String progress) {
        this.progress = progress;
        this.i_progress = Integer.parseInt(progress);
    }

    public int getI_progress() {
        return this.i_progress;
    }

    public void setI_progress(int i_progress) {
        this.i_progress = i_progress;
        this.progress = String.valueOf(i_progress);
    }

    public String getStartdate() {
        return this.startdate;
    }

    public void setStartdate(String startdate) {
        this.startdate = startdate;
    }

    public String getEnddatte() {
        return this.enddatte;
    }

    public void setEnddatte(String enddatte) {
        this.enddatte = enddatte;
    }

    public String getUpdateddatetime() {
        return this.updateddatetime;
    }

    public void setUpdateddatetime(String updateddatetime) {
        this.updateddatetime = updateddatetime;
    }

    public String getAssigneddatetime() {
        return this.assigneddatetime;
    }

    public void setAssigneddatetime(String assigneddatetime) {
        this.assigneddatetime = assigneddatetime;
    }

    public Date getD_startdate() {
        return this.d_startdate;
    }

    public void setD_startdate(Date d_startdate) {
        this.d_startdate = d_startdate;
    }

    public void setD_enddatte(Date d_enddatte) {
        this.d_enddatte = d_enddatte;
    }

    public void setD_assigneddatetime(Date d_assigneddatetime) {
        this.d_assigneddatetime = d_assigneddatetime;
    }

    public void setD_updateddatetime(Date d_updateddatetime) {
        this.d_updateddatetime = d_updateddatetime;
    }

    public Date getD_assigneddatetime() {
        return this.d_assigneddatetime;
    }

    public Date getD_updateddatetime() {
        return this.d_updateddatetime;
    }

    public Date getD_enddatte() {
        return this.d_enddatte;
    }

    protected TaskEncap(Parcel in) {
        this.taskid = in.readString();
        this.taskname = in.readString();
        this.projctid = in.readString();
        this.assignid = in.readString();
        this.projectname = in.readString();
        this.milestoneid = in.readString();
        this.milestonename = in.readString();
        this.listtaskid = in.readString();
        this.listtaskname = in.readString();
        this.description = in.readString();
        this.due_days = in.readString();
        this.status = in.readString();
        this.priotity = in.readString();
        this.sequence = in.readString();
        this.online_sync = in.readString();
        this.local_sync = in.readString();
        this.fav = in.readByte() != 0;
        this.progress = in.readString();
        this.i_progress = in.readInt();
        this.startdate = in.readString();
        this.enddatte = in.readString();
        this.updateddatetime = in.readString();
        this.assigneddatetime = in.readString();
        this.projectstartdate = in.readString();
        this.projectenddate = in.readString();
        this.projectdescription = in.readString();
        this.milestoneenddate = in.readString();
        this.milestonedescription = in.readString();
        this.assign_status = in.readString();
        this.email_id = in.readString();
        this.underprogressdatetime = in.readString();
        long tmpD_startdate = in.readLong();
        this.d_startdate = tmpD_startdate != -1L ? new Date(tmpD_startdate) : null;
        long tmpD_enddatte = in.readLong();
        this.d_enddatte = tmpD_enddatte != -1L ? new Date(tmpD_enddatte) : null;
        long tmpD_updateddatetime = in.readLong();
        this.d_updateddatetime = tmpD_updateddatetime != -1L ? new Date(tmpD_updateddatetime) : null;
        long tmpD_assigneddatetime = in.readLong();
        this.d_assigneddatetime = tmpD_assigneddatetime != -1L ? new Date(tmpD_assigneddatetime) : null;
        this.category = (TaskEnum)((Object)in.readValue(TaskEnum.class.getClassLoader()));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.taskid);
        dest.writeString(this.taskname);
        dest.writeString(this.projctid);
        dest.writeString(this.assignid);
        dest.writeString(this.projectname);
        dest.writeString(this.milestoneid);
        dest.writeString(this.milestonename);
        dest.writeString(this.listtaskid);
        dest.writeString(this.listtaskname);
        dest.writeString(this.description);
        dest.writeString(this.due_days);
        dest.writeString(this.status);
        dest.writeString(this.priotity);
        dest.writeString(this.sequence);
        dest.writeString(this.online_sync);
        dest.writeString(this.local_sync);
        dest.writeByte((byte)(this.fav ? 1 : 0));
        dest.writeString(this.progress);
        dest.writeInt(this.i_progress);
        dest.writeString(this.startdate);
        dest.writeString(this.enddatte);
        dest.writeString(this.updateddatetime);
        dest.writeString(this.assigneddatetime);
        dest.writeString(this.projectstartdate);
        dest.writeString(this.projectenddate);
        dest.writeString(this.projectdescription);
        dest.writeString(this.milestoneenddate);
        dest.writeString(this.milestonedescription);
        dest.writeString(this.assign_status);
        dest.writeString(this.email_id);
        dest.writeString(this.underprogressdatetime);
        dest.writeLong(this.d_startdate != null ? this.d_startdate.getTime() : -1L);
        dest.writeLong(this.d_enddatte != null ? this.d_enddatte.getTime() : -1L);
        dest.writeLong(this.d_updateddatetime != null ? this.d_updateddatetime.getTime() : -1L);
        dest.writeLong(this.d_assigneddatetime != null ? this.d_assigneddatetime.getTime() : -1L);
        dest.writeValue((Object)this.category);
    }

    @Override
    public int compareTo(@NonNull TaskEncap o) {
        Log.e((String)"called", (String)"called");
        return this.getD_enddatte().compareTo(o.getD_enddatte());
    }
}

