/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.old;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.LocationManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.RejectForm;
import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.listener.TaskAcceptedListener;
import com.b2lmobitech.fieldcloudplus.task.old.TaskNew;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
import com.google.android.material.snackbar.Snackbar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class NewTasksAdapter
extends RecyclerView.Adapter<ViewHolder> {
    ArrayList<TaskEncap> arrayList;
    Context context;
    ProgressDialog pDialog;
    RequestQueue requestQueue;
    TaskAcceptedListener taskAcceptedListener;
    private Sqlite sqldatabase;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;

    public NewTasksAdapter(Context context, ArrayList<TaskEncap> arrayList, TaskAcceptedListener taskAcceptedListener, CoordinatorLayout coordinatorLayout) {
        this.context = context;
        this.arrayList = arrayList;
        this.taskAcceptedListener = taskAcceptedListener;
        this.sqldatabase = new Sqlite(context);
        this.requestQueue = Volley.newRequestQueue((Context)context);
        this.coordinatorLayout = coordinatorLayout;
    }

    public void onBindViewHolder(ViewHolder holder2, int position) {
        final TaskEncap taskEncap = this.arrayList.get(position);
        holder2.taskname.setText((CharSequence)taskEncap.getTaskname());
        holder2.dates.setText((CharSequence)(taskEncap.getStartdate() + " to " + taskEncap.getEnddatte()));
        final ArrayList<TaskEncap> parcellist = new ArrayList<TaskEncap>();
        parcellist.add(taskEncap);
        holder2.cardView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent(NewTasksAdapter.this.context, TaskNew.class);
                intent.putExtra("taskid", taskEncap.getTaskid());
                NewTasksAdapter.this.context.startActivity(intent);
            }
        });
        holder2.reject.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!Utility.isNetworkAvailable(NewTasksAdapter.this.context)) {
                    NewTasksAdapter.this.snackbar = Snackbar.make((View)NewTasksAdapter.this.coordinatorLayout, (CharSequence)"No Internet Connection", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                        public void onClick(View view) {
                            NewTasksAdapter.this.snackbar.dismiss();
                        }
                    });
                    NewTasksAdapter.this.snackbar.show();
                    return;
                }
                Intent intent = new Intent(NewTasksAdapter.this.context, RejectForm.class);
                intent.putParcelableArrayListExtra("arrayList", parcellist);
                intent.putExtra("request", "reject");
                NewTasksAdapter.this.context.startActivity(intent);
            }
        });
        holder2.accept.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                NewTasksAdapter.this.acceptTask(taskEncap);
            }
        });
    }

    public int getItemCount() {
        return this.arrayList.size();
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493212, parent, false);
        return new ViewHolder(itemView);
    }

    private void acceptTask(final TaskEncap taskEncap) {
        LocationManager locationManager = (LocationManager)this.context.getSystemService("location");
        boolean isGPSEnabled = locationManager.isProviderEnabled("gps");
        boolean isNetworkEnabled = locationManager.isProviderEnabled("network");
        if (!isGPSEnabled && !isNetworkEnabled) {
            AlertDialog.Builder alertdialog = new AlertDialog.Builder(this.context);
            alertdialog.setTitle((CharSequence)"Access Location");
            alertdialog.setIcon(2131230915);
            alertdialog.setMessage((CharSequence)"No network provider is enabled for location access!!");
            alertdialog.setPositiveButton((CharSequence)"Turn On", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    NewTasksAdapter.this.context.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS"));
                }
            });
            alertdialog.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
            alertdialog.show();
            return;
        }
        if (!Utility.isNetworkAvailable(this.context)) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"No Internet Connection", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    NewTasksAdapter.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
            return;
        }
        this.pDialog = new ProgressDialog(this.context);
        this.pDialog.setMessage((CharSequence)"Loading...");
        this.pDialog.setIndeterminate(false);
        this.pDialog.setCancelable(false);
        this.pDialog.show();
        final LatLang latLang = Utility.getLocation(this.context);
        StringRequest postRequest2 = new StringRequest(1, "http://fieldcloud.in/App/accept_task.php", (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                Log.d((String)"Response", (String)response);
                try {
                    JSONObject json = new JSONObject(response);
                    int success = json.getInt("success");
                    if (success == 1) {
                        NewTasksAdapter.this.sqldatabase.updateTaskAccepted(taskEncap.getTaskid());
                        NewTasksAdapter.this.taskAcceptedListener.taskAccepted();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                NewTasksAdapter.this.pDialog.dismiss();
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                NewTasksAdapter.this.pDialog.dismiss();
                Log.d((String)"Error.Response", (String)error.toString());
            }
        }){

            protected Map<String, String> getParams() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("assign_id", taskEncap.getAssignid());
                params.put("datetime", Utility.getCurrentDateTime());
                params.put("latitude", latLang.getLatitude());
                params.put("longtitude", latLang.getLongitude());
                return params;
            }
        };
        this.requestQueue.add((Request)postRequest2);
    }

    private void showAlertDialog() {
        if (!Utility.isNetworkAvailable(this.context)) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"No Internet Connection", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    NewTasksAdapter.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
            return;
        }
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView dates;
        TextView taskname;
        Button accept;
        Button reject;
        CardView cardView;

        public ViewHolder(View itemView) {
            super(itemView);
            this.dates = (TextView)itemView.findViewById(2131297472);
            this.taskname = (TextView)itemView.findViewById(2131297476);
            this.accept = (Button)itemView.findViewById(2131297471);
            this.reject = (Button)itemView.findViewById(2131297479);
            this.cardView = (CardView)itemView.findViewById(2131297088);
        }
    }
}

