/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.old;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.task.encap.ProjectsEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;
import com.b2lmobitech.fieldcloudplus.task.old.TaskList;
import java.util.ArrayList;

public class ProjectListAdapter
extends RecyclerView.Adapter<viewHolder> {
    ArrayList<ProjectsEncap> projectsList;
    ArrayList<TaskEncap> taskList;
    Context context;
    SharedPreferences sp;
    String emailid;

    public ProjectListAdapter(Context context, ArrayList<ProjectsEncap> projectsList, ArrayList<TaskEncap> taskList) {
        this.context = context;
        this.projectsList = projectsList;
        this.taskList = taskList;
        this.sp = context.getSharedPreferences("projectid", 0);
        this.emailid = context.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0).getString(globalvariables.logout_emailid, "");
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        final ProjectsEncap projectsEncap = this.projectsList.get(position);
        holder2.project_name.setText((CharSequence)projectsEncap.getProject_name());
        holder2.dates.setText((CharSequence)(projectsEncap.getStart_date() + " to " + projectsEncap.getEnd_date()));
        int late = 0;
        boolean active = false;
        for (TaskEncap taskEncap : this.taskList) {
            if (!taskEncap.getEmail_id().equalsIgnoreCase(this.emailid) || !taskEncap.getProjectname().equalsIgnoreCase(projectsEncap.getProject_name()) || !taskEncap.getCategory().equals((Object)TaskEnum.LATE)) continue;
            ++late;
        }
        if (late > 0) {
            holder2.late.setText((CharSequence)(late + " late"));
        } else {
            holder2.late.setVisibility(8);
        }
        holder2.cardView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ArrayList<TaskEncap> arrayList = new ArrayList<TaskEncap>();
                for (TaskEncap taskEncap : ProjectListAdapter.this.taskList) {
                    if (!taskEncap.getProjectname().equalsIgnoreCase(projectsEncap.getProject_name())) continue;
                    arrayList.add(taskEncap);
                }
                Intent intent = new Intent(ProjectListAdapter.this.context, TaskList.class);
                ProjectListAdapter.this.context.getSharedPreferences("projectid", 0).edit().putString("projectid", projectsEncap.getProjectid()).apply();
                ProjectListAdapter.this.context.startActivity(intent);
            }
        });
    }

    public int getItemCount() {
        return this.projectsList.size();
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493214, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView project_name;
        TextView dates;
        TextView late;
        CardView cardView;

        public viewHolder(View itemView) {
            super(itemView);
            this.project_name = (TextView)itemView.findViewById(2131297202);
            this.dates = (TextView)itemView.findViewById(2131296640);
            this.cardView = (CardView)itemView.findViewById(2131296478);
            this.late = (TextView)itemView.findViewById(2131296920);
        }
    }
}

