/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.old;

import android.app.DatePickerDialog;
import android.app.NotificationManager;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.RadioButton;
import android.widget.Spinner;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SearchView;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.Requests;
import com.b2lmobitech.fieldcloudplus.task.activities.SearchResult;
import com.b2lmobitech.fieldcloudplus.task.adapters.SearchResultAdapter;
import com.b2lmobitech.fieldcloudplus.task.encap.RequestEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;
import com.b2lmobitech.fieldcloudplus.task.listener.TaskAcceptedListener;
import com.b2lmobitech.fieldcloudplus.task.old.CompletedListAdapterr;
import com.b2lmobitech.fieldcloudplus.task.old.LateListAdapter;
import com.b2lmobitech.fieldcloudplus.task.old.NewTasksAdapter;
import com.b2lmobitech.fieldcloudplus.task.old.TaskListAdapter;
import com.b2lmobitech.fieldcloudplus.task.old.UpcomingListAdapter;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
import com.google.android.material.snackbar.Snackbar;
import com.google.android.material.tabs.TabLayout;
import com.google.android.material.textfield.TextInputLayout;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Task
extends AppCompatActivity {
    TabLayout tabLayout;
    ArrayList<TaskEncap> taskList = new ArrayList();
    ArrayList<TaskEncap> activetasks = new ArrayList();
    ArrayList<TaskEncap> latetasks = new ArrayList();
    ArrayList<TaskEncap> completedtasks = new ArrayList();
    ArrayList<TaskEncap> newtasks = new ArrayList();
    ArrayList<TaskEncap> upcoming_task = new ArrayList();
    ArrayList<RequestEncap> arrayList = new ArrayList();
    ArrayList<TaskEncap> todayList = new ArrayList();
    RecyclerView recyclerView;
    String registeredcompany;
    String registeredemailid;
    NewTasksAdapter newTasksAdapter;
    TaskListAdapter taskListAdapter;
    TaskListAdapter todayListAdapter;
    UpcomingListAdapter upcomingListAdapter;
    CompletedListAdapterr completedListAdapterr;
    SearchResultAdapter searchlistAdapter;
    LateListAdapter lateListAdapter;
    ProgressDialog pDialog;
    RequestQueue requestQueue;
    SwipeRefreshLayout swipeRefreshLayout;
    private Sqlite sqldatabase;
    private String projectid;
    private static final int BACK_PASSNG = 0;
    Snackbar snackbar;
    Snackbar nosnackbar;
    CoordinatorLayout coordinatorLayout;
    boolean notFirstRun = false;
    SearchView searchView;
    RecyclerView searchRecycle;
    ArrayList<TaskEncap> searchlist = new ArrayList();
    MenuItem filter;
    boolean menucreated = false;
    Calendar myCalendar;
    Calendar myCalendar1;
    Date selected1;
    Date selected2;
    String searchType;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493025);
        this.getSupportActionBar().setTitle((CharSequence)"Tasks");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.tabLayout = (TabLayout)this.findViewById(2131297446);
        this.sqldatabase = new Sqlite((Context)this);
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Today"), true);
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Active"));
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Late"));
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"New"));
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Upcoming"));
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Completed"));
        this.requestQueue = Volley.newRequestQueue((Context)this);
        this.searchRecycle = (RecyclerView)this.findViewById(2131297313);
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296592);
        this.recyclerView = (RecyclerView)this.findViewById(2131297478);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.setHasFixedSize(true);
        this.searchRecycle.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.searchRecycle.setHasFixedSize(true);
        this.newTasksAdapter = new NewTasksAdapter((Context)this, this.newtasks, new TaskAcceptedListener(){

            @Override
            public void taskAccepted() {
                try {
                    Task.this.getTasksOffline();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }, this.coordinatorLayout);
        this.upcomingListAdapter = new UpcomingListAdapter((Context)this, this.upcoming_task);
        this.completedListAdapterr = new CompletedListAdapterr((Context)this, this.completedtasks);
        this.lateListAdapter = new LateListAdapter((Context)this, this.latetasks);
        this.taskListAdapter = new TaskListAdapter((Context)this, this.activetasks);
        this.searchlistAdapter = new SearchResultAdapter((Context)this, this.searchlist);
        this.todayListAdapter = new TaskListAdapter((Context)this, this.todayList);
        this.searchRecycle.setAdapter((RecyclerView.Adapter)this.searchlistAdapter);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.todayListAdapter);
        this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(2131297443);
        this.setListeners();
        this.projectid = this.getSharedPreferences("projectid", 0).getString("tasklistid", null);
        this.getRequestsOnline();
        globalvariables.Logoutsharedpreference = this.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        this.registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        this.registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
    }

    private void setListeners() {
        this.nosnackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"No Tasks found", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

            public void onClick(View view) {
                Task.this.nosnackbar.dismiss();
            }
        });
        this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                if (!Utility.isNetworkAvailable((Context)Task.this)) {
                    Task.this.snackbar = Snackbar.make((View)Task.this.coordinatorLayout, (CharSequence)"No Internet Connection", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                        public void onClick(View view) {
                            Task.this.snackbar.dismiss();
                        }
                    });
                    Task.this.snackbar.show();
                    Task.this.swipeRefreshLayout.setRefreshing(false);
                    return;
                }
                Task.this.getTasksOnline();
            }
        });
        this.tabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                Task.this.refreshData();
                boolean tabEmpty = false;
                if (tab.getPosition() == 0) {
                    Task.this.recyclerView.setAdapter((RecyclerView.Adapter)Task.this.todayListAdapter);
                    if (Task.this.todayList.isEmpty()) {
                        tabEmpty = true;
                    }
                } else if (tab.getPosition() == 1) {
                    Task.this.recyclerView.setAdapter((RecyclerView.Adapter)Task.this.taskListAdapter);
                    if (Task.this.activetasks.isEmpty()) {
                        tabEmpty = true;
                    }
                } else if (tab.getPosition() == 2) {
                    Task.this.recyclerView.setAdapter((RecyclerView.Adapter)Task.this.lateListAdapter);
                    if (Task.this.latetasks.isEmpty()) {
                        tabEmpty = true;
                    }
                } else if (tab.getPosition() == 3) {
                    if (Task.this.newtasks.isEmpty()) {
                        tabEmpty = true;
                    }
                    Task.this.recyclerView.setAdapter((RecyclerView.Adapter)Task.this.newTasksAdapter);
                } else if (tab.getPosition() == 4) {
                    Task.this.recyclerView.setAdapter((RecyclerView.Adapter)Task.this.upcomingListAdapter);
                    if (Task.this.upcoming_task.isEmpty()) {
                        tabEmpty = true;
                    }
                } else if (tab.getPosition() == 5) {
                    Task.this.recyclerView.setAdapter((RecyclerView.Adapter)Task.this.completedListAdapterr);
                    if (Task.this.completedtasks.isEmpty()) {
                        tabEmpty = true;
                    }
                }
                if (tabEmpty) {
                    Task.this.nosnackbar.show();
                } else {
                    Task.this.nosnackbar.dismiss();
                }
            }

            public void onTabUnselected(TabLayout.Tab tab) {
            }

            public void onTabReselected(TabLayout.Tab tab) {
            }
        });
        this.tabLayout.getTabAt(0).select();
    }

    private void getTasksOnline() {
        this.swipeRefreshLayout.setRefreshing(true);
        StringRequest postRequest2 = new StringRequest(1, "http://fieldcloud.in/App/get_tasks.php", (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                Log.d((String)"Response", (String)response);
                try {
                    JSONObject json = new JSONObject(response);
                    int success = json.getInt("success");
                    if (success == 1) {
                        JSONObject jsonObject;
                        int i;
                        JSONArray jsonArray = json.getJSONArray("tasks");
                        JSONArray projectArray = json.getJSONArray("project");
                        JSONArray milestoneArray = json.getJSONArray("milestone");
                        JSONArray listtaskArray = json.getJSONArray("listtask");
                        JSONArray progresslsitArray = json.getJSONArray("progresslist");
                        for (i = 0; i < jsonArray.length(); ++i) {
                            jsonObject = jsonArray.getJSONObject(i);
                            TaskEncap taskEncap = new TaskEncap(jsonObject);
                            Task.this.sqldatabase.insert_task(taskEncap);
                        }
                        for (i = 0; i < milestoneArray.length(); ++i) {
                            jsonObject = milestoneArray.getJSONObject(i);
                            Task.this.sqldatabase.updateMilestoneDatails(jsonObject);
                        }
                        for (i = 0; i < listtaskArray.length(); ++i) {
                            jsonObject = listtaskArray.getJSONObject(i);
                            Task.this.sqldatabase.updateListtask(jsonObject);
                        }
                        for (i = 0; i < projectArray.length(); ++i) {
                            jsonObject = projectArray.getJSONObject(i);
                            Task.this.sqldatabase.updateProjectDetails(jsonObject);
                        }
                        for (i = 0; i < progresslsitArray.length(); ++i) {
                            jsonObject = progresslsitArray.getJSONObject(i);
                            Task.this.sqldatabase.insertTaskProgress(jsonObject);
                        }
                        Task.this.getTasksOffline();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Task.this.swipeRefreshLayout.setRefreshing(false);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.d((String)"Error.Response", (String)error.toString());
            }
        }){

            protected Map<String, String> getParams() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("mail", Task.this.registeredemailid);
                return params;
            }
        };
        this.requestQueue.add((Request)postRequest2);
    }

    protected void onResume() {
        super.onResume();
        this.projectid = this.getSharedPreferences("projectid", 0).getString("tasklistid", null);
        try {
            this.getTasksOffline();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ((NotificationManager)this.getSystemService("notification")).cancelAll();
        this.searchlist.clear();
    }

    private void setUncompletedTasks() {
    }

    private void getTasksOffline() throws ParseException {
        this.taskList.clear();
        Log.e((String)"listtask", (String)this.projectid);
        JSONArray jsonArray = Database.getInstance((Context)this).getAssignedTasks(this.projectid);
        this.taskList = this.sqldatabase.get_tasks_bylsit(this.projectid, this.registeredemailid.toLowerCase());
        this.tabLayout.setSmoothScrollingEnabled(true);
        this.refreshData();
        int delaytime = 10;
        if (!this.notFirstRun) {
            this.notFirstRun = true;
            if (!this.latetasks.isEmpty()) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Task.this.tabLayout.getTabAt(2).select();
                    }
                }, (long)delaytime);
            } else if (!this.todayList.isEmpty()) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Task.this.tabLayout.getTabAt(0).select();
                    }
                }, (long)delaytime);
            } else if (!this.activetasks.isEmpty()) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Task.this.tabLayout.getTabAt(1).select();
                    }
                }, (long)delaytime);
            } else if (!this.upcoming_task.isEmpty()) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Task.this.tabLayout.getTabAt(4).select();
                    }
                }, (long)delaytime);
            } else if (!this.newtasks.isEmpty()) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Task.this.tabLayout.getTabAt(3).select();
                    }
                }, (long)delaytime);
            } else if (!this.completedtasks.isEmpty()) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Task.this.tabLayout.getTabAt(5).select();
                    }
                }, (long)delaytime);
            }
        }
    }

    private void refreshData() {
        this.activetasks.clear();
        this.latetasks.clear();
        this.completedtasks.clear();
        this.newtasks.clear();
        this.upcoming_task.clear();
        this.todayList.clear();
        this.searchlist.clear();
        JSONArray jsonArray = Database.getInstance((Context)this).getAssignedTasks(this.projectid);
        for (TaskEncap taskEncap : this.taskList) {
            int dayend;
            switch (taskEncap.getCategory()) {
                case NEW: {
                    this.newtasks.add(taskEncap);
                    break;
                }
                case LATE: {
                    this.latetasks.add(taskEncap);
                    break;
                }
                case ACTIVE: {
                    this.activetasks.add(taskEncap);
                    break;
                }
                case UPCOMING: {
                    this.upcoming_task.add(taskEncap);
                    break;
                }
                case COMPLETED: {
                    this.completedtasks.add(taskEncap);
                }
            }
            if ((dayend = Utility.daysbetween(taskEncap.getD_enddatte())) != 0 || taskEncap.getCategory().equals((Object)TaskEnum.NEW) || taskEncap.getCategory().equals((Object)TaskEnum.COMPLETED)) continue;
            this.todayList.add(taskEncap);
        }
        Collections.sort(this.activetasks);
        Collections.sort(this.latetasks, new Comparator<TaskEncap>(){

            @Override
            public int compare(TaskEncap o1, TaskEncap o2) {
                if (o1.getD_enddatte().before(o2.getD_enddatte())) {
                    return -1;
                }
                if (o1.getD_enddatte().after(o2.getD_enddatte())) {
                    return 1;
                }
                return 0;
            }
        });
        this.newTasksAdapter.notifyDataSetChanged();
        this.taskListAdapter.notifyDataSetChanged();
        this.upcomingListAdapter.notifyDataSetChanged();
        this.completedListAdapterr.notifyDataSetChanged();
        this.lateListAdapter.notifyDataSetChanged();
        this.todayListAdapter.notifyDataSetChanged();
    }

    private void startTask(final TaskEncap taskEncap) {
        this.pDialog = new ProgressDialog((Context)this);
        this.pDialog.setMessage((CharSequence)"Starting Task...");
        this.pDialog.setIndeterminate(false);
        this.pDialog.setCancelable(false);
        this.pDialog.show();
        StringRequest postRequest2 = new StringRequest(1, "http://fieldcloud.in/App/start_task.php", (Response.Listener)new Response.Listener<String>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onResponse(String response) {
                Log.d((String)"Response", (String)response);
                try {
                    JSONObject json = new JSONObject(response);
                    int success = json.getInt("success");
                    if (success != 1) {
                        // empty if block
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Task.this.pDialog.dismiss();
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Task.this.pDialog.dismiss();
                Log.d((String)"Error.Response", (String)error.toString());
            }
        }){

            protected Map<String, String> getParams() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("assign_id", taskEncap.getAssignid());
                params.put("task_id", taskEncap.getTaskid());
                params.put("datetime", Utility.getCurrentDateTime());
                return params;
            }
        };
        this.requestQueue.add((Request)postRequest2);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558426, menu2);
        this.menucreated = true;
        this.filter = menu2.findItem(2131296770);
        this.filter.setVisible(false);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131297270: {
                Intent intent = new Intent((Context)this, Requests.class);
                intent.putExtra("projectid", this.projectid);
                this.startActivity(intent);
                break;
            }
            case 2131297112: {
                break;
            }
            case 16908332: {
                this.finish();
                break;
            }
            case 2131296770: {
                this.showFilterDialog();
                break;
            }
            case 2131297304: {
                this.showSearchAlertDialouge();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 0: {
                if (resultCode != -1) break;
                Log.e((String)"chekck", (String)"Notification called");
                this.projectid = data.getStringExtra("projectid");
                Log.e((String)"chekck", (String)this.projectid);
                try {
                    this.getTasksOffline();
                    break;
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    private void getRequestsOnline() {
        StringRequest postRequest2 = new StringRequest(1, "http://fieldcloud.in/App/requestUpdates.php", (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                Log.d((String)"Response", (String)response);
                try {
                    JSONObject json = new JSONObject(response);
                    int success = json.getInt("success");
                    if (success == 1) {
                        Task.this.arrayList.clear();
                        JSONArray jsonArray = json.getJSONArray("requests");
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            RequestEncap requestEncap = new RequestEncap();
                            requestEncap.setTaskName(jsonObject.getString("task_name"));
                            requestEncap.setTaskId(jsonObject.getString("task_id"));
                            requestEncap.setAssignid(jsonObject.getString("assign_id"));
                            requestEncap.setEmployeeid(jsonObject.getString("employeeid"));
                            requestEncap.setStatus(jsonObject.getString("status"));
                            requestEncap.setReason(jsonObject.getString("reason"));
                            requestEncap.setRequestdatetime(jsonObject.getString("r_datetime"));
                            requestEncap.setResponse(jsonObject.getString("response"));
                            requestEncap.setIncreasedays(jsonObject.getString("increasedays"));
                            requestEncap.setUpdateddatetime(jsonObject.getString("updatetime"));
                            Task.this.sqldatabase.insertOrUpdateTaskRequest(requestEncap);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.d((String)"Error.Response", (String)error.toString());
            }
        }){

            protected Map<String, String> getParams() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("project_id", Task.this.projectid);
                params.put("email_id", Task.this.registeredemailid);
                return params;
            }
        };
        this.requestQueue.add((Request)postRequest2);
    }

    private void showFilterDialog() {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)this);
        LayoutInflater inflater = this.getLayoutInflater();
        View dialogView = inflater.inflate(2131493067, null);
        dialogBuilder.setView(dialogView);
        final AlertDialog alertDialog = dialogBuilder.create();
        RadioButton radioButton = (RadioButton)dialogView.findViewById(2131297577);
        RadioButton remainingDays = (RadioButton)dialogView.findViewById(2131297253);
        RadioButton enddate = (RadioButton)dialogView.findViewById(2131296733);
        radioButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Task.this.filterActiveToday();
                alertDialog.hide();
            }
        });
        remainingDays.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Task.this.orderByRemaining();
                alertDialog.hide();
            }
        });
        enddate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Task.this.orderByEdnddate();
                alertDialog.hide();
            }
        });
        alertDialog.show();
    }

    private void filterActiveToday() {
        this.activetasks.clear();
        for (TaskEncap taskEncap : this.taskList) {
            int dayend = Utility.daysbetween(taskEncap.getD_enddatte());
            if (dayend != 0) continue;
            this.activetasks.add(taskEncap);
        }
        if (this.activetasks.size() == 0) {
            this.nosnackbar.show();
        }
        this.taskListAdapter.notifyDataSetChanged();
    }

    private void orderByRemaining() {
        this.refreshData();
        Collections.sort(this.activetasks, new Comparator<TaskEncap>(){

            @Override
            public int compare(TaskEncap o1, TaskEncap o2) {
                if (o1.getD_enddatte().before(o2.getD_enddatte())) {
                    return 1;
                }
                if (o1.getD_enddatte().after(o2.getD_enddatte())) {
                    return -1;
                }
                return 0;
            }
        });
        this.taskListAdapter.notifyDataSetChanged();
    }

    private void prepareSearchList() {
        this.searchlist.clear();
        for (TaskEncap taskEncap : this.taskList) {
            if (!taskEncap.getD_startdate().after(this.selected1) || !taskEncap.getD_enddatte().before(this.selected2)) continue;
            this.searchlist.add(taskEncap);
        }
    }

    private void orderByEdnddate() {
        this.refreshData();
        Collections.sort(this.activetasks, new Comparator<TaskEncap>(){

            @Override
            public int compare(TaskEncap o1, TaskEncap o2) {
                if (o1.getD_enddatte().before(o2.getD_enddatte())) {
                    return -1;
                }
                if (o1.getD_enddatte().after(o2.getD_enddatte())) {
                    return 1;
                }
                return 0;
            }
        });
        this.taskListAdapter.notifyDataSetChanged();
    }

    private void showSearchAlertDialouge() {
        this.myCalendar = Calendar.getInstance();
        this.myCalendar1 = Calendar.getInstance();
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)this);
        LayoutInflater inflater = this.getLayoutInflater();
        View dialogView = inflater.inflate(2131493069, null);
        dialogBuilder.setView(dialogView);
        final AlertDialog alertDialog = dialogBuilder.create();
        final TextInputLayout tlFrom = (TextInputLayout)dialogView.findViewById(2131296787);
        final TextInputLayout tlTo = (TextInputLayout)dialogView.findViewById(2131297574);
        Button cancel = (Button)dialogView.findViewById(2131296377);
        Button search = (Button)dialogView.findViewById(2131296379);
        final Spinner alert_spinner = (Spinner)dialogView.findViewById(2131296380);
        alert_spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                tlFrom.getEditText().getText().clear();
                tlTo.getEditText().getText().clear();
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        final DatePickerDialog.OnDateSetListener fromDate = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                Task.this.myCalendar.set(1, year);
                Task.this.myCalendar.set(2, monthOfYear);
                Task.this.myCalendar.set(5, dayOfMonth);
                String myFormat = "dd/MM/yyyy";
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                tlFrom.getEditText().setText((CharSequence)sdf.format(Task.this.myCalendar.getTime()));
                try {
                    Task.this.selected1 = Utility.getDateOnly(Task.this.myCalendar.getTime());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                tlTo.getEditText().getText().clear();
            }
        };
        final DatePickerDialog.OnDateSetListener toDate = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                Task.this.myCalendar1.set(1, year);
                Task.this.myCalendar1.set(2, monthOfYear);
                Task.this.myCalendar1.set(5, dayOfMonth);
                String myFormat = "dd/MM/yyyy";
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                tlTo.getEditText().setText((CharSequence)sdf.format(Task.this.myCalendar1.getTime()));
                try {
                    Task.this.selected2 = Utility.getDateOnly(Task.this.myCalendar1.getTime());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        };
        tlFrom.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (alert_spinner.getSelectedItemPosition() == 0) {
                    Toast.makeText((Context)Task.this.getApplicationContext(), (CharSequence)"Select Type", (int)0).show();
                    return;
                }
                DatePickerDialog datePicker = new DatePickerDialog((Context)Task.this, fromDate, Task.this.myCalendar.get(1), Task.this.myCalendar.get(2), Task.this.myCalendar.get(5));
                if (alert_spinner.getSelectedItemPosition() == 1 || alert_spinner.getSelectedItemPosition() == 2) {
                    datePicker.getDatePicker().setMinDate(Calendar.getInstance().getTimeInMillis());
                } else if (alert_spinner.getSelectedItemPosition() == 3) {
                    datePicker.getDatePicker().setMaxDate(Calendar.getInstance().getTimeInMillis());
                }
                datePicker.show();
            }
        });
        tlTo.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (tlFrom.getEditText().getText().toString().isEmpty()) {
                    Toast.makeText((Context)Task.this.getApplicationContext(), (CharSequence)"Select from Date", (int)0).show();
                    return;
                }
                DatePickerDialog datePicker = new DatePickerDialog((Context)Task.this, toDate, Task.this.myCalendar1.get(1), Task.this.myCalendar1.get(2), Task.this.myCalendar1.get(5));
                if (alert_spinner.getSelectedItemPosition() == 1 || alert_spinner.getSelectedItemPosition() == 2) {
                    datePicker.getDatePicker().setMinDate(Task.this.myCalendar.getTimeInMillis());
                } else if (alert_spinner.getSelectedItemPosition() == 3) {
                    datePicker.getDatePicker().setMinDate(Task.this.myCalendar.getTimeInMillis());
                    datePicker.getDatePicker().setMaxDate(Calendar.getInstance().getTimeInMillis());
                }
                datePicker.show();
            }
        });
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertDialog.hide();
            }
        });
        search.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (tlFrom.getEditText().getText().toString().isEmpty()) {
                    tlFrom.getEditText().setError((CharSequence)"Select Date");
                    return;
                }
                Task.this.searchResult(tlFrom.getEditText().getText().toString(), tlTo.getEditText().getText().toString(), Task.this.selected1, Task.this.selected2, alert_spinner.getSelectedItem().toString(), alertDialog);
            }
        });
        alertDialog.show();
    }

    private void searchResult(String from, String to, Date dfrom, Date dto, String type, AlertDialog alertDialog) {
        try {
            if (type.equalsIgnoreCase("Active")) {
                this.searchlist.clear();
                if (to.isEmpty()) {
                    for (TaskEncap taskEncap : this.taskList) {
                        if (!this.selected1.equals(taskEncap.getD_startdate()) && !this.selected1.equals(taskEncap.getD_enddatte()) && (!this.selected1.after(taskEncap.getD_startdate()) || !this.selected1.before(taskEncap.getD_enddatte()))) continue;
                        this.searchlist.add(taskEncap);
                    }
                } else {
                    for (TaskEncap taskEncap : this.taskList) {
                        if (!this.selected1.equals(taskEncap.getD_startdate()) && !this.selected1.equals(taskEncap.getD_enddatte()) && !this.selected2.equals(taskEncap.getD_startdate()) && !this.selected2.equals(taskEncap.getD_enddatte()) && (!taskEncap.getD_startdate().after(this.selected1) || !taskEncap.getD_startdate().before(this.selected2)) && (!taskEncap.getD_enddatte().after(this.selected1) || !taskEncap.getD_enddatte().before(this.selected2))) continue;
                        this.searchlist.add(taskEncap);
                    }
                }
            } else if (type.equalsIgnoreCase("Completed")) {
                this.searchlist.clear();
                if (to.isEmpty()) {
                    for (TaskEncap taskEncap : this.taskList) {
                        try {
                            if (!this.selected1.equals(Utility.getDateOnly(taskEncap.getD_updateddatetime()))) continue;
                            this.searchlist.add(taskEncap);
                        }
                        catch (ParseException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    for (TaskEncap taskEncap : this.taskList) {
                        if (taskEncap.getI_progress() != 100) continue;
                        try {
                            if (!this.selected1.equals(Utility.getDateOnly(taskEncap.getD_updateddatetime())) && !this.selected2.equals(Utility.getDateOnly(taskEncap.getD_updateddatetime())) && (!Utility.getDateOnly(taskEncap.getD_updateddatetime()).after(this.selected1) || !Utility.getDateOnly(taskEncap.getD_updateddatetime()).before(this.selected2)) && (!Utility.getDateOnly(taskEncap.getD_updateddatetime()).after(this.selected1) || !Utility.getDateOnly(taskEncap.getD_updateddatetime()).before(this.selected2))) continue;
                            this.searchlist.add(taskEncap);
                        }
                        catch (ParseException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            } else if (type.equalsIgnoreCase("Deadline")) {
                if (to.isEmpty()) {
                    for (TaskEncap taskEncap : this.taskList) {
                        if (!this.selected1.equals(taskEncap.getD_enddatte())) continue;
                        this.searchlist.add(taskEncap);
                    }
                } else {
                    for (TaskEncap taskEncap : this.taskList) {
                        if (!this.selected1.equals(taskEncap.getD_enddatte()) && !this.selected2.equals(taskEncap.getD_enddatte()) && (!taskEncap.getD_enddatte().after(this.selected1) || !taskEncap.getD_enddatte().before(this.selected2))) continue;
                        this.searchlist.add(taskEncap);
                    }
                }
            }
            if (this.searchlist.isEmpty()) {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"No tasks found", (int)0).show();
                return;
            }
            Intent intent = new Intent((Context)this, SearchResult.class);
            intent.putExtra("full_list", this.taskList);
            intent.putExtra("search_list", this.searchlist);
            intent.putExtra("title", type);
            intent.putExtra("fromDate", from);
            intent.putExtra("toDate", to);
            this.startActivity(intent);
            alertDialog.hide();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

