/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.old;

import android.app.DatePickerDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.ProgressBar;
import android.widget.Spinner;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.SearchResult;
import com.b2lmobitech.fieldcloudplus.task.encap.RequestEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TasklistEncap;
import com.b2lmobitech.fieldcloudplus.task.old.ListTaskAdapter;
import com.b2lmobitech.fieldcloudplus.task.old.ProjectListAdapter;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
import com.google.android.material.snackbar.Snackbar;
import com.google.android.material.textfield.TextInputLayout;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import org.json.JSONObject;

public class TaskList
extends AppCompatActivity {
    ProgressDialog pDialog;
    RequestQueue requestQueue;
    HashSet<String> hashSet = new HashSet();
    ArrayList<TaskEncap> taskList = new ArrayList();
    ArrayList<TasklistEncap> projectslist = new ArrayList();
    RecyclerView recyclerView;
    ProjectListAdapter projectListAdapter;
    String registeredcompany;
    String registeredemailid;
    private Sqlite sqldatabase;
    ProgressBar progressBar;
    Snackbar snackbar;
    CoordinatorLayout coordinatorLayout;
    ListTaskAdapter listTaskAdapter;
    ArrayList<RequestEncap> arrayList = new ArrayList();
    JSONObject jsonObject;
    String projectid;
    Calendar myCalendar;
    Calendar myCalendar1;
    Date selected1;
    Date selected2;
    ArrayList<TaskEncap> searchlist = new ArrayList();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493030);
        this.requestQueue = Volley.newRequestQueue((Context)this);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.progressBar = (ProgressBar)this.findViewById(2131297189);
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296592);
        this.sqldatabase = new Sqlite((Context)this);
        this.getSupportActionBar().setTitle((CharSequence)"Task List");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.projectid = this.getSharedPreferences("projectid", 0).getString("projectid", null);
        globalvariables.Logoutsharedpreference = this.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        this.registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        this.registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
    }

    protected void onResume() {
        super.onResume();
        this.getTasksOffline();
    }

    private void getTasksOffline() {
        this.taskList.clear();
        this.projectslist.clear();
        try {
            this.taskList = this.sqldatabase.get_tasks_byproject(this.projectid, this.registeredemailid.toLowerCase());
            if (!this.taskList.isEmpty()) {
                for (TaskEncap taskEncap : this.taskList) {
                    this.hashSet.add(taskEncap.getListtaskid());
                }
                for (String id2 : this.hashSet) {
                    TasklistEncap tasklistEncap = new TasklistEncap();
                    Log.e((String)"id", (String)id2);
                    for (TaskEncap taskEncap : this.taskList) {
                        if (!taskEncap.getListtaskid().equals(id2)) continue;
                        tasklistEncap.setTasklsitName(taskEncap.getListtaskname());
                        tasklistEncap.setTasklistID(taskEncap.getListtaskid());
                        tasklistEncap.setMilestoneName(taskEncap.getMilestonename());
                        tasklistEncap.setMilestoneEnddate(taskEncap.getMilestoneenddate());
                    }
                    this.projectslist.add(tasklistEncap);
                }
                this.listTaskAdapter = new ListTaskAdapter((Context)this, this.projectslist, this.taskList);
                this.recyclerView.setAdapter((RecyclerView.Adapter)this.listTaskAdapter);
            } else {
                this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"No projects found", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                    public void onClick(View view) {
                        TaskList.this.snackbar.dismiss();
                    }
                });
                this.snackbar.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558430, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                break;
            }
            case 2131297304: {
                this.showSearchAlertDialouge();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void showSearchAlertDialouge() {
        this.myCalendar = Calendar.getInstance();
        this.myCalendar1 = Calendar.getInstance();
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)this);
        LayoutInflater inflater = this.getLayoutInflater();
        View dialogView = inflater.inflate(2131493069, null);
        dialogBuilder.setView(dialogView);
        final AlertDialog alertDialog = dialogBuilder.create();
        final TextInputLayout tlFrom = (TextInputLayout)dialogView.findViewById(2131296787);
        final TextInputLayout tlTo = (TextInputLayout)dialogView.findViewById(2131297574);
        Button cancel = (Button)dialogView.findViewById(2131296377);
        Button search = (Button)dialogView.findViewById(2131296379);
        final Spinner alert_spinner = (Spinner)dialogView.findViewById(2131296380);
        alert_spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                tlFrom.getEditText().getText().clear();
                tlTo.getEditText().getText().clear();
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        final DatePickerDialog.OnDateSetListener fromDate = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                TaskList.this.myCalendar.set(1, year);
                TaskList.this.myCalendar.set(2, monthOfYear);
                TaskList.this.myCalendar.set(5, dayOfMonth);
                String myFormat = "dd/MM/yyyy";
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                tlFrom.getEditText().setText((CharSequence)sdf.format(TaskList.this.myCalendar.getTime()));
                try {
                    TaskList.this.selected1 = Utility.getDateOnly(TaskList.this.myCalendar.getTime());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                tlTo.getEditText().getText().clear();
            }
        };
        final DatePickerDialog.OnDateSetListener toDate = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                TaskList.this.myCalendar1.set(1, year);
                TaskList.this.myCalendar1.set(2, monthOfYear);
                TaskList.this.myCalendar1.set(5, dayOfMonth);
                String myFormat = "dd/MM/yyyy";
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                tlTo.getEditText().setText((CharSequence)sdf.format(TaskList.this.myCalendar1.getTime()));
                try {
                    TaskList.this.selected2 = Utility.getDateOnly(TaskList.this.myCalendar1.getTime());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        };
        tlFrom.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (alert_spinner.getSelectedItemPosition() == 0) {
                    Toast.makeText((Context)TaskList.this.getApplicationContext(), (CharSequence)"Select Type", (int)0).show();
                    return;
                }
                DatePickerDialog datePicker = new DatePickerDialog((Context)TaskList.this, fromDate, TaskList.this.myCalendar.get(1), TaskList.this.myCalendar.get(2), TaskList.this.myCalendar.get(5));
                if (alert_spinner.getSelectedItemPosition() == 1 || alert_spinner.getSelectedItemPosition() == 2) {
                    datePicker.getDatePicker().setMinDate(Calendar.getInstance().getTimeInMillis());
                } else if (alert_spinner.getSelectedItemPosition() == 3) {
                    datePicker.getDatePicker().setMaxDate(Calendar.getInstance().getTimeInMillis());
                }
                datePicker.show();
            }
        });
        tlTo.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (tlFrom.getEditText().getText().toString().isEmpty()) {
                    Toast.makeText((Context)TaskList.this.getApplicationContext(), (CharSequence)"Select from Date", (int)0).show();
                    return;
                }
                DatePickerDialog datePicker = new DatePickerDialog((Context)TaskList.this, toDate, TaskList.this.myCalendar1.get(1), TaskList.this.myCalendar1.get(2), TaskList.this.myCalendar1.get(5));
                if (alert_spinner.getSelectedItemPosition() == 1 || alert_spinner.getSelectedItemPosition() == 2) {
                    datePicker.getDatePicker().setMinDate(TaskList.this.myCalendar.getTimeInMillis());
                } else if (alert_spinner.getSelectedItemPosition() == 3) {
                    datePicker.getDatePicker().setMinDate(TaskList.this.myCalendar.getTimeInMillis());
                    datePicker.getDatePicker().setMaxDate(Calendar.getInstance().getTimeInMillis());
                }
                datePicker.show();
            }
        });
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertDialog.hide();
            }
        });
        search.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (tlFrom.getEditText().getText().toString().isEmpty()) {
                    tlFrom.getEditText().setError((CharSequence)"Select Date");
                    return;
                }
                TaskList.this.searchResult(tlFrom.getEditText().getText().toString(), tlTo.getEditText().getText().toString(), TaskList.this.selected1, TaskList.this.selected2, alert_spinner.getSelectedItem().toString(), alertDialog);
            }
        });
        alertDialog.show();
    }

    private void searchResult(String from, String to, Date dfrom, Date dto, String type, AlertDialog alertDialog) {
        this.searchlist.clear();
        try {
            if (type.equalsIgnoreCase("Active")) {
                if (to.isEmpty()) {
                    for (TaskEncap taskEncap : this.taskList) {
                        if (!this.selected1.equals(taskEncap.getD_startdate()) && !this.selected1.equals(taskEncap.getD_enddatte()) && (!this.selected1.after(taskEncap.getD_startdate()) || !this.selected1.before(taskEncap.getD_enddatte()))) continue;
                        this.searchlist.add(taskEncap);
                    }
                } else {
                    for (TaskEncap taskEncap : this.taskList) {
                        if (!this.selected1.equals(taskEncap.getD_startdate()) && !this.selected1.equals(taskEncap.getD_enddatte()) && !this.selected2.equals(taskEncap.getD_startdate()) && !this.selected2.equals(taskEncap.getD_enddatte()) && (!taskEncap.getD_startdate().after(this.selected1) || !taskEncap.getD_startdate().before(this.selected2)) && (!taskEncap.getD_enddatte().after(this.selected1) || !taskEncap.getD_enddatte().before(this.selected2))) continue;
                        this.searchlist.add(taskEncap);
                    }
                }
            } else if (type.equalsIgnoreCase("Completed")) {
                if (to.isEmpty()) {
                    for (TaskEncap taskEncap : this.taskList) {
                        try {
                            if (!this.selected1.equals(Utility.getDateOnly(taskEncap.getD_updateddatetime()))) continue;
                            this.searchlist.add(taskEncap);
                        }
                        catch (ParseException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    for (TaskEncap taskEncap : this.taskList) {
                        if (taskEncap.getI_progress() != 100) continue;
                        try {
                            if (!this.selected1.equals(Utility.getDateOnly(taskEncap.getD_updateddatetime())) && !this.selected2.equals(Utility.getDateOnly(taskEncap.getD_updateddatetime())) && (!Utility.getDateOnly(taskEncap.getD_updateddatetime()).after(this.selected1) || !Utility.getDateOnly(taskEncap.getD_updateddatetime()).before(this.selected2)) && (!Utility.getDateOnly(taskEncap.getD_updateddatetime()).after(this.selected1) || !Utility.getDateOnly(taskEncap.getD_updateddatetime()).before(this.selected2))) continue;
                            this.searchlist.add(taskEncap);
                        }
                        catch (ParseException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            } else if (type.equalsIgnoreCase("Deadline")) {
                if (to.isEmpty()) {
                    for (TaskEncap taskEncap : this.taskList) {
                        if (!this.selected1.equals(taskEncap.getD_enddatte())) continue;
                        this.searchlist.add(taskEncap);
                    }
                } else {
                    for (TaskEncap taskEncap : this.taskList) {
                        if (!this.selected1.equals(taskEncap.getD_enddatte()) && !this.selected2.equals(taskEncap.getD_enddatte()) && (!taskEncap.getD_enddatte().after(this.selected1) || !taskEncap.getD_enddatte().before(this.selected2))) continue;
                        this.searchlist.add(taskEncap);
                    }
                }
            }
            if (this.searchlist.isEmpty()) {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"No tasks found", (int)0).show();
                return;
            }
            Intent intent = new Intent((Context)this, SearchResult.class);
            intent.putExtra("full_list", this.taskList);
            intent.putExtra("search_list", this.searchlist);
            intent.putExtra("title", type);
            intent.putExtra("fromDate", from);
            intent.putExtra("toDate", to);
            this.startActivity(intent);
            alertDialog.hide();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

