/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.old;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.cardview.widget.CardView;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.task.GlobalVariables;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.RejectForm;
import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.task.encap.NotificationEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
import com.google.android.material.snackbar.Snackbar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TaskNew
extends AppCompatActivity {
    TextView project_name;
    TextView milestone_name;
    TextView task_name;
    TextView task_description;
    TextView start_date;
    TextView end_date;
    TextView task_priority;
    TextView milestone_date;
    TextView listtask_name;
    RequestQueue requestQueue;
    TaskEncap taskEncap;
    ProgressDialog pDialog;
    private Sqlite sqldatabase;
    String taskid;
    ArrayList<TaskEncap> taskList = new ArrayList();
    private static final int BACK_PASSNG = 0;
    ArrayList<NotificationEncap> notificationEncaps = new ArrayList();
    CardView cardView;
    ProgressBar progressBar;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    MenuItem start;
    MenuItem stop;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492966);
        this.requestQueue = Volley.newRequestQueue((Context)this);
        this.sqldatabase = new Sqlite((Context)this);
        this.getWidgets();
        this.getSupportActionBar().setTitle((CharSequence)"Task");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.taskid = this.getIntent().getStringExtra("taskid");
        this.notificationEncaps = this.getIntent().getParcelableArrayListExtra("notifcationList");
        if (this.notificationEncaps != null) {
            NotificationEncap notificationEncap = this.notificationEncaps.get(0);
            this.sqldatabase.updateNotificationOpened(notificationEncap);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.isNetworkAvailable()) {
            this.getTasksOnline(this.taskid);
        } else {
            this.getTaskDetails();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558429, menu2);
        this.start = menu2.findItem(2131296282);
        this.stop = menu2.findItem(2131297249);
        return true;
    }

    private void getWidgets() {
        this.project_name = (TextView)this.findViewById(2131297202);
        this.milestone_name = (TextView)this.findViewById(2131297015);
        this.task_name = (TextView)this.findViewById(2131297476);
        this.task_description = (TextView)this.findViewById(2131297473);
        this.start_date = (TextView)this.findViewById(2131297480);
        this.end_date = (TextView)this.findViewById(2131297475);
        this.task_priority = (TextView)this.findViewById(2131297477);
        this.findViewById(2131296553).setVisibility(8);
        this.cardView = (CardView)this.findViewById(2131296495);
        this.progressBar = (ProgressBar)this.findViewById(2131296882);
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296592);
        this.milestone_date = (TextView)this.findViewById(2131297013);
        this.listtask_name = (TextView)this.findViewById(2131296965);
    }

    private void setValues() {
        this.project_name.setText((CharSequence)this.taskEncap.getProjectname());
        this.task_name.setText((CharSequence)this.taskEncap.getTaskname());
        this.milestone_name.setText((CharSequence)this.taskEncap.getMilestonename());
        this.task_description.setText((CharSequence)this.taskEncap.getDescription());
        this.start_date.setText((CharSequence)this.taskEncap.getStartdate());
        this.end_date.setText((CharSequence)this.taskEncap.getEnddatte());
        this.task_priority.setText((CharSequence)this.taskEncap.getPriotity());
        GlobalVariables globalVariables = (GlobalVariables)this.getApplication();
        globalVariables.setProjectId(this.taskEncap.getProjctid());
        this.milestone_date.setText((CharSequence)this.taskEncap.getMilestoneenddate());
        this.listtask_name.setText((CharSequence)this.taskEncap.getListtaskname());
    }

    private void acceptTask() {
        if (!Utility.isNetworkAvailable((Context)this)) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"No Internet Connection", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    TaskNew.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
            return;
        }
        LocationManager locationManager = (LocationManager)this.getSystemService("location");
        boolean isGPSEnabled = locationManager.isProviderEnabled("gps");
        boolean isNetworkEnabled = locationManager.isProviderEnabled("network");
        if (!isGPSEnabled && !isNetworkEnabled) {
            AlertDialog.Builder alertdialog = new AlertDialog.Builder((Context)this);
            alertdialog.setTitle((CharSequence)"Access Location");
            alertdialog.setIcon(2131230915);
            alertdialog.setMessage((CharSequence)"No network provider is enabled for location access!!");
            alertdialog.setPositiveButton((CharSequence)"Turn On", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    TaskNew.this.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS"));
                }
            });
            alertdialog.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
            alertdialog.show();
            return;
        }
        final LatLang latLang = Utility.getLocation((Context)this);
        this.pDialog = new ProgressDialog((Context)this);
        this.pDialog.setMessage((CharSequence)"Loading...");
        this.pDialog.setIndeterminate(false);
        this.pDialog.setCancelable(false);
        this.pDialog.show();
        StringRequest postRequest2 = new StringRequest(1, "http://fieldcloud.in/App/accept_task.php", (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                Log.d((String)"Response", (String)response);
                try {
                    JSONObject json = new JSONObject(response);
                    int success = json.getInt("success");
                    if (success == 1) {
                        TaskNew.this.sqldatabase.updateTaskAccepted(TaskNew.this.taskEncap.getTaskid());
                        TaskNew.this.finish();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                TaskNew.this.pDialog.dismiss();
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                TaskNew.this.pDialog.dismiss();
                Log.d((String)"Error.Response", (String)error.toString());
            }
        }){

            protected Map<String, String> getParams() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("assign_id", TaskNew.this.taskEncap.getAssignid());
                params.put("datetime", Utility.getCurrentDateTime());
                params.put("latitude", latLang.getLatitude());
                params.put("longtitude", latLang.getLongitude());
                return params;
            }
        };
        this.requestQueue.add((Request)postRequest2);
    }

    private void getTaskDetails() {
        this.taskList = this.sqldatabase.getSingleTask(this.taskid);
        if (this.taskList.size() != 0) {
            this.taskEncap = this.taskList.get(0);
            this.cardView.setVisibility(0);
            this.getSharedPreferences("projectid", 0).edit().putString("tasklistid", this.taskEncap.getListtaskid()).apply();
            this.setValues();
        } else {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"Details not found", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    TaskNew.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
        }
    }

    private void getTasksOnline(final String taskid) {
        this.cardView.setVisibility(8);
        this.progressBar.setVisibility(0);
        StringRequest postRequest2 = new StringRequest(1, "http://fieldcloud.in/App/getSingleTask.php", (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                Log.d((String)"Response", (String)response);
                try {
                    JSONObject json = new JSONObject(response);
                    int success = json.getInt("success");
                    if (success == 1) {
                        JSONObject jsonObject;
                        int i;
                        JSONArray jsonArray = json.getJSONArray("tasks");
                        JSONArray projectArray = json.getJSONArray("project");
                        JSONArray milestoneArray = json.getJSONArray("milestone");
                        JSONArray listtaskArray = json.getJSONArray("listtask");
                        JSONArray progresslsitArray = json.getJSONArray("progresslist");
                        for (i = 0; i < jsonArray.length(); ++i) {
                            jsonObject = jsonArray.getJSONObject(i);
                            TaskNew.this.taskEncap = new TaskEncap(jsonObject);
                            TaskNew.this.sqldatabase.insert_task(TaskNew.this.taskEncap);
                        }
                        for (i = 0; i < milestoneArray.length(); ++i) {
                            jsonObject = milestoneArray.getJSONObject(i);
                            TaskNew.this.sqldatabase.updateMilestoneDatails(jsonObject);
                        }
                        for (i = 0; i < listtaskArray.length(); ++i) {
                            jsonObject = listtaskArray.getJSONObject(i);
                            TaskNew.this.sqldatabase.updateListtask(jsonObject);
                        }
                        for (i = 0; i < projectArray.length(); ++i) {
                            jsonObject = projectArray.getJSONObject(i);
                            TaskNew.this.sqldatabase.updateProjectDetails(jsonObject);
                        }
                        for (i = 0; i < progresslsitArray.length(); ++i) {
                            jsonObject = progresslsitArray.getJSONObject(i);
                            TaskNew.this.sqldatabase.insertTaskProgress(jsonObject);
                        }
                        TaskNew.this.getTaskDetails();
                        TaskNew.this.progressBar.setVisibility(8);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                TaskNew.this.progressBar.setVisibility(8);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                TaskNew.this.start.setVisible(false);
                TaskNew.this.stop.setVisible(false);
                Log.d((String)"Error.Response", (String)error.toString());
                TaskNew.this.snackbar = Snackbar.make((View)TaskNew.this.coordinatorLayout, (CharSequence)"Internet connectivity problem", (int)-2).setAction((CharSequence)"close", new View.OnClickListener(){

                    public void onClick(View view) {
                        TaskNew.this.snackbar.dismiss();
                    }
                });
                TaskNew.this.snackbar.show();
                TaskNew.this.progressBar.setVisibility(8);
            }
        }){

            protected Map<String, String> getParams() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("taskid", taskid);
                return params;
            }
        };
        this.requestQueue.add((Request)postRequest2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        Intent intent = new Intent((Context)this, RejectForm.class);
        intent.putParcelableArrayListExtra("arrayList", this.taskList);
        switch (item.getItemId()) {
            case 2131297249: {
                if (this.progressBar.getVisibility() != 8) break;
                intent.putExtra("request", "reject");
                this.startActivity(intent);
                break;
            }
            case 2131296282: {
                if (this.progressBar.getVisibility() != 8) break;
                this.acceptTask();
                break;
            }
            case 16908332: {
                this.onBackPressed();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }
}

