/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.others;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.IntentSender;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.os.Looper;
import android.provider.Settings;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.ActivityCompat;
import com.b2lmobitech.fieldcloudplus.BuildConfig;
import com.b2lmobitech.fieldcloudplus.task.listener.LocationUpdateListener;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;

public class LocationUpdate {
    private static LocationUpdate mInstance;
    private static Context mContext;
    public static final int REQUEST_CHECK_SETTINGS = 1;

    private LocationUpdate(Context context) {
        mContext = context;
    }

    public static synchronized LocationUpdate getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new LocationUpdate(context);
        }
        return mInstance;
    }

    private void getLcoation(final LocationUpdateListener locationUpdateListener) {
        if (ActivityCompat.checkSelfPermission((Context)mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)mContext, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        LocationManager locationManager = (LocationManager)mContext.getSystemService("location");
        LocationRequest locationRequest2 = LocationRequest.create();
        locationRequest2.setPriority(100);
        locationRequest2.setInterval(10000L);
        locationRequest2.setFastestInterval(5000L);
        locationRequest2.setNumUpdates(1);
        LocationServices.getFusedLocationProviderClient((Context)mContext).requestLocationUpdates(locationRequest2, new LocationCallback(){

            public void onLocationResult(LocationResult locationResult) {
                Location location = locationResult.getLastLocation();
                if (location != null) {
                    boolean isMock;
                    if (Build.VERSION.SDK_INT >= 18) {
                        isMock = location.isFromMockProvider();
                    } else {
                        boolean bl = isMock = !Settings.Secure.getString((ContentResolver)mContext.getContentResolver(), (String)"mock_location").equals("0");
                    }
                    if (isMock && !BuildConfig.DEBUG) {
                        LocationUpdate.this.showFakelOcationAlert();
                    } else {
                        locationUpdateListener.onLocationReceived(location.getLatitude() + "", location.getLongitude() + "");
                    }
                } else {
                    Toast.makeText((Context)mContext, (CharSequence)"Unable to find lcoation", (int)0).show();
                }
            }
        }, Looper.myLooper());
    }

    public void connectLocation(final LocationUpdateListener locationUpdateListener) {
        LocationRequest locationRequest2 = LocationRequest.create();
        locationRequest2.setPriority(100);
        locationRequest2.setInterval(10000L);
        locationRequest2.setFastestInterval(5000L);
        locationRequest2.setNumUpdates(1);
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest2);
        builder.setAlwaysShow(true);
        Task task = LocationServices.getSettingsClient((Context)mContext).checkLocationSettings(builder.build());
        task.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<LocationSettingsResponse>(){

            public void onComplete(Task<LocationSettingsResponse> task) {
                try {
                    task.getResult(ApiException.class);
                    LocationUpdate.this.getLcoation(locationUpdateListener);
                }
                catch (ApiException exception) {
                    switch (exception.getStatusCode()) {
                        case 6: {
                            try {
                                ResolvableApiException resolvable = (ResolvableApiException)exception;
                                resolvable.startResolutionForResult((Activity)mContext, 1);
                                break;
                            }
                            catch (IntentSender.SendIntentException sendIntentException) {
                                break;
                            }
                            catch (ClassCastException classCastException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        });
    }

    private void showFakelOcationAlert() {
        AlertDialog.Builder builder = new AlertDialog.Builder(mContext);
        builder.setPositiveButton((CharSequence)"CLOSE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
            }
        });
        builder.setTitle((CharSequence)"FAKE LOCATION DETECTED");
        builder.setMessage((CharSequence)"Turn off fake location and retry");
        AlertDialog dialog = builder.create();
        dialog.show();
    }
}

