/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.others;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.widget.Toast;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.RetryPolicy;
import com.android.volley.toolbox.Volley;

public class NetworkQueue {
    private static NetworkQueue mInstance;
    private RequestQueue mRequestQueue;
    private static Context mContext;

    private NetworkQueue(Context context) {
        mContext = context;
        this.mRequestQueue = this.getRequestQueue();
    }

    public static synchronized NetworkQueue getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new NetworkQueue(context);
        }
        return mInstance;
    }

    public RequestQueue getRequestQueue() {
        if (this.mRequestQueue == null) {
            this.mRequestQueue = Volley.newRequestQueue((Context)mContext.getApplicationContext());
        }
        return this.mRequestQueue;
    }

    public <T> void addToRequestQueue(Request<T> request) {
        request.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(240000, 1, 1.0f));
        this.getRequestQueue().add(request);
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)mContext.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            return true;
        }
        Toast.makeText((Context)mContext, (CharSequence)"No Inernet Connection", (int)0).show();
        return false;
    }
}

