/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.others;

import android.content.Context;
import android.content.SharedPreferences;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;

public class Preference {
    private static Preference mInstance;
    private static SharedPreferences sharedPreferences;
    Context context;

    private Preference(Context context) {
        sharedPreferences = context.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        this.context = context;
    }

    public static synchronized Preference getInstance(Context context) {
        mInstance = new Preference(context);
        return mInstance;
    }

    public String getString(String str) {
        return sharedPreferences.getString(str, "");
    }

    public void putString(String key, String pair) {
        sharedPreferences.edit().putString(key, pair).apply();
    }

    public void putProjectId(String id2) {
        sharedPreferences.edit().putString("projectId", id2).apply();
    }

    public String getProjectId() {
        return sharedPreferences.getString("projectId", "");
    }

    public void putTaskListId(String id2) {
        sharedPreferences.edit().putString("tasklistId", id2).apply();
    }

    public String getTaskListId() {
        return sharedPreferences.getString("tasklistId", "");
    }

    public String getCompanyName() {
        return sharedPreferences.getString(globalvariables.logout_companyname, "");
    }

    public String getEmailId() {
        return sharedPreferences.getString(globalvariables.logout_emailid, "").toLowerCase();
    }

    public String getDesignation() {
        return sharedPreferences.getString(globalvariables.logout_designation, "");
    }

    public boolean isAdmin() {
        return sharedPreferences.getString(globalvariables.logout_designation, "").equalsIgnoreCase("admin");
    }

    public boolean isResponsible(String projectId) {
        return this.isAdmin() || Database.getInstance(this.context).isResponsibleForThisProject(projectId, this.getEmailId());
    }

    public String getCompnayType() {
        return sharedPreferences.getString(globalvariables.logout_companytype, "");
    }
}

