/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.others;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Base64;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Utility {
    public static String imgToString(Bitmap bitmap) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
        byte[] byteArray = stream.toByteArray();
        return Base64.encodeToString((byte[])byteArray, (int)0);
    }

    public static String imgToString(Drawable drawable2) {
        return Utility.imgToString(Utility.drawableToBitmap(drawable2));
    }

    public static String imgToString(Drawable drawable2, Bitmap bitmap) {
        return Utility.imgToString(Utility.overlay(Utility.drawableToBitmap(drawable2), bitmap));
    }

    public static String imgToString(Bitmap bitmap1, Bitmap bitmap2) {
        return Utility.imgToString(Utility.overlay(bitmap1, bitmap2));
    }

    public static Bitmap bitmap(String str) {
        byte[] decodedBytes = Base64.decode((String)str, (int)0);
        return BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
    }

    public static Bitmap overlay(Bitmap bmp1, Bitmap bmp2) {
        Bitmap bmOverlay = Bitmap.createBitmap((int)bmp1.getWidth(), (int)bmp1.getHeight(), (Bitmap.Config)bmp1.getConfig());
        Canvas canvas = new Canvas(bmOverlay);
        canvas.drawBitmap(bmp1, new Matrix(), null);
        canvas.drawBitmap(bmp2, 0.0f, 0.0f, null);
        return bmOverlay;
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        int width = drawable2.getIntrinsicWidth();
        width = width > 0 ? width : 1;
        int height = drawable2.getIntrinsicHeight();
        height = height > 0 ? height : 1;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    public static File getCapturedImageFile(Context context) throws IOException {
        File mediaStorageDir = context.getCacheDir();
        File mediaFile = new File(mediaStorageDir.getPath() + File.separator + "IMG_" + System.currentTimeMillis() + ".jpg");
        try {
            mediaFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mediaFile;
    }

    public static File getSignFile(Context context) throws IOException {
        File mediaStorageDir = context.getCacheDir();
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            return null;
        }
        File mediaFile = new File(mediaStorageDir.getPath() + File.separator + "SIGN_" + System.currentTimeMillis() + ".jpg");
        try {
            mediaFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mediaFile;
    }

    public static String getCurrentDateTime() {
        Calendar c1 = Calendar.getInstance();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return df1.format(c1.getTime());
    }

    public static String getCurrentDate() {
        Calendar c1 = Calendar.getInstance();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        return df1.format(c1.getTime());
    }

    public static String getNormalDatetime(String str) throws ParseException {
        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(str);
        return new SimpleDateFormat("dd-MM-yyyy hh:mm a").format(date);
    }

    public static Bitmap processImage(Bitmap bitmap) {
        float s43;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        float x = (float)bitmap.getHeight() / (float)bitmap.getWidth();
        bitmap = x == (s43 = 1.3333334f) ? Bitmap.createScaledBitmap((Bitmap)bitmap, (int)360, (int)480, (boolean)true) : Bitmap.createScaledBitmap((Bitmap)bitmap, (int)360, (int)640, (boolean)true);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
        byte[] byteArray = stream.toByteArray();
        if (byteArray.length > 160000) {
            bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)stream);
        }
        Log.e((String)"IamgeSize", (String)(byteArray.length + " b"));
        return bitmap;
    }

    public static String bitmap2string(Bitmap bm) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
        byte[] byteArray = stream.toByteArray();
        return Base64.encodeToString((byte[])byteArray, (int)0);
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }
}

