/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.service;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.util.Log;
import android.widget.Toast;
import androidx.activity.ComponentActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.app.NotificationCompat;
import androidx.lifecycle.LifecycleService;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.task.service.GeofenceBroadcastReceiver;
import com.b2lmobitech.fieldcloudplus.task.service.LocationBatteryService;
import com.b2lmobitech.fieldcloudplus.utils.DistanceCalculator;
import com.b2lmobitech.fieldcloudplus.utils.LocationUtils;
import com.b2lmobitech.fieldcloudplus.utils.LocationUtilsKt;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\bH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\"\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0016J0\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0002J\b\u0010#\u001a\u00020\bH\u0002J2\u0010$\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/b2lmobitech/fieldcloudplus/task/service/LocationBatteryService;", "Landroidx/lifecycle/LifecycleService;", "()V", "locationClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "loginCalledOnce", "", "checkBatteryStatus", "", "location", "Landroid/location/Location;", "defectId", "", "latitude", "", "longitude", "radius", "", "atmId", "createNotificationChannel", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onCreate", "onDestroy", "onStartCommand", "", "flags", "startId", "sendLocationBatteryDetails", "id", "lat", "lon", "battery", "startForegroundService", "startLocationUpdates", "Companion", "app_debug"})
public final class LocationBatteryService
extends LifecycleService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private FusedLocationProviderClient locationClient;
    private boolean loginCalledOnce;

    public void onCreate() {
        super.onCreate();
        FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)((Context)this));
        Intrinsics.checkNotNullExpressionValue((Object)fusedLocationProviderClient, (String)"getFusedLocationProviderClient(...)");
        this.locationClient = fusedLocationProviderClient;
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        block1: {
            super.onStartCommand(intent, flags, startId);
            this.startForegroundService();
            Intent intent2 = intent;
            if (intent2 == null) break block1;
            Intent $this$onStartCommand_u24lambda_u240 = intent2;
            boolean bl = false;
            String string2 = $this$onStartCommand_u24lambda_u240.getStringExtra("defectId");
            double d = $this$onStartCommand_u24lambda_u240.getDoubleExtra("latitude", 0.0);
            double d2 = $this$onStartCommand_u24lambda_u240.getDoubleExtra("longitude", 0.0);
            float f = $this$onStartCommand_u24lambda_u240.getFloatExtra("radius", 0.0f);
            String string3 = $this$onStartCommand_u24lambda_u240.getStringExtra("atmId");
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            Intrinsics.checkNotNull((Object)string4);
            this.startLocationUpdates(string2, d, d2, f, string4);
        }
        return 1;
    }

    private final void startForegroundService() {
        this.createNotificationChannel();
        Notification notification = new NotificationCompat.Builder((Context)this, "location_channel").setContentTitle((CharSequence)"Field Cloud").setContentText((CharSequence)"Task In Progress").setOngoing(true).setSmallIcon(2131231014).build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"build(...)");
        Notification notification2 = notification;
        this.startForeground(1, notification2);
    }

    private final void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel("location_channel", (CharSequence)"LocationService", 2);
            NotificationManager manager = (NotificationManager)this.getSystemService(NotificationManager.class);
            manager.createNotificationChannel(channel);
        }
    }

    private final void startLocationUpdates(String defectId, double latitude, double longitude, float radius, String atmId) {
        Handler handler = new Handler(Looper.getMainLooper());
        Runnable runnable2 = new Runnable(this, handler, defectId, latitude, longitude, radius, atmId){
            final /* synthetic */ LocationBatteryService this$0;
            final /* synthetic */ Handler $handler;
            final /* synthetic */ String $defectId;
            final /* synthetic */ double $latitude;
            final /* synthetic */ double $longitude;
            final /* synthetic */ float $radius;
            final /* synthetic */ String $atmId;
            {
                this.this$0 = $receiver;
                this.$handler = $handler;
                this.$defectId = $defectId;
                this.$latitude = $latitude;
                this.$longitude = $longitude;
                this.$radius = $radius;
                this.$atmId = $atmId;
            }

            public void run() {
                if (ActivityCompat.checkSelfPermission((Context)((Context)this.this$0), (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)((Context)this.this$0), (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                    return;
                }
                FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)((Context)this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)fusedLocationProviderClient, (String)"getFusedLocationProviderClient(...)");
                FusedLocationProviderClient fusedLocationClient = fusedLocationProviderClient;
                fusedLocationClient.getCurrentLocation(100, null).addOnSuccessListener(arg_0 -> startLocationUpdates.runnable.1.run$lambda$0((Function1)new Function1<Location, Unit>(this.this$0, this.$defectId, this.$latitude, this.$longitude, this.$radius, this.$atmId){
                    final /* synthetic */ LocationBatteryService this$0;
                    final /* synthetic */ String $defectId;
                    final /* synthetic */ double $latitude;
                    final /* synthetic */ double $longitude;
                    final /* synthetic */ float $radius;
                    final /* synthetic */ String $atmId;
                    {
                        this.this$0 = $receiver;
                        this.$defectId = $defectId;
                        this.$latitude = $latitude;
                        this.$longitude = $longitude;
                        this.$radius = $radius;
                        this.$atmId = $atmId;
                        super(1);
                    }

                    public final void invoke(Location location) {
                        if (location != null) {
                            LocationBatteryService.access$checkBatteryStatus(this.this$0, location, this.$defectId, this.$latitude, this.$longitude, this.$radius, this.$atmId);
                        }
                    }
                }, arg_0));
                this.$handler.postDelayed((Runnable)this, 60000L);
            }

            private static final void run$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        };
        handler.post(runnable2);
    }

    private final void checkBatteryStatus(Location location, String defectId, double latitude, double longitude, float radius, String atmId) {
        double distance;
        Intent batteryStatus;
        IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        boolean bl = false;
        Intent intent = batteryStatus = this.getApplicationContext().registerReceiver(null, ifilter);
        int level = intent != null ? intent.getIntExtra("level", -1) : -1;
        Intent intent2 = batteryStatus;
        int scale = intent2 != null ? intent2.getIntExtra("scale", -1) : -1;
        float batteryPct = (float)level / (float)scale * (float)100;
        System.out.println((Object)("Battery: " + batteryPct));
        String string2 = defectId;
        if (string2 == null) {
            string2 = "";
        }
        this.sendLocationBatteryDetails(string2, String.valueOf(location.getLatitude()), String.valueOf(location.getLongitude()), "" + location.getLatitude() + ',' + location.getLongitude(), String.valueOf(batteryPct));
        if (!this.loginCalledOnce && (distance = DistanceCalculator.distance(location.getLatitude(), location.getLongitude(), latitude, longitude)) <= (double)radius) {
            Context context = (Context)this;
            double d = location.getLatitude();
            double d2 = location.getLongitude();
            String string3 = defectId;
            if (string3 == null) {
                string3 = "";
            }
            GeofenceBroadcastReceiver.Companion.updateGeoFenceToServer(context, true, atmId, d, d2, string3);
            this.loginCalledOnce = true;
        }
    }

    private final void sendLocationBatteryDetails(String id2, String lat, String lon, String location, String battery) {
        RequestQueue requestQueue = Volley.newRequestQueue((Context)this.getApplicationContext());
        Intrinsics.checkNotNullExpressionValue((Object)requestQueue, (String)"newRequestQueue(...)");
        RequestQueue requestQueue2 = requestQueue;
        Response.Listener listener2 = LocationBatteryService::sendLocationBatteryDetails$lambda$2;
        Response.ErrorListener errorListener = LocationBatteryService::sendLocationBatteryDetails$lambda$3;
        StringRequest postRequest2 = new StringRequest(id2, lat, lon, location, battery, (Response.Listener<String>)listener2, errorListener){
            final /* synthetic */ String $id;
            final /* synthetic */ String $lat;
            final /* synthetic */ String $lon;
            final /* synthetic */ String $location;
            final /* synthetic */ String $battery;
            {
                this.$id = $id;
                this.$lat = $lat;
                this.$lon = $lon;
                this.$location = $location;
                this.$battery = $battery;
                super(1, "http://fieldcloud.in/original_new_k_Eversendai/App_developing/api//defect/defect_add_live_location.php", $super_call_param$1, $super_call_param$2);
            }

            @NotNull
            protected Map<String, String> getParams() {
                Map params = new HashMap<K, V>();
                params.put("report_id", this.$id);
                params.put("lat", this.$lat);
                params.put("lon", this.$lon);
                params.put("location", this.$location);
                params.put("battery", this.$battery);
                return params;
            }
        };
        requestQueue2.add((Request)postRequest2);
    }

    public void onDestroy() {
        super.onDestroy();
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        super.onBind(intent);
        return null;
    }

    private static final void sendLocationBatteryDetails$lambda$2(String response) {
        String string2 = response;
        Intrinsics.checkNotNull((Object)string2);
        Log.d((String)"Response", (String)string2);
        try {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final void sendLocationBatteryDetails$lambda$3(VolleyError error) {
        Log.d((String)"Error.Response", (String)error.toString());
    }

    public static final /* synthetic */ void access$checkBatteryStatus(LocationBatteryService $this, Location location, String defectId, double latitude, double longitude, float radius, String atmId) {
        $this.checkBatteryStatus(location, defectId, latitude, longitude, radius, atmId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/b2lmobitech/fieldcloudplus/task/service/LocationBatteryService$Companion;", "", "()V", "startLocationService", "", "activity", "Landroidx/activity/ComponentActivity;", "defectId", "", "latitude", "", "longitude", "radius", "", "atmId", "stopLocationService", "context", "Landroid/content/Context;", "app_debug"})
    public static final class Companion {
        private Companion() {
        }

        public final void startLocationService(@NotNull ComponentActivity activity, @NotNull String defectId, double latitude, double longitude, float radius, @NotNull String atmId) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)defectId, (String)"defectId");
            Intrinsics.checkNotNullParameter((Object)atmId, (String)"atmId");
            LocationUtils.INSTANCE.requestLocationPermission(activity, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(activity, defectId, latitude, longitude, radius, atmId){
                final /* synthetic */ ComponentActivity $activity;
                final /* synthetic */ String $defectId;
                final /* synthetic */ double $latitude;
                final /* synthetic */ double $longitude;
                final /* synthetic */ float $radius;
                final /* synthetic */ String $atmId;
                {
                    this.$activity = $activity;
                    this.$defectId = $defectId;
                    this.$latitude = $latitude;
                    this.$longitude = $longitude;
                    this.$radius = $radius;
                    this.$atmId = $atmId;
                    super(1);
                }

                public final void invoke(boolean it) {
                    if (it) {
                        Intent intent = new Intent((Context)this.$activity, LocationBatteryService.class);
                        String string2 = this.$defectId;
                        double d = this.$latitude;
                        double d2 = this.$longitude;
                        float f = this.$radius;
                        String string3 = this.$atmId;
                        Intent $this$invoke_u24lambda_u240 = intent;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.putExtra("defectId", string2);
                        $this$invoke_u24lambda_u240.putExtra("latitude", d);
                        $this$invoke_u24lambda_u240.putExtra("longitude", d2);
                        $this$invoke_u24lambda_u240.putExtra("radius", f);
                        $this$invoke_u24lambda_u240.putExtra("atmId", string3);
                        Intent serviceIntent = intent;
                        this.$activity.startService(serviceIntent);
                    } else {
                        Toast.makeText((Context)((Context)this.$activity), (CharSequence)"Enable Location Permission", (int)0).show();
                        LocationUtilsKt.openAppSettings((Activity)this.$activity);
                    }
                }
            }));
        }

        public final void stopLocationService(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent serviceIntent = new Intent(context, LocationBatteryService.class);
            context.stopService(serviceIntent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

