/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.service;

import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import com.b2lmobitech.fieldcloudplus.defect.DefectDetailsActivity;
import com.b2lmobitech.fieldcloudplus.task.service.SnoozeBroadcastReceiver;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J2\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000b\u00a8\u0006\u0011"}, d2={"Lcom/b2lmobitech/fieldcloudplus/task/service/NotificationUtils;", "", "()V", "createDefectNotificationChannel", "", "context", "Landroid/content/Context;", "soundUri", "Landroid/net/Uri;", "showDefectNotificationWithAlarm", "id", "", "title", "message", "snoozeCount", "", "showSimpleNotification", "app_debug"})
public final class NotificationUtils {
    @NotNull
    public static final NotificationUtils INSTANCE = new NotificationUtils();

    private NotificationUtils() {
    }

    private final void createDefectNotificationChannel(Context context, Uri soundUri) {
        String channelId = "defect";
        String channelName = "Defect Notification Channel";
        String channelDescription = "Defect Notification Channel";
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelName, 3);
            channel.setSound(soundUri, new AudioAttributes.Builder().setUsage(5).build());
            channel.enableLights(true);
            channel.setDescription(channelDescription);
            NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
            notificationManager.createNotificationChannel(channel);
            Object object = context.getSystemService("notification");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
            NotificationManager mNotificationManager = (NotificationManager)object;
            mNotificationManager.createNotificationChannel(channel);
        }
    }

    public final void showDefectNotificationWithAlarm(@NotNull String id2, @NotNull String title, @Nullable String message, @NotNull Context context, int snoozeCount) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int notificationId = (int)new Date().getTime();
        Uri soundUri = RingtoneManager.getDefaultUri((int)4);
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager mNotificationManager = (NotificationManager)object;
        Intrinsics.checkNotNull((Object)soundUri);
        this.createDefectNotificationChannel(context, soundUri);
        Intent acceptIntent = new Intent(context, DefectDetailsActivity.class);
        acceptIntent.putExtra("notification_id", notificationId);
        acceptIntent.putExtra("status", "open");
        acceptIntent.putExtra("id", id2);
        acceptIntent.putExtra("accept", true);
        Intent snoozeIntent = new Intent(context, SnoozeBroadcastReceiver.class);
        snoozeIntent.setAction("SNOOZE_ACTION");
        snoozeIntent.putExtra("notification_id", notificationId);
        snoozeIntent.putExtra("id", id2);
        snoozeIntent.putExtra("title", title);
        snoozeIntent.putExtra("message", message);
        snoozeIntent.putExtra("count", snoozeCount);
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 31) {
            flags |= 0x2000000;
        }
        NotificationCompat.Builder status = new NotificationCompat.Builder(context, "defect");
        long[] lArray = new long[]{0L, 500L, 1000L};
        status.setAutoCancel(true).setWhen(System.currentTimeMillis()).setSmallIcon(2131623939).setContentTitle((CharSequence)title).setContentText((CharSequence)message).setOngoing(true).setVibrate(lArray).setDefaults(4).setSound(soundUri);
        if (snoozeCount < 3) {
            status.setDeleteIntent(PendingIntent.getBroadcast((Context)context, (int)0, (Intent)snoozeIntent, (int)flags));
            status.addAction(2131230806, (CharSequence)"Snooze", PendingIntent.getBroadcast((Context)context, (int)0, (Intent)snoozeIntent, (int)flags));
        } else {
            status.setDeleteIntent(PendingIntent.getActivity((Context)context, (int)1, (Intent)acceptIntent, (int)flags));
        }
        status.addAction(2131230865, (CharSequence)"Accept", PendingIntent.getActivity((Context)context, (int)1, (Intent)acceptIntent, (int)flags));
        mNotificationManager.notify(notificationId, status.build());
    }

    public static /* synthetic */ void showDefectNotificationWithAlarm$default(NotificationUtils notificationUtils, String string2, String string3, String string4, Context context, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        notificationUtils.showDefectNotificationWithAlarm(string2, string3, string4, context, n);
    }

    public final void showSimpleNotification(@NotNull Context context, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object object = context.getSystemService("notification");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
        NotificationManager mNotificationManager = (NotificationManager)object;
        String channelId = "GENERAL";
        String channelName = "GENERAL Notification Channel";
        String channelDescription = "GENERAL Notification Channel";
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelName, 3);
            channel.enableLights(true);
            channel.setDescription(channelDescription);
            NotificationManager notificationManager = (NotificationManager)context.getSystemService(NotificationManager.class);
            notificationManager.createNotificationChannel(channel);
            mNotificationManager.createNotificationChannel(channel);
        }
        NotificationCompat.Builder status = new NotificationCompat.Builder(context, "defect");
        long[] lArray = new long[]{0L, 500L, 1000L};
        status.setAutoCancel(true).setWhen(System.currentTimeMillis()).setSmallIcon(2131623939).setContentTitle((CharSequence)"GeoFence").setContentText((CharSequence)message).setVibrate(lArray).setDefaults(4);
        mNotificationManager.notify(0, status.build());
    }
}

