/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.service;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.task.activities.Dashboard;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
import java.util.ArrayList;

public class ReminderReceiver
extends BroadcastReceiver {
    Sqlite sqldatabase;

    public void onReceive(Context context, Intent intent) {
        this.sqldatabase = new Sqlite(context);
        int late = 0;
        int active = 0;
        try {
            String emailid = context.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0).getString(globalvariables.logout_emailid, "");
            Log.e((String)"user", (String)emailid);
            ArrayList<TaskEncap> arrayList = this.sqldatabase.getAllTasks(emailid);
            for (TaskEncap taskEncap : arrayList) {
                if (!taskEncap.getEmail_id().equalsIgnoreCase(emailid)) continue;
                if (taskEncap.getCategory().equals((Object)TaskEnum.ACTIVE)) {
                    Log.e((String)"active", (String)taskEncap.getTaskname());
                    ++active;
                    continue;
                }
                if (!taskEncap.getCategory().equals((Object)TaskEnum.LATE)) continue;
                Log.e((String)"LATE", (String)taskEncap.getTaskname());
                ++late;
            }
            int total = late + active;
            if (total != 0) {
                Intent intent1 = new Intent(context, Dashboard.class);
                PendingIntent pIntent = PendingIntent.getActivity((Context)context, (int)1, (Intent)intent1, (int)0x8000000);
                NotificationCompat.Builder builder = new NotificationCompat.Builder(context, "daily").setSmallIcon(2131623939).setTicker((CharSequence)"REMINDER!!").setContentTitle((CharSequence)"Today Tasks").setContentIntent(pIntent).setAutoCancel(true);
                if (late == 0) {
                    builder.setContentText((CharSequence)("Total : " + total));
                } else {
                    builder.setContentText((CharSequence)("Total : " + total + "(" + late + " late)"));
                }
                NotificationManager notificationmanager = (NotificationManager)context.getSystemService("notification");
                notificationmanager.notify(1, builder.build());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

