/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.sql;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.android.volley.RequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.SqliteHelper;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.CategoryTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ClientTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.EmployeeTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TagTable;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.TasklistTable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Database {
    private static Database mInstance;
    private RequestQueue mRequestQueue;
    private static Context mContext;
    private static SqliteHelper sqliteHelper;

    private Database(Context context) {
        mContext = context;
        sqliteHelper = new SqliteHelper(context);
    }

    public static synchronized Database getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new Database(context);
        }
        return mInstance;
    }

    public void insertProjects(JSONArray jsonArray) throws Exception {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(ProjectTable.PROJECTID, jsonObject.getString("projectid"));
            cv.put(ProjectTable.PROJECTNAME, jsonObject.getString("projectname"));
            cv.put(ProjectTable.DESCRIPTION, jsonObject.getString("description"));
            cv.put(ProjectTable.STARTDATE, jsonObject.getString("startdate"));
            cv.put(ProjectTable.ENDDATE, jsonObject.getString("enddate"));
            cv.put(ProjectTable.STATUS, jsonObject.getString("status"));
            cv.put(ProjectTable.RESPONSIBLEPERSON, jsonObject.getString("presponsible").toLowerCase());
            cv.put(ProjectTable.CREATEDBY, jsonObject.getString("pcreatedby").toLowerCase());
            cv.put(ProjectTable.CREATEDBYTYPE, jsonObject.getString("createdbytype"));
            cv.put(ProjectTable.CREATEDDATETIME, jsonObject.getString("createdatetime"));
            cv.put(ProjectTable.TAGID, jsonObject.getString("tagid"));
            cv.put(ProjectTable.CATID, jsonObject.getString("catid"));
            cv.put(ProjectTable.CLIENT, jsonObject.getString("client"));
            cv.put(ProjectTable.CLIENTCOMPANYID, jsonObject.getString("clientcompany"));
            cv.put(ProjectTable.UPDATEDATETIME, jsonObject.getString("updateddatetime"));
            cv.put(ProjectTable.DELETED, jsonObject.getString(ProjectTable.DELETED));
            sdb.insertWithOnConflict(ProjectTable.TABLENAME, null, cv, 5);
        }
        sdb.close();
    }

    public void insertMilestones(JSONArray jsonArray) throws Exception {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(MilestoneTable.PROJECTID, jsonObject.getString("projectid"));
            cv.put(MilestoneTable.MILESTONEID, jsonObject.getString("milestoneid"));
            cv.put(MilestoneTable.DESCRIPTION, jsonObject.getString("description"));
            cv.put(MilestoneTable.NAME, jsonObject.getString("milestonename"));
            cv.put(MilestoneTable.TAG, jsonObject.getString("tag_id"));
            cv.put(MilestoneTable.STARTDATE, jsonObject.getString("startdate"));
            cv.put(MilestoneTable.ENDDATE, jsonObject.getString("enddate"));
            cv.put(MilestoneTable.RESPONSIBLEPERSON, jsonObject.getString("mresponsible").toLowerCase());
            cv.put(MilestoneTable.CREATEDBY, jsonObject.getString("createdby").toLowerCase());
            cv.put(MilestoneTable.CREATEDBYTYPE, jsonObject.getString("createdbytype"));
            cv.put(MilestoneTable.CREATEDDATETIME, jsonObject.getString("createdatetime"));
            cv.put(MilestoneTable.UPDATEDATETIME, jsonObject.getString("updateddatetime"));
            cv.put(MilestoneTable.DELETED, jsonObject.getString(MilestoneTable.DELETED));
            sdb.insertWithOnConflict(MilestoneTable.TABLENAME, null, cv, 5);
        }
        sdb.close();
    }

    public void insertTaskLists(JSONArray jsonArray) throws Exception {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(TasklistTable.PROJECTID, jsonObject.getString("projectid"));
            cv.put(TasklistTable.MILESTONEID, jsonObject.getString("milestoneid"));
            cv.put(TasklistTable.TASKLISTID, jsonObject.getString("tasklistid"));
            cv.put(TasklistTable.DESCRIPTION, jsonObject.getString("description"));
            cv.put(TasklistTable.NAME, jsonObject.getString("tasklistname"));
            cv.put(TasklistTable.RESPONSIBLEPERSON, jsonObject.getString("lresponsible").toLowerCase());
            cv.put(TasklistTable.CREATEDBY, jsonObject.getString("createdby").toLowerCase());
            cv.put(TasklistTable.CREATEDBYTYPE, jsonObject.getString("createdbytype"));
            cv.put(TasklistTable.CREATEDDATETIME, jsonObject.getString("createdatetime"));
            cv.put(TasklistTable.UPDATEDATETIME, jsonObject.getString("updateddatetime"));
            cv.put(TasklistTable.DELETED, jsonObject.getString(TasklistTable.DELETED));
            sdb.insertWithOnConflict(TasklistTable.TABLENAME, null, cv, 5);
        }
        sdb.close();
    }

    public void insertClients(JSONArray jsonArray) throws Exception {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(ClientTable.COMPANYID, jsonObject.getString(ClientTable.COMPANYID));
            cv.put(ClientTable.COMPANYNAME, jsonObject.getString(ClientTable.COMPANYNAME));
            cv.put(ClientTable.ADDRESS, jsonObject.getString(ClientTable.ADDRESS));
            cv.put(ClientTable.WEBADDRESS, jsonObject.getString(ClientTable.WEBADDRESS));
            cv.put(ClientTable.CREATEDBY, jsonObject.getString(ClientTable.CREATEDBY));
            cv.put(ClientTable.RESPONSIBLEPERSON, jsonObject.getString(ClientTable.RESPONSIBLEPERSON));
            cv.put(ClientTable.CREATEDBYTYPE, jsonObject.getString(ClientTable.CREATEDBYTYPE));
            cv.put(ClientTable.CREATEDDATETIME, jsonObject.getString(ClientTable.CREATEDDATETIME));
            cv.put(ClientTable.RESPONSIBLEPERSOSMOBILE, jsonObject.getString(ClientTable.RESPONSIBLEPERSOSMOBILE));
            cv.put(ClientTable.RESPONSIBLEMAIL, jsonObject.getString(ClientTable.RESPONSIBLEMAIL));
            cv.put(ClientTable.CEMAIL, jsonObject.getString(ClientTable.CEMAIL));
            cv.put(ClientTable.CMOBILE, jsonObject.getString(ClientTable.CMOBILE));
            cv.put(ClientTable.CPHONE, jsonObject.getString(ClientTable.CPHONE));
            sdb.insertWithOnConflict(ClientTable.TABLENAME, null, cv, 5);
        }
        sdb.close();
    }

    public void insertCategories(JSONArray jsonArray) throws Exception {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(CategoryTable.CATID, jsonObject.getString(CategoryTable.CATID));
            cv.put(CategoryTable.CATNAME, jsonObject.getString(CategoryTable.CATNAME));
            cv.put(CategoryTable.CATDESCRIPTION, jsonObject.getString(CategoryTable.CATDESCRIPTION));
            cv.put(CategoryTable.CREATEDBY, jsonObject.getString(CategoryTable.CREATEDBY));
            cv.put(CategoryTable.CREATEDBY, jsonObject.getString(CategoryTable.CREATEDBY));
            cv.put(CategoryTable.CREATEDBYTYPE, jsonObject.getString(CategoryTable.CREATEDBYTYPE));
            cv.put(CategoryTable.CREATEDBY, jsonObject.getString(CategoryTable.CREATEDBY));
            cv.put(CategoryTable.CREATEDDATETIME, jsonObject.getString(CategoryTable.CREATEDDATETIME));
            sdb.insertWithOnConflict(CategoryTable.TABLENAME, null, cv, 5);
        }
        sdb.close();
    }

    public void insertTasks(JSONArray jsonArray) throws Exception {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put("task_id", jsonObject.getString("task_id"));
            cv.put("task_name", jsonObject.getString("task_name"));
            cv.put("t_description", jsonObject.getString("t_description"));
            cv.put("t_project_id", jsonObject.getString("t_project_id"));
            cv.put("t_milestone_id", jsonObject.getString("t_milestone_id"));
            cv.put("listtask_id", jsonObject.getString("listtask_id"));
            cv.put("t_progress", jsonObject.getString("t_progress"));
            cv.put("t_start_date", jsonObject.getString("t_start_date"));
            cv.put("t_end_date", jsonObject.getString("t_end_date"));
            cv.put("t_priority", jsonObject.getString("t_priority"));
            cv.put("t_sequence", jsonObject.getString("t_sequence"));
            cv.put("t_status", jsonObject.getString("t_status"));
            cv.put("t_tag", jsonObject.getString("t_tag"));
            cv.put("t_created_by_mailid", jsonObject.getString("t_created_by_mailid").toLowerCase());
            cv.put("t_created_by_type", jsonObject.getString("t_created_by_type"));
            cv.put("completed_by", jsonObject.getString("completed_by"));
            cv.put("completed_by_type", jsonObject.getString("completed_by_type"));
            cv.put("completed_datetime", jsonObject.getString("completed_datetime"));
            cv.put("stalled_by", jsonObject.getString("stalled_by"));
            cv.put("stalled_by_type", jsonObject.getString("stalled_by_type"));
            cv.put("stalled_datetime", jsonObject.getString("stalled_datetime"));
            cv.put("stalled_reason", jsonObject.getString("stalled_reason"));
            cv.put("t_p_status", jsonObject.getString("t_p_status"));
            cv.put("stoppeddatetime", jsonObject.getString("stoppeddatetime"));
            cv.put("assigneddatetime", jsonObject.getString("assigneddatetime"));
            cv.put("lastupdatetime", jsonObject.getString("lastupdatetime"));
            cv.put("underprogressdatetime", jsonObject.getString("underprogressdatetime"));
            cv.put("t_datetime", jsonObject.getString("t_datetime"));
            cv.put("t_deleted", jsonObject.getString("t_deleted"));
            sdb.insertWithOnConflict("task", null, cv, 5);
        }
        sdb.close();
    }

    public void insertTags(JSONArray jsonArray) throws Exception {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(TagTable.TAGID, jsonObject.getString(TagTable.TAGID));
            cv.put(TagTable.TAGNAME, jsonObject.getString(TagTable.TAGNAME));
            cv.put(TagTable.WEIGHTAGE, jsonObject.getString(TagTable.WEIGHTAGE));
            cv.put(TagTable.CREATEDBY, jsonObject.getString(TagTable.CREATEDBY));
            cv.put(TagTable.CREATEDBYTYPE, jsonObject.getString(TagTable.CREATEDBYTYPE));
            cv.put(TagTable.CREATEDBY, jsonObject.getString(TagTable.CREATEDBY));
            cv.put(TagTable.CREATEDDATETIME, jsonObject.getString(TagTable.CREATEDDATETIME));
            sdb.insertWithOnConflict(TagTable.TABLENAME, null, cv, 5);
        }
        sdb.close();
    }

    public void insertEmplyoees(JSONArray jsonArray) throws Exception {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put(EmployeeTable.NAME, jsonObject.getString("employeename"));
            cv.put(EmployeeTable.EMAILID, jsonObject.getString("emailid").toLowerCase());
            sdb.insertWithOnConflict(EmployeeTable.TABLENAME, null, cv, 5);
        }
        sdb.close();
    }

    public void insertAssigns(JSONArray jsonArray) throws Exception {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put("assign_id", jsonObject.getString("assign_id"));
            cv.put("a_task_id", jsonObject.getString("a_task_id"));
            cv.put("employee_id", jsonObject.getString("employee_id").toLowerCase());
            cv.put("a_status", jsonObject.getString("a_status"));
            cv.put("a_datetime", jsonObject.getString("a_datetime"));
            cv.put("a_accepted_reject_datetime", jsonObject.getString("a_accepted_reject_datetime"));
            cv.put("ar_latitude", jsonObject.getString("ar_latitude"));
            cv.put("ar_longitude", jsonObject.getString("ar_longitude"));
            cv.put("underprogress_datetime", jsonObject.getString("underprogress_datetime"));
            cv.put("u_latitude", jsonObject.getString("u_latitude"));
            cv.put("u_longitude", jsonObject.getString("u_longitude"));
            cv.put("stopped_datetime", jsonObject.getString("stopped_datetime"));
            cv.put("rejected_stopped_reason", jsonObject.getString("rejected_stopped_reason"));
            cv.put("stopped_longitude", jsonObject.getString("stopped_longitude"));
            cv.put("stopped_latitude", jsonObject.getString("stopped_latitude"));
            cv.put("updateddatetime", jsonObject.getString("updateddatetime"));
            cv.put("a_deleted", jsonObject.getString("a_deleted"));
            sdb.insertWithOnConflict("assign", null, cv, 5);
        }
        sdb.close();
    }

    public void insertProgress(JSONArray jsonArray) throws Exception {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = new ContentValues();
            cv.put("task_id", jsonObject.getString("task_id"));
            cv.put("progress_by_type", jsonObject.getString("progress_by_type"));
            cv.put("progress_by", jsonObject.getString("progress_by"));
            cv.put("employee_id", jsonObject.getString("employee_id"));
            cv.put("progress_date", jsonObject.getString("progress_date"));
            cv.put("progress", jsonObject.getString("progress"));
            cv.put("completed_activities", jsonObject.getString("completed_activities"));
            cv.put("progressImage", jsonObject.getString("progressImage"));
            cv.put("dateandtime", jsonObject.getString("dateandtime"));
            sdb.insertWithOnConflict("progress", null, cv, 5);
        }
        sdb.close();
    }

    public void deleteAllProjects() {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        sdb.delete(ProjectTable.TABLENAME, "1", null);
        sdb.close();
    }

    public void deleteMilestones(String projectId) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "DELETE FROM " + MilestoneTable.TABLENAME + " WHERE " + MilestoneTable.PROJECTID + "='" + projectId + "'";
        sdb.rawQuery(query, null);
        sdb.close();
    }

    public void deleteTask(String id2) {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        String query = "UPDATE task SET t_deleted='yes' WHERE task_id='" + id2 + "'";
        sdb.rawQuery(query, null);
        sdb.close();
    }

    public void deleteTasklist(String id2) {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        String query = "UPDATE " + TasklistTable.TABLENAME + " SET " + TasklistTable.DELETED + "='yes' WHERE " + TasklistTable.TASKLISTID + "='" + id2 + "'";
        sdb.rawQuery(query, null);
        sdb.close();
    }

    public void deleteMilestone(String id2) {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        String query = "UPDATE " + MilestoneTable.TABLENAME + " SET " + MilestoneTable.DELETED + "='yes' WHERE " + MilestoneTable.MILESTONEID + "='" + id2 + "'";
        sdb.rawQuery(query, null);
        sdb.close();
    }

    public void deleteProject(String id2) {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        String query = "UPDATE " + ProjectTable.TABLENAME + " SET " + ProjectTable.DELETED + "='yes' WHERE " + ProjectTable.PROJECTID + "='" + id2 + "'";
        sdb.rawQuery(query, null);
        sdb.close();
    }

    public void deleteTasklists(String projectId) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "DELETE FROM " + TasklistTable.TABLENAME + " WHERE " + TasklistTable.PROJECTID + "='" + projectId + "'";
        sdb.rawQuery(query, null);
        sdb.close();
    }

    public JSONArray getProjectsList() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM " + ProjectTable.TABLENAME;
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    try {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("projectid", (Object)cursor.getString(cursor.getColumnIndex(ProjectTable.PROJECTID)));
                        jsonObject.put("udatetime", (Object)cursor.getString(cursor.getColumnIndex(ProjectTable.UPDATEDATETIME)));
                        jsonArray.put((Object)jsonObject);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getTasksList(String id2, boolean byProject) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = byProject ? "SELECT * FROM task WHERE t_project_id='" + id2 + "'" : "SELECT * FROM task WHERE listtask_id='" + id2 + "'";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    try {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("id", (Object)cursor.getString(cursor.getColumnIndex("task_id")));
                        jsonObject.put("dt", (Object)cursor.getString(cursor.getColumnIndex("lastupdatetime")));
                        jsonArray.put((Object)jsonObject);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getTasksListBystatus(String id2, String status) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM task WHERE t_project_id='" + id2 + "' AND " + "t_status" + "='" + status + "'";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    try {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("id", (Object)cursor.getString(cursor.getColumnIndex("task_id")));
                        jsonObject.put("dt", (Object)cursor.getString(cursor.getColumnIndex("lastupdatetime")));
                        jsonArray.put((Object)jsonObject);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getTasksByStatus(String id2, String status, String employee) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM task LEFT JOIN assign ON a_task_id=task_id AND a_status!=('declined' AND 'stalled' AND 'stopped') AND a_deleted='no' INNER JOIN " + TasklistTable.TABLENAME + " ON " + TasklistTable.TASKLISTID + "=" + "listtask_id" + " AND " + TasklistTable.DELETED + "='no' INNER JOIN " + MilestoneTable.TABLENAME + " ON " + MilestoneTable.MILESTONEID + "=" + TasklistTable.MILESTONEID + " AND " + MilestoneTable.DELETED + "='no' INNER JOIN " + ProjectTable.TABLENAME + " ON " + ProjectTable.PROJECTID + "=" + MilestoneTable.PROJECTID + " AND " + ProjectTable.DELETED + "='no' WHERE " + "t_project_id" + "='" + id2 + "' AND " + "t_deleted" + "='no' AND ";
        query = employee != null ? query + "employee_id" + "='" + employee + "' AND (" : query + " ( ";
        query = status.equalsIgnoreCase("underprogress") ? query + "t_status" + "='underprogress' AND " + "t_end_date" + ">='" + DateUtils.getCurrentDate() + "' )" : (status.equalsIgnoreCase("late") ? query + "t_status" + "='underprogress' AND " + "t_end_date" + "<'" + DateUtils.getCurrentDate() + "' )" : (status.equalsIgnoreCase("completed") ? query + "t_status" + "='" + status + "' OR (" + "t_status" + "='underprogress' AND " + "t_progress" + ">89)) ORDER BY " + "t_progress" + " DESC" : query + "t_status" + "='" + status + "')"));
        Cursor cursor = sdb.rawQuery(query, null);
        return Database.cursorToArray(cursor);
    }

    public JSONArray getProjects() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM " + ProjectTable.TABLENAME + " WHERE " + ProjectTable.DELETED + "='no'";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    try {
                        jsonArray.put((Object)Database.cursorToJson(cursor));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getProjects(String id2) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM task LEFT JOIN " + ProjectTable.TABLENAME + " ON " + "t_project_id" + "=" + ProjectTable.PROJECTID + " LEFT JOIN " + "assign" + " ON " + "a_task_id" + "=" + "task_id" + " AND " + "a_deleted" + "='no'  WHERE (" + ProjectTable.RESPONSIBLEPERSON + "='" + id2 + "' OR " + "employee_id" + "='" + id2 + "')  AND " + "a_status" + "!=('declined' AND 'stalled' AND 'stopped') AND " + "t_status" + "!=('stopped' AND 'stalled') GROUP BY " + ProjectTable.PROJECTID;
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    try {
                        jsonArray.put((Object)Database.cursorToJson(cursor));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public String getProjectResponsible(String projectId) {
        return this.getProjectColumn(projectId, ProjectTable.RESPONSIBLEPERSON);
    }

    public String getProjectName(String projectId) {
        return this.getProjectColumn(projectId, ProjectTable.PROJECTNAME);
    }

    public String getMilestoneName(String id2) {
        return this.getMilestoneColumn(id2, MilestoneTable.NAME);
    }

    public String getMilestoneColumn(String id2, String column) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM " + MilestoneTable.TABLENAME + " WHERE " + MilestoneTable.MILESTONEID + "='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(column));
            }
            cursor.close();
        }
        return "";
    }

    public String getTasklistColumn(String id2, String column) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM " + TasklistTable.TABLENAME + " WHERE " + TasklistTable.TASKLISTID + "='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(column));
            }
            cursor.close();
        }
        return "";
    }

    public String getProjectColumn(String id2, String column) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM " + ProjectTable.TABLENAME + " WHERE " + ProjectTable.PROJECTID + "='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(column));
            }
            cursor.close();
        }
        return "";
    }

    public String getTaskListName(String id2) {
        return this.getTasklistColumn(id2, TasklistTable.NAME);
    }

    public String getTaskName(String id2) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM task WHERE task_id='" + id2 + "'";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex("task_name"));
            }
            cursor.close();
        }
        return "";
    }

    public String getTagName(String id2) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM " + TagTable.TABLENAME + " WHERE " + TagTable.TAGID + "='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(TagTable.TAGNAME));
            }
            cursor.close();
        }
        return "";
    }

    public String getCategoryName(String id2) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM " + CategoryTable.TABLENAME + " WHERE " + CategoryTable.CATID + "='" + id2 + "'";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(CategoryTable.CATNAME));
            }
            cursor.close();
        }
        return "";
    }

    public String getClientName(String id2) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM " + ClientTable.TABLENAME + " WHERE " + ClientTable.COMPANYID + "='" + id2 + "'";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex(ClientTable.COMPANYNAME));
            }
            cursor.close();
        }
        return "";
    }

    public String getEmployeeName(String id2) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM " + EmployeeTable.TABLENAME + " WHERE " + EmployeeTable.EMAILID + "='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                if (cursor.getString(cursor.getColumnIndex(EmployeeTable.NAME)).equalsIgnoreCase(Preference.getInstance(mContext).getEmailId())) {
                    return "Me";
                }
                return cursor.getString(cursor.getColumnIndex(EmployeeTable.NAME));
            }
            cursor.close();
        }
        return "";
    }

    public JSONArray getUnnasiignedTasks(String id2) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM task WHERE t_project_id='" + id2 + "' AND " + "t_status" + "='unassigned'";
        Cursor cursor = sdb.rawQuery(query, null);
        return Database.cursorToArray(cursor);
    }

    public JSONArray getMilestones(String projectid) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM " + MilestoneTable.TABLENAME + " LEFT JOIN " + EmployeeTable.TABLENAME + " ON " + EmployeeTable.EMAILID + "=" + MilestoneTable.RESPONSIBLEPERSON + " WHERE " + MilestoneTable.PROJECTID + "='" + projectid + "' AND " + MilestoneTable.DELETED + "='no'";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    try {
                        jsonArray.put((Object)Database.cursorToJson(cursor));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getTaskLists(String projectid) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM " + TasklistTable.TABLENAME + " INNER JOIN " + EmployeeTable.TABLENAME + " ON " + EmployeeTable.EMAILID + "=" + TasklistTable.RESPONSIBLEPERSON + " INNER JOIN " + MilestoneTable.TABLENAME + " ON " + MilestoneTable.MILESTONEID + "=" + TasklistTable.MILESTONEID + " WHERE " + TasklistTable.PROJECTID + "='" + projectid + "' AND " + MilestoneTable.DELETED + "='no' AND " + TasklistTable.DELETED + "='no' ORDER BY " + TasklistTable.MILESTONEID + " ASC";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    try {
                        jsonArray.put((Object)Database.cursorToJson(cursor));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getProgressList(String id2) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM progress WHERE task_id='" + id2 + "'";
        Cursor cursor = sdb.rawQuery(query, null);
        return Database.cursorToArray(cursor);
    }

    public JSONArray getMilestonesList(String projectid) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM " + MilestoneTable.TABLENAME + " WHERE " + MilestoneTable.PROJECTID + "='" + projectid + "'";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    try {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("id", (Object)cursor.getString(cursor.getColumnIndex(MilestoneTable.MILESTONEID)));
                        jsonObject.put("dt", (Object)cursor.getString(cursor.getColumnIndex(MilestoneTable.UPDATEDATETIME)));
                        jsonArray.put((Object)jsonObject);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getTaskListLists(String projectid) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM " + TasklistTable.TABLENAME + " WHERE " + TasklistTable.PROJECTID + "='" + projectid + "'";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    jsonArray.put((Object)cursor.getString(cursor.getColumnIndex(TasklistTable.TASKLISTID)));
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getAssignedTasks(String tasklist) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM task WHERE listtask_id='" + tasklist + "' AND " + "t_status" + "='assigned' ";
        Cursor cursor = sdb.rawQuery(query, null);
        return Database.cursorToArray(cursor);
    }

    public JSONArray getNewTasks(String tasklist, String email) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM task INNER JOIN assign ON task_id=a_task_id WHERE listtask_id='" + tasklist + "' AND " + "a_status" + "='YetToAccept' AND " + "a_deleted" + "='no' AND " + "a_deleted" + "='no' AND " + "t_deleted" + "='no'";
        if (!email.isEmpty()) {
            query = query + " AND " + "employee_id" + "='" + email + "'";
        }
        query = query + " ORDER BY " + "a_datetime" + " ASC";
        Cursor cursor = sdb.rawQuery(query, null);
        return Database.cursorToArray(cursor);
    }

    public JSONArray getPendingTasks(String tasklist, String email) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM task INNER JOIN assign ON task_id=a_task_id WHERE listtask_id='" + tasklist + "' AND ((" + "t_status" + "='underprogress' AND " + "t_end_date" + ">='" + DateUtils.getCurrentDate() + "') OR (" + "t_start_date" + "<='" + DateUtils.getCurrentDate() + "' AND " + "t_end_date" + ">='" + DateUtils.getCurrentDate() + "' AND " + "a_status" + "='accepted' )) AND " + "a_deleted" + "='no' AND " + "a_status" + "!='YetToAccept' AND " + "t_deleted" + "='no'";
        if (!email.isEmpty()) {
            query = query + " AND " + "employee_id" + "='" + email + "'";
        }
        query = query + " ORDER BY " + "t_end_date" + "," + "a_datetime" + " ASC";
        Cursor cursor = sdb.rawQuery(query, null);
        return Database.cursorToArray(cursor);
    }

    public JSONArray getUpcomingTasks(String tasklist, String email) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM task LEFT JOIN assign ON task_id=a_task_id WHERE listtask_id='" + tasklist + "' AND " + "a_status" + "='accepted' AND " + "t_start_date" + ">'" + DateUtils.getCurrentDate() + "' AND " + "t_progress" + "='0' AND " + "a_deleted" + "='no' AND " + "t_deleted" + "='no'";
        if (!email.isEmpty()) {
            query = query + " AND " + "employee_id" + "='" + email + "'";
        }
        query = query + " ORDER BY " + "t_start_date" + "," + "a_datetime" + " ASC";
        Cursor cursor = sdb.rawQuery(query, null);
        return Database.cursorToArray(cursor);
    }

    public JSONArray getCompletedTasks(String tasklist, String email) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM task LEFT JOIN assign ON task_id=a_task_id WHERE listtask_id='" + tasklist + "' AND " + "t_status" + "='completed' AND " + "a_deleted" + "='no' AND " + "t_deleted" + "='no'";
        if (!email.isEmpty()) {
            query = query + " AND " + "employee_id" + "='" + email + "'";
        }
        query = query + " ORDER BY " + "completed_datetime" + " DESC";
        Cursor cursor = sdb.rawQuery(query, null);
        return Database.cursorToArray(cursor);
    }

    public JSONArray getLateTasks(String tasklist, String email) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM task INNER JOIN assign ON task_id=a_task_id WHERE listtask_id='" + tasklist + "' AND ((" + "t_status" + "='underprogress' AND " + "t_end_date" + "<'" + DateUtils.getCurrentDate() + "') OR (" + "t_end_date" + "<'" + DateUtils.getCurrentDate() + "' AND " + "a_status" + "='accepted'  )) AND " + "a_deleted" + "='no' AND " + "t_deleted" + "='no'";
        if (!email.isEmpty()) {
            query = query + " AND " + "employee_id" + "='" + email + "'";
        }
        query = query + " ORDER BY " + "t_end_date" + "," + "a_datetime" + " ASC";
        Cursor cursor = sdb.rawQuery(query, null);
        return Database.cursorToArray(cursor);
    }

    public JSONArray getTodayTasks(String tasklist, String email) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM task INNER JOIN assign ON task_id=a_task_id WHERE listtask_id='" + tasklist + "' AND ((" + "t_status" + "='underprogress' AND " + "t_end_date" + "='" + DateUtils.getCurrentDate() + "') OR (" + "t_end_date" + "='" + DateUtils.getCurrentDate() + "' AND " + "a_status" + "='accepted'  )) AND " + "a_deleted" + "='no' AND " + "t_deleted" + "='no'";
        if (!email.isEmpty()) {
            query = query + " AND " + "employee_id" + "='" + email + "'";
        }
        query = query + " ORDER BY " + "t_end_date" + "," + "a_datetime" + " ASC";
        Cursor cursor = sdb.rawQuery(query, null);
        return Database.cursorToArray(cursor);
    }

    public JSONObject getTaskDetails(String taskId) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM task LEFT JOIN assign ON task_id=a_task_id AND a_status!=('stopped' AND 'rejected') AND a_deleted='no'  WHERE task_id='" + taskId + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return Database.cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getAssignDetails(String id2) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM task INNER JOIN assign ON task_id=a_task_id WHERE assign_id='" + id2 + "' AND " + "a_status" + "!='stopped' AND " + "a_status" + "!='rejected'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return Database.cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getWorkingPerson(String id2) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM task INNER JOIN assign ON task_id=a_task_id WHERE task_id='" + id2 + "' AND " + "a_status" + "!='stopped' AND " + "a_status" + "!='rejected'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return Database.cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getMilestoneDetails(String id2) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM " + MilestoneTable.TABLENAME + " WHERE " + MilestoneTable.MILESTONEID + "='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return Database.cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getTasklsitDetails(String id2) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM " + TasklistTable.TABLENAME + " WHERE " + TasklistTable.TASKLISTID + "='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return Database.cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getTagDetails(String id2) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM " + TagTable.TABLENAME + " WHERE " + TagTable.TAGID + "='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return Database.cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getClientDetails(String id2) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM " + ClientTable.TABLENAME + " WHERE " + ClientTable.COMPANYID + "='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return Database.cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getCategoryDetails(String id2) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM " + CategoryTable.TABLENAME + " WHERE " + CategoryTable.CATID + "='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return Database.cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public JSONObject getProjectDetails(String id2) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM " + ProjectTable.TABLENAME + " WHERE " + ProjectTable.PROJECTID + "='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return Database.cursorToJson(cursor);
            }
            cursor.close();
        }
        return null;
    }

    public boolean isMilestoneCompleted(String milestoneid) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        boolean isMilestoneCompleted = true;
        String query = "SELECT * FROM " + MilestoneTable.TABLENAME + " LEFT JOIN " + "task" + " ON " + "t_milestone_id" + "=" + MilestoneTable.MILESTONEID + " WHERE " + "t_milestone_id" + "='" + milestoneid + "' AND " + "t_status" + "!='completed'";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null && cursor.getCount() > 0) {
            isMilestoneCompleted = false;
            cursor.close();
        }
        return isMilestoneCompleted;
    }

    public boolean isResponsibleForAnyProject(String id2) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        boolean isResponsibleForAnyProject = false;
        String query = "SELECT * FROM " + ProjectTable.TABLENAME + " WHERE " + ProjectTable.RESPONSIBLEPERSON + "='" + id2 + "' ";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null && cursor.getCount() > 0) {
            isResponsibleForAnyProject = true;
            cursor.close();
        }
        return isResponsibleForAnyProject;
    }

    public boolean isResponsibleForThisProject(String projectid, String emailid) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM " + ProjectTable.TABLENAME + " WHERE " + ProjectTable.RESPONSIBLEPERSON + "='" + emailid + "' AND " + ProjectTable.PROJECTID + "='" + projectid + "'", null);
        if (cursor != null && cursor.getCount() > 0) {
            cursor.close();
            return true;
        }
        return false;
    }

    private static JSONObject cursorToJson(Cursor c) throws JSONException {
        JSONObject retVal = new JSONObject();
        block6: for (int i = 0; i < c.getColumnCount(); ++i) {
            String cName = c.getColumnName(i);
            switch (c.getType(i)) {
                case 1: {
                    retVal.put(cName, c.getInt(i));
                    continue block6;
                }
                case 2: {
                    retVal.put(cName, (double)c.getFloat(i));
                    continue block6;
                }
                case 3: {
                    retVal.put(cName, (Object)c.getString(i));
                    continue block6;
                }
                case 4: {
                    retVal.put(cName, (Object)Utility.getString(c.getBlob(i)));
                }
            }
        }
        return retVal;
    }

    private static JSONArray cursorToArray(Cursor c) {
        JSONArray jsonArray = new JSONArray();
        if (c != null) {
            if (c.getCount() > 0) {
                c.moveToFirst();
                do {
                    try {
                        jsonArray.put((Object)Database.cursorToJson(c));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (c.moveToNext());
            }
            c.close();
        }
        return jsonArray;
    }
}

