/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.sql;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.encap.Notes;
import com.b2lmobitech.fieldcloudplus.task.encap.NotificationEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.RequestEncap;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.enums.TaskEnum;
import com.b2lmobitech.fieldcloudplus.task.enums.YesNo;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class Sqlite
extends SQLiteOpenHelper {
    public static final int DATABASE_VERSION = 3;
    public static final String DATABASE_NAME = "FieldCloudDesk.db3";
    Context context;

    public Sqlite(Context context) {
        super(context, DATABASE_NAME, null, 3);
        this.context = context;
    }

    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        sqLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS task_notes (_id INTEGER PRIMARY KEY ,datetime TEXT,title TEXT,description TEXT,CONSTRAINT request_unique UNIQUE (datetime));");
    }

    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int i, int i1) {
        sqLiteDatabase.execSQL("CREATE TABLE IF NOT EXISTS task_notes (_id INTEGER PRIMARY KEY ,datetime TEXT,title TEXT,description TEXT,CONSTRAINT request_unique UNIQUE (datetime));");
    }

    public void insert_task(TaskEncap taskEncap) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        Log.e((String)"Table", (String)"newly inserted");
        try {
            ContentValues cv = new ContentValues();
            cv.put("taskid", taskEncap.getTaskid());
            cv.put("taskanme", taskEncap.getTaskname());
            cv.put("listtaskid", taskEncap.getListtaskid());
            cv.put("milestoneid", taskEncap.getMilestoneid());
            cv.put("projectid", taskEncap.getProjctid());
            cv.put("proejctname", taskEncap.getProjectname());
            cv.put("startdate", taskEncap.getStartdate());
            cv.put("enddate", taskEncap.getEnddatte());
            cv.put("progress", taskEncap.getProgress());
            cv.put("description", taskEncap.getDescription());
            cv.put("priority", taskEncap.getPriotity());
            cv.put("updatedatetime", taskEncap.getUpdateddatetime());
            cv.put("deleted", taskEncap.getPriotity());
            cv.put("assignid", taskEncap.getAssignid());
            cv.put("t_status", taskEncap.getStatus());
            cv.put("a_status", taskEncap.getAssign_status());
            cv.put("underprogressdatetime", taskEncap.getUnderprogressdatetime());
            cv.put("emailid", taskEncap.getEmail_id().toLowerCase());
            cv.put("assigneddatetime", taskEncap.getAssigneddatetime());
            cv.put("onlinesync", taskEncap.getOnline_sync());
            cv.put("sequence", taskEncap.getSequence());
            cv.put("localsync", String.valueOf((Object)YesNo.NO));
            sdb.insertWithOnConflict("task_task", null, cv, 5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean taskTableHaveData() throws SQLException {
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM task_task", null);
        return mCursor != null && mCursor.getCount() > 0;
    }

    public Cursor get_tasks() throws SQLException {
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM task_task ORDER BY penddate DESC", null);
        if (mCursor != null && mCursor.getCount() > 0) {
            return mCursor;
        }
        return null;
    }

    public ArrayList<TaskEncap> getAllTasks(String emaild) {
        ArrayList<TaskEncap> arrayList = new ArrayList<TaskEncap>();
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor cursor = sdb.rawQuery("SELECT * FROM task_task", null);
        try {
            if (cursor != null) {
                arrayList = this.cursor2array(cursor);
                cursor.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arrayList;
    }

    public Cursor get_tasks(String projectid, String emailid) throws SQLException {
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM task_task WHERE projectid='" + projectid + "' AND " + "emailid" + "='" + emailid + "' ORDER BY assigneddatetime DESC", null);
        if (mCursor != null && mCursor.getCount() > 0) {
            return mCursor;
        }
        return null;
    }

    public ArrayList<TaskEncap> get_tasks_byproject(String projectid, String emailid) throws SQLException {
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM task_task WHERE projectid='" + projectid + "' AND " + "emailid" + "='" + emailid + "' ORDER BY assigneddatetime DESC", null);
        ArrayList<TaskEncap> arrayList = new ArrayList<TaskEncap>();
        if (mCursor != null) {
            try {
                arrayList = this.cursor2array(mCursor);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            mCursor.close();
        }
        return arrayList;
    }

    public ArrayList<TaskEncap> get_tasks_bylsit(String projectid, String emailid) throws SQLException {
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM task_task WHERE listtaskid='" + projectid + "' AND " + "emailid" + "='" + emailid + "' ORDER BY assigneddatetime DESC", null);
        ArrayList<TaskEncap> arrayList = new ArrayList<TaskEncap>();
        if (mCursor != null) {
            try {
                arrayList = this.cursor2array(mCursor);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            mCursor.close();
        }
        return arrayList;
    }

    public Cursor getTask(String taskid) throws SQLException {
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM task_task WHERE taskid='" + taskid + "'", null);
        if (mCursor != null && mCursor.getCount() > 0) {
            return mCursor;
        }
        return null;
    }

    public ArrayList<TaskEncap> getTaskList(String projectid, String emailid) {
        ArrayList<TaskEncap> arrayList = new ArrayList<TaskEncap>();
        SQLiteDatabase sdb = this.getWritableDatabase();
        return arrayList;
    }

    public ArrayList<TaskEncap> getSingleTask(String taskid) {
        ArrayList<TaskEncap> arrayList = new ArrayList<TaskEncap>();
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor cursor = sdb.rawQuery("SELECT * FROM task_task WHERE taskid='" + taskid + "'", null);
        if (cursor != null) {
            try {
                arrayList = this.cursor2array(cursor);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            cursor.close();
        }
        return arrayList;
    }

    public void updateTaskProgress(String taskid, String progress, String datetime) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("progress", progress);
        cv.put("updatedatetime", datetime);
        cv.put("localsync", "YES");
        sdb.update("task_task", cv, "taskid= ? ", new String[]{taskid});
    }

    public void updateTaskAccepted(String taskid) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("t_status", "accepted");
        cv.put("a_status", "accepted");
        sdb.update("task_task", cv, "taskid= ? ", new String[]{taskid});
    }

    public void updateProjectDetails(JSONObject jsonObject) throws JSONException {
        SQLiteDatabase sdb = this.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("pdescription", jsonObject.getString("p_description"));
        cv.put("pstartdate", jsonObject.getString("p_start_date"));
        cv.put("penddate", jsonObject.getString("p_end_date"));
        cv.put("proejctname", jsonObject.getString("project_name"));
        sdb.update("task_task", cv, "projectid= ? ", new String[]{jsonObject.getString("project_id")});
    }

    public void updateMilestoneDatails(JSONObject jsonObject) throws JSONException {
        SQLiteDatabase sdb = this.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("milestonename", jsonObject.getString("milestone_name"));
        cv.put("mdescription", jsonObject.getString("m_description"));
        cv.put("menddate", jsonObject.getString("m_end_date"));
        sdb.update("task_task", cv, "milestoneid= ? ", new String[]{jsonObject.getString("milestone_id")});
    }

    public void updateListtask(JSONObject jsonObject) throws JSONException {
        SQLiteDatabase sdb = this.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("listtaskname", jsonObject.getString("listtask_name"));
        sdb.update("task_task", cv, "listtaskid= ? ", new String[]{jsonObject.getString("listtask_id")});
    }

    public Cursor getTasksNotUpdated() throws SQLException {
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM task_task WHERE localsync='YES'", null);
        if (mCursor != null && mCursor.getCount() > 0) {
            return mCursor;
        }
        return null;
    }

    public void updateTaskSynced(String taskid) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("localsync", "NO");
        sdb.update("leavetable", cv, "taskid = ? ", new String[]{taskid});
    }

    public void deleteAllTasks() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.execSQL("DROP TABLE IF EXISTS task_task");
        db.execSQL("CREATE TABLE IF NOT EXISTS task_task (_id INTEGER PRIMARY KEY ,taskid TEXT,taskanme TEXT,listtaskid TEXT,listtaskname TEXT,milestoneid TEXT,milestonename TEXT,menddate TEXT,mdescription TEXT,projectid TEXT,proejctname TEXT,pstartdate TEXT,penddate TEXT,pdescription TEXT,emailid TEXT,startdate TEXT DEFAULT '0000-00-00',enddate TEXT DEFAULT '0000-00-00',progress TEXT,description TEXT,priority TEXT,assignid TEXT,a_status TEXT,t_status TEXT,underprogressdatetime TEXT DEFAULT '0000-00-00 00:00:00',assigneddatetime TEXT DEFAULT '0000-00-00 00:00:00',updatedatetime TEXT DEFAULT '0000-00-00 00:00:00',deleted TEXT,localsync TEXT DEFAULT '" + (Object)((Object)YesNo.NO) + "'," + "onlinesync" + " TEXT," + "fav" + " TEXT DEFAULT '" + (Object)((Object)YesNo.NO) + "'," + "sequence" + " TEXT,CONSTRAINT task_unique UNIQUE (" + "assignid" + "," + "taskid" + "));");
    }

    public void insertTaskProgress(String taskid, String emailid, String progressdate, String progress, String completedactivities, String datetime, String sync2, String latitude, String longitude) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("task_id", taskid);
        cv.put("employee_id", emailid);
        cv.put("progress_date", progressdate);
        cv.put("progress", progress);
        cv.put("completed_activities", completedactivities);
        cv.put("completed_datetime", datetime);
        cv.put("progressedbytype", "user");
        cv.put("progressedby", "no data available");
        cv.put("latitue", latitude);
        cv.put("longitude", longitude);
        cv.put("sync", sync2);
        sdb.insert("task_progress", null, cv);
    }

    public void insertTaskProgressWithImage(String taskid, String emailid, String progressdate, String progress, String completedactivities, String datetime, String sync2, String latitude, String longitude, String image) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("task_id", taskid);
        cv.put("employee_id", emailid);
        cv.put("progress_date", progressdate);
        cv.put("progress", progress);
        cv.put("completed_activities", completedactivities);
        cv.put("completed_datetime", datetime);
        cv.put("image", image);
        cv.put("progressedbytype", "user");
        cv.put("progressedby", "no data available");
        cv.put("latitue", latitude);
        cv.put("longitude", longitude);
        cv.put("sync", sync2);
        sdb.insert("task_progress", null, cv);
    }

    public void insertTaskProgress(JSONObject jsonObject) throws JSONException {
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor isTaskAlreadyInserted = sdb.rawQuery("SELECT * FROM task_progress WHERE task_id='" + jsonObject.getString("task_id") + "' AND " + "progress" + "='" + jsonObject.getString("progress") + "' AND " + "completed_datetime" + "='" + jsonObject.getString("completed_datetime") + "'", null);
        if (isTaskAlreadyInserted == null || isTaskAlreadyInserted.getCount() <= 0) {
            ContentValues cv = new ContentValues();
            cv.put("task_id", jsonObject.getString("task_id"));
            cv.put("employee_id", jsonObject.getString("employee_id"));
            cv.put("progress_date", jsonObject.getString("progress_date"));
            cv.put("progress", jsonObject.getString("progress"));
            cv.put("completed_activities", jsonObject.getString("completed_activities"));
            cv.put("completed_datetime", jsonObject.getString("completed_datetime"));
            cv.put("progressedby", jsonObject.getString("progress_by"));
            cv.put("progressedbytype", jsonObject.getString("progress_by_type"));
            cv.put("sync", "no");
            sdb.insert("task_progress", null, cv);
        }
    }

    public void deleteTask(String assignid) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        sdb.delete("task_task", "assignid = ? ", new String[]{assignid});
    }

    public Cursor getTaskProgress() {
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM task_progress WHERE sync='yes'", null);
        if (mCursor != null && mCursor.getCount() > 0) {
            return mCursor;
        }
        return null;
    }

    public Cursor getTaskProgress(String taskid) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM task_progress WHERE task_id='" + taskid + "'", null);
        if (mCursor != null && mCursor.getCount() > 0) {
            return mCursor;
        }
        return null;
    }

    public void updateProgressCompleted(String index) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("sync", "no");
        cv.put("image", "null");
        sdb.update("task_progress", cv, "_id = ? ", new String[]{index});
    }

    public void insertTaskRequest(String assignid, String employeeid, String status, String reason, String increasedays, String requestFor, String datetime) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("assignid", assignid);
        cv.put("employeeid", employeeid);
        cv.put("status", status);
        cv.put("reason", reason);
        cv.put("increasedays", increasedays);
        cv.put("requestdatetime", datetime);
        sdb.insert("task_request", null, cv);
        sdb.insertWithOnConflict("task_request", null, cv, 5);
    }

    public void insertOrUpdateTaskRequest(RequestEncap requestEncap) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("assignid", requestEncap.getAssignid());
        cv.put("employeeid", requestEncap.getEmployeeid());
        cv.put("status", requestEncap.getStatus());
        cv.put("reason", requestEncap.getReason());
        cv.put("increasedays", requestEncap.getIncreasedays());
        cv.put("requestdatetime", requestEncap.getRequestdatetime());
        cv.put("response", requestEncap.getResponse());
        cv.put("updateddatetime", requestEncap.getUpdateddatetime());
        long l = sdb.insertWithOnConflict("task_request", null, cv, 5);
    }

    public void insertNotifications(NotificationEncap notificationEncap) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("assign_id", notificationEncap.getAssignId());
        cv.put("task_id", notificationEncap.getTaskId());
        cv.put("datetime", notificationEncap.getDatetime());
        cv.put("type", notificationEncap.getType());
        cv.put("message", notificationEncap.getMessage());
        sdb.insert("task_notifications", null, cv);
    }

    public void updateNotificationOpened(NotificationEncap notificationEncap) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("opened", "yes");
        sdb.update("task_notifications", cv, "task_id = ? AND assign_id = ? AND datetime = ? ", new String[]{notificationEncap.getTaskId(), notificationEncap.getAssignId(), notificationEncap.getDatetime()});
    }

    public void updateRequest(JSONObject jsonObject) throws JSONException {
        SQLiteDatabase sdb = this.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("assignid", jsonObject.getString(""));
        cv.put("status", jsonObject.getString(""));
        cv.put("response", jsonObject.getString(""));
        cv.put("increasedays", jsonObject.getString(""));
        cv.put("requestfor", jsonObject.getString(""));
        cv.put("requestdatetime", jsonObject.getString(""));
        cv.put("requestdatetime", jsonObject.getString(""));
        sdb.insert("task_request", null, cv);
    }

    public Cursor getTaskRequestsList(String projectid) {
        String query;
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor mCursor = sdb.rawQuery(query = "SELECT * FROM task_request INNER JOIN task_task ON task_task.assignid=task_request.assignid WHERE projectid='" + projectid + "'", null);
        if (mCursor != null && mCursor.getCount() > 0) {
            return mCursor;
        }
        return null;
    }

    public RequestEncap getTaskRequestDetails(String assignid, String datetime) {
        String query;
        RequestEncap requestEncap = new RequestEncap();
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM task_request INNER JOIN task_task ON task_task.assignid=task_request.assignid WHERE task_task.assignid='" + assignid + "' AND requestdatetime='" + datetime + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                requestEncap.setTaskName(cursor.getString(cursor.getColumnIndex("taskanme")));
                requestEncap.setTaskId(cursor.getString(cursor.getColumnIndex("taskid")));
                requestEncap.setAssignid(cursor.getString(cursor.getColumnIndex("assignid")));
                requestEncap.setEmployeeid(cursor.getString(cursor.getColumnIndex("employeeid")));
                requestEncap.setStatus(cursor.getString(cursor.getColumnIndex("status")));
                requestEncap.setReason(cursor.getString(cursor.getColumnIndex("reason")));
                requestEncap.setRequestfor(cursor.getString(cursor.getColumnIndex("requestfor")));
                requestEncap.setRequestdatetime(cursor.getString(cursor.getColumnIndex("requestdatetime")));
                requestEncap.setResponse(cursor.getString(cursor.getColumnIndex("response")));
                requestEncap.setProjectId(cursor.getString(cursor.getColumnIndex("listtaskid")));
                requestEncap.setIncreasedays(cursor.getString(cursor.getColumnIndex("increasedays")));
                requestEncap.setUpdateddatetime(cursor.getString(cursor.getColumnIndex("updateddatetime")));
                this.context.getSharedPreferences("projectid", 0).edit().putString("projectid", cursor.getString(cursor.getColumnIndex("projectid"))).apply();
                return requestEncap;
            }
            cursor.close();
        }
        return null;
    }

    public ArrayList<RequestEncap> getRequestList(String projectid) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        ArrayList<RequestEncap> requestEncaps = new ArrayList<RequestEncap>();
        String query = "SELECT * FROM task_request INNER JOIN task_task ON task_task.assignid=task_request.assignid WHERE listtaskid='" + projectid + "' ORDER BY " + "requestdatetime" + " DESC";
        Cursor cursor = sdb.rawQuery(query, null);
        int i = 0;
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    ++i;
                    RequestEncap requestEncap = new RequestEncap();
                    requestEncap.setTaskName(cursor.getString(cursor.getColumnIndex("taskanme")));
                    requestEncap.setTaskId(cursor.getString(cursor.getColumnIndex("taskid")));
                    requestEncap.setAssignid(cursor.getString(cursor.getColumnIndex("assignid")));
                    requestEncap.setEmployeeid(cursor.getString(cursor.getColumnIndex("employeeid")));
                    requestEncap.setStatus(cursor.getString(cursor.getColumnIndex("status")));
                    requestEncap.setReason(cursor.getString(cursor.getColumnIndex("reason")));
                    requestEncap.setRequestdatetime(cursor.getString(cursor.getColumnIndex("requestdatetime")));
                    requestEncap.setResponse(cursor.getString(cursor.getColumnIndex("response")));
                    requestEncap.setIncreasedays(cursor.getString(cursor.getColumnIndex("increasedays")));
                    requestEncap.setUpdateddatetime(cursor.getString(cursor.getColumnIndex("updateddatetime")));
                    try {
                        requestEncaps.add(requestEncap);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return requestEncaps;
    }

    public Cursor getRequestStatus(String taskid) {
        String query;
        SQLiteDatabase sdb = this.getWritableDatabase();
        Cursor mCursor = sdb.rawQuery(query = "SELECT * FROM task_request INNER JOIN task_task ON task_task.assignid=task_request.assignid WHERE taskid='" + taskid + "' and status='pending'", null);
        if (mCursor != null && mCursor.getCount() > 0) {
            return mCursor;
        }
        return null;
    }

    public void deleteTaskRequest(String assign_id, String datetime) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        String where = "assignid=? AND requestdatetime=?";
        sdb.delete("task_request", where, new String[]{assign_id, datetime});
    }

    public void insert_Notes(String title, String Description, String datetime) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("title", title);
        if (datetime.isEmpty()) {
            cv.put("datetime", Utility.getCurrentDateTime());
        } else {
            cv.put("datetime", datetime);
        }
        cv.put("description", Description);
        sdb.insertWithOnConflict("task_notes", null, cv, 5);
    }

    public ArrayList<Notes> getNotes() {
        ArrayList<Notes> arrayList = new ArrayList<Notes>();
        SQLiteDatabase sdb = this.getWritableDatabase();
        String query = "SELECT * FROM task_notes ORDER BY datetime DESC";
        Cursor cursor = sdb.rawQuery(query, null);
        int i = 0;
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    ++i;
                    Notes notes = new Notes();
                    notes.setDatetime(cursor.getString(cursor.getColumnIndex("datetime")));
                    notes.setTitle(cursor.getString(cursor.getColumnIndex("title")));
                    notes.setDescription(cursor.getString(cursor.getColumnIndex("description")));
                    arrayList.add(notes);
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return arrayList;
    }

    public void deleteNotes(String datetime) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        sdb.delete("task_notes", "datetime = ? ", new String[]{datetime});
    }

    private ArrayList<TaskEncap> cursor2array(Cursor cursor) throws ParseException {
        ArrayList<TaskEncap> arrayList = new ArrayList<TaskEncap>();
        cursor.moveToFirst();
        if (cursor.getCount() == 0) {
            return arrayList;
        }
        do {
            TaskEncap taskEncap = new TaskEncap();
            taskEncap.setProjctid(cursor.getString(cursor.getColumnIndex("projectid")));
            taskEncap.setTaskid(cursor.getString(cursor.getColumnIndex("taskid")));
            taskEncap.setTaskname(cursor.getString(cursor.getColumnIndex("taskanme")));
            taskEncap.setAssignid(cursor.getString(cursor.getColumnIndex("assignid")));
            taskEncap.setEmail_id(cursor.getString(cursor.getColumnIndex("emailid")));
            taskEncap.setProjectname(cursor.getString(cursor.getColumnIndex("proejctname")));
            taskEncap.setMilestoneid(cursor.getString(cursor.getColumnIndex("milestoneid")));
            taskEncap.setMilestonename(cursor.getString(cursor.getColumnIndex("milestonename")));
            taskEncap.setListtaskid(cursor.getString(cursor.getColumnIndex("listtaskid")));
            taskEncap.setListtaskname(cursor.getString(cursor.getColumnIndex("listtaskname")));
            taskEncap.setAssigneddatetime(cursor.getString(cursor.getColumnIndex("assigneddatetime")));
            taskEncap.setDescription(cursor.getString(cursor.getColumnIndex("description")));
            taskEncap.setStatus(cursor.getString(cursor.getColumnIndex("t_status")));
            taskEncap.setAssign_status(cursor.getString(cursor.getColumnIndex("a_status")));
            taskEncap.setPriotity(cursor.getString(cursor.getColumnIndex("priority")));
            taskEncap.setStartdate(cursor.getString(cursor.getColumnIndex("startdate")));
            taskEncap.setEnddatte(cursor.getString(cursor.getColumnIndex("enddate")));
            taskEncap.setUpdateddatetime(cursor.getString(cursor.getColumnIndex("updatedatetime")));
            taskEncap.setSequence(cursor.getString(cursor.getColumnIndex("sequence")));
            taskEncap.setOnline_sync(cursor.getString(cursor.getColumnIndex("onlinesync")));
            taskEncap.setProgress(cursor.getString(cursor.getColumnIndex("progress")));
            taskEncap.setI_progress(Integer.parseInt(taskEncap.getProgress()));
            taskEncap.setD_assigneddatetime(Utility.getDateTime(taskEncap.getAssigneddatetime()));
            taskEncap.setD_startdate(Utility.getDateTime(taskEncap.getStartdate()));
            taskEncap.setD_enddatte(Utility.getDateTime(taskEncap.getEnddatte()));
            taskEncap.setUnderprogressdatetime(cursor.getString(cursor.getColumnIndex("underprogressdatetime")));
            taskEncap.setD_updateddatetime(Utility.getDateTime(taskEncap.getUpdateddatetime()));
            taskEncap.setProjectstartdate(cursor.getString(cursor.getColumnIndex("pstartdate")));
            taskEncap.setProjectenddate(cursor.getString(cursor.getColumnIndex("penddate")));
            taskEncap.setProjectdescription(cursor.getString(cursor.getColumnIndex("pdescription")));
            taskEncap.setMilestonedescription(cursor.getString(cursor.getColumnIndex("mdescription")));
            taskEncap.setMilestoneenddate(cursor.getString(cursor.getColumnIndex("menddate")));
            int dayend = Utility.daysbetween(taskEncap.getD_enddatte());
            if (taskEncap.getI_progress() == 100 && taskEncap.getStatus().equalsIgnoreCase("completed")) {
                taskEncap.setCategory(TaskEnum.COMPLETED);
            } else if (taskEncap.getAssign_status().trim().equalsIgnoreCase("yetToAccept")) {
                taskEncap.setCategory(TaskEnum.NEW);
            } else if (dayend != 0 && taskEncap.getD_enddatte().before(new Date())) {
                taskEncap.setCategory(TaskEnum.LATE);
            } else if (taskEncap.getD_startdate().after(new Date()) && taskEncap.getAssign_status().equalsIgnoreCase("accepted")) {
                taskEncap.setCategory(TaskEnum.UPCOMING);
            } else {
                taskEncap.setCategory(TaskEnum.ACTIVE);
            }
            arrayList.add(taskEncap);
        } while (cursor.moveToNext());
        return arrayList;
    }
}

